/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import js.lang.BugError;
import js.util.Classes;
import js.util.Params;

public class Types {
    private static Map<Type, Type> BOXING_MAP = new HashMap<Type, Type>();
    private static Type[] NUMERICAL_TYPES;
    private static final Pattern CLASS_NAME_PATTERN;

    protected Types() {
    }

    public static boolean equalsAny(Type t, Type ... typesToMatch) throws IllegalArgumentException {
        Params.notNullOrEmpty(typesToMatch, "Types to match");
        if (t == null) {
            return false;
        }
        for (Type typeToMatch : typesToMatch) {
            if (!t.equals(typeToMatch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKindOf(Type t, Type ... typesToMatch) throws IllegalArgumentException {
        Params.notNullOrEmpty(typesToMatch, "Types to match");
        for (Type typeToMatch : typesToMatch) {
            if (!Types.isKindOf(t, typeToMatch)) continue;
            return true;
        }
        return false;
    }

    private static boolean isKindOf(Type t, Type typeToMatch) {
        if (t == null || typeToMatch == null) {
            return false;
        }
        if (t.equals(typeToMatch)) {
            return true;
        }
        Class<?> clazz = Types.typeToClass(t);
        Class<?> classToMatch = Types.typeToClass(typeToMatch);
        if (clazz.isPrimitive()) {
            return BOXING_MAP.get(clazz) == classToMatch;
        }
        if (classToMatch.isPrimitive()) {
            return BOXING_MAP.get(classToMatch) == clazz;
        }
        return classToMatch.isAssignableFrom(clazz);
    }

    public static Class<?> getBoxingClass(Type t) throws BugError {
        Type boxingClass = BOXING_MAP.get(t);
        if (boxingClass == null) {
            if (!BOXING_MAP.values().contains(t)) {
                throw new BugError("Trying to get boxing class from not boxed type.", new Object[0]);
            }
            boxingClass = t;
        }
        return (Class)boxingClass;
    }

    public static boolean isInstanceOf(Object o, Type t) {
        if (o == null) {
            return false;
        }
        if (t instanceof Class) {
            Class clazz = (Class)t;
            if (clazz.isPrimitive()) {
                return BOXING_MAP.get(clazz) == o.getClass();
            }
            return clazz.isInstance(o);
        }
        return false;
    }

    public static boolean isConcrete(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            return Types.isConcrete(p.getRawType());
        }
        return false;
    }

    public static boolean isNumber(Object o) {
        return o != null && Types.isNumber(o.getClass());
    }

    public static boolean isNumber(Type t) {
        for (int i = 0; i < NUMERICAL_TYPES.length; ++i) {
            if (NUMERICAL_TYPES[i] != t) continue;
            return true;
        }
        return false;
    }

    public static boolean isCharacter(Object o) {
        return o != null && Types.isCharacter(o.getClass());
    }

    public static boolean isCharacter(Type t) {
        return Types.equalsAny(t, new Type[]{Character.TYPE, Character.class});
    }

    public static boolean isBoolean(Object o) {
        return o != null && Types.isBoolean(o.getClass());
    }

    public static boolean isBoolean(Type t) {
        return Types.equalsAny(t, new Type[]{Boolean.TYPE, Boolean.class});
    }

    public static boolean isEnum(Object o) {
        return o != null && Types.isEnum(o.getClass());
    }

    public static boolean isEnum(Type t) {
        if (t instanceof Class) {
            return ((Class)t).isEnum();
        }
        return false;
    }

    public static boolean isPrimitive(Object o) {
        return o != null && Types.isPrimitive(o.getClass());
    }

    public static boolean isPrimitive(Type t) {
        if (t instanceof Class) {
            return ((Class)t).isPrimitive();
        }
        return false;
    }

    public static boolean isPrimitiveLike(Object o) {
        return o != null && Types.isPrimitiveLike(o.getClass());
    }

    public static boolean isPrimitiveLike(Type t) {
        if (Types.isNumber(t)) {
            return true;
        }
        if (Types.isBoolean(t)) {
            return true;
        }
        if (Types.isEnum(t)) {
            return true;
        }
        if (Types.isCharacter(t)) {
            return true;
        }
        if (Types.isDate(t)) {
            return true;
        }
        return t == String.class;
    }

    public static boolean isArray(Object o) {
        return o != null && Types.isArray(o.getClass());
    }

    public static boolean isArray(Type t) {
        if (t instanceof Class) {
            return ((Class)t).isArray();
        }
        return t instanceof GenericArrayType;
    }

    public static boolean isArrayLike(Object o) {
        return o != null && Types.isArrayLike(o.getClass());
    }

    public static boolean isArrayLike(Type t) {
        return Types.isArray(t) || Types.isCollection(t);
    }

    public static boolean isCollection(Object o) {
        return o != null && Types.isCollection(o.getClass());
    }

    public static boolean isCollection(Type t) {
        return Types.isKindOf(t, Collection.class);
    }

    public static boolean isMap(Object o) {
        return o != null && Types.isMap(o.getClass());
    }

    public static boolean isMap(Type t) {
        return Types.isKindOf(t, Map.class);
    }

    public static boolean isDate(Object o) {
        return o != null && o instanceof Date;
    }

    public static boolean isDate(Type t) {
        return Types.isKindOf(t, Date.class);
    }

    public static boolean isClass(String name) {
        if (name == null) {
            return false;
        }
        Matcher matcher = CLASS_NAME_PATTERN.matcher(name);
        return matcher.find();
    }

    public static boolean asBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (Types.isBoolean(o)) {
            return (Boolean)o;
        }
        if (Types.isNumber(o)) {
            return ((Number)o).byteValue() != 0;
        }
        if (o instanceof String) {
            return !((String)o).isEmpty();
        }
        if (Types.isArray(o)) {
            return Array.getLength(o) > 0;
        }
        if (Types.isCollection(o)) {
            return ((Collection)o).size() > 0;
        }
        if (Types.isMap(o)) {
            return ((Map)o).size() > 0;
        }
        if (Types.isCharacter(o)) {
            return Character.isDefined(((Character)o).charValue());
        }
        return true;
    }

    public static Object getEmptyValue(Type t) {
        if (Byte.TYPE.equals(t) || Byte.class.equals((Object)t)) {
            return (byte)0;
        }
        if (Short.TYPE.equals(t) || Short.class.equals((Object)t)) {
            return (short)0;
        }
        if (Integer.TYPE.equals(t) || Integer.class.equals((Object)t)) {
            return 0;
        }
        if (Long.TYPE.equals(t) || Long.class.equals((Object)t)) {
            return 0L;
        }
        if (Float.TYPE.equals(t) || Float.class.equals((Object)t)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(t) || Double.class.equals((Object)t)) {
            return 0.0;
        }
        if (Types.isBoolean(t)) {
            return false;
        }
        if (Types.isCharacter(t)) {
            return Character.valueOf('\u0000');
        }
        if (String.class.equals((Object)t)) {
            return "";
        }
        if (Types.isDate(t)) {
            return new Date();
        }
        if (Types.isCollection(t)) {
            return Classes.newCollection(t);
        }
        if (Types.isArray(t)) {
            Array.newInstance(((Class)t).getComponentType(), 0);
        }
        return null;
    }

    private static Class<?> typeToClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        throw new BugError("Unknown type %s to convert to class.", t);
    }

    public static Iterable<?> asIterable(final Object o) {
        if (Types.isArray(o)) {
            return new Iterable<Object>(){
                private Object array;
                private int index;
                {
                    this.array = o;
                }

                @Override
                public Iterator<Object> iterator() {
                    return new Iterator<Object>(){

                        @Override
                        public boolean hasNext() {
                            return index < Array.getLength(array);
                        }

                        @Override
                        public Object next() {
                            return Array.get(array, index++);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Array iterator has no remove operation.");
                        }
                    };
                }
            };
        }
        if (Types.isCollection(o)) {
            return (Iterable)o;
        }
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public Object next() {
                        throw new UnsupportedOperationException("Empty iterator has no next operation.");
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Empty iterator has no remove operation.");
                    }
                };
            }
        };
    }

    public static boolean isVoid(Type t) {
        return Void.TYPE.equals(t) || Void.class.equals((Object)t);
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (Types.isBoolean(o)) {
            return (Boolean)o == false;
        }
        if (Types.isNumber(o)) {
            return ((Number)o).byteValue() == 0;
        }
        if (o instanceof String) {
            return !((String)o).isEmpty();
        }
        if (Types.isArray(o)) {
            return Array.getLength(o) == 0;
        }
        if (Types.isCollection(o)) {
            return ((Collection)o).isEmpty();
        }
        if (Types.isMap(o)) {
            return ((Map)o).isEmpty();
        }
        if (Types.isCharacter(o)) {
            return !Character.isDefined(((Character)o).charValue());
        }
        return false;
    }

    public static boolean isEqual(Type type1, Type type2) {
        Type[] atype2;
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return type1 == null;
        }
        if (!(type1 instanceof ParameterizedType)) {
            return type1.equals(type2);
        }
        if (!(type2 instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType ptype1 = (ParameterizedType)type1;
        ParameterizedType ptype2 = (ParameterizedType)type2;
        if (!ptype1.getRawType().equals(ptype2.getRawType())) {
            return false;
        }
        Type[] atype1 = ptype1.getActualTypeArguments();
        if (atype1.length != (atype2 = ptype2.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < atype1.length; ++i) {
            if (Types.isEqual(atype1[i], atype2[i])) continue;
            return false;
        }
        return true;
    }

    static {
        BOXING_MAP.put(Boolean.TYPE, (Type)((Object)Boolean.class));
        BOXING_MAP.put(Byte.TYPE, (Type)((Object)Byte.class));
        BOXING_MAP.put(Character.TYPE, (Type)((Object)Character.class));
        BOXING_MAP.put(Short.TYPE, (Type)((Object)Short.class));
        BOXING_MAP.put(Integer.TYPE, (Type)((Object)Integer.class));
        BOXING_MAP.put(Long.TYPE, (Type)((Object)Long.class));
        BOXING_MAP.put(Float.TYPE, (Type)((Object)Float.class));
        BOXING_MAP.put(Double.TYPE, (Type)((Object)Double.class));
        NUMERICAL_TYPES = new Type[]{Integer.TYPE, Long.TYPE, Double.TYPE, Integer.class, Long.class, Double.class, Byte.TYPE, Short.TYPE, Float.TYPE, Byte.class, Short.class, Float.class, Number.class, BigDecimal.class};
        CLASS_NAME_PATTERN = Pattern.compile("^[a-z][a-z0-9]*(?:\\.[a-z][a-z0-9]+)*\\.[A-Z][a-zA-Z0-9_]*(?:\\$[A-Z][a-zA-Z0-9_]*)*$");
    }
}

