/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.TIMESTAMPTZ;

final class T4CTTIokpn
extends T4CTTIfun {
    static final int REGISTER_KPNDEF = 1;
    static final int UNREGISTER_KPNDEF = 2;
    static final int POST_KPNDEF = 3;
    static final int EXISTINGCLIENT_KPNDEF = 0;
    static final int NEWCLIENT_KPNDEF = 1;
    static final int KPUN_PRS_RAW = 1;
    static final int KPUN_VER_10200 = 2;
    static final int OCI_SUBSCR_NAMESPACE_ANONYMOUS = 0;
    static final int OCI_SUBSCR_NAMESPACE_AQ = 1;
    static final int OCI_SUBSCR_NAMESPACE_DBCHANGE = 2;
    static final int OCI_SUBSCR_NAMESPACE_MAX = 3;
    static final int KPD_CHNF_OPFILTER = 1;
    static final int KPD_CHNF_INSERT = 2;
    static final int KPD_CHNF_UPDATE = 4;
    static final int KPD_CHNF_DELETE = 8;
    static final int KPD_CHNF_ROWID = 16;
    static final int KPD_CQ_QUERYNF = 32;
    static final int KPD_CQ_BEST_EFFORT = 64;
    static final int KPD_CQ_CLQRYCACHE = 128;
    static final int KPD_CHNF_INVALID_REGID = 0;
    static final int SUBSCR_QOS_RELIABLE = 1;
    static final int SUBSCR_QOS_PAYLOAD = 2;
    static final int SUBSCR_QOS_REPLICATE = 4;
    static final int SUBSCR_QOS_SECURE = 8;
    static final int SUBSCR_QOS_PURGE_ON_NTFN = 16;
    static final int SUBSCR_QOS_MULTICBK = 32;
    static final byte SUBSCR_NTFN_GROUPING_CLASS_NONE = 0;
    static final byte SUBSCR_NTFN_GROUPING_CLASS_TIME = 1;
    static final byte SUBSCR_NTFN_GROUPING_TYPE_SUMMARY = 1;
    static final byte SUBSCR_NTFN_GROUPING_TYPE_LAST = 2;
    private int opcode;
    private int mode;
    private int nbOfRegistrationInfo;
    private String user;
    private String location;
    private int[] namespace;
    private int[] kpdnrgrpval;
    private int[] kpdnrgrprepcnt;
    private int[] payloadType;
    private int[] qosFlags;
    private int[] timeout;
    private int[] dbchangeOpFilter;
    private int[] dbchangeTxnLag = null;
    private byte[][] registeredAgentName = null;
    private byte[][] kpdnrcx = null;
    private byte[] kpdnrgrpcla;
    private byte[] kpdnrgrptyp = null;
    private TIMESTAMPTZ[] kpdnrgrpstatim = null;
    private long[] dbchangeRegistrationId = null;
    private byte[] userArr = null;
    private byte[] locationArr = null;
    private long regid = 0L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:30:28_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIokpn(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)125);
    }

    void doOKPN(int n2, int n3, String string, String string2, int n4, int[] nArray, String[] stringArray, byte[][] byArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, long[] lArray, byte[] byArray2, int[] nArray7, byte[] byArray3, TIMESTAMPTZ[] tIMESTAMPTZArray, int[] nArray8) throws IOException, SQLException {
        this.opcode = n2;
        this.mode = n3;
        this.user = string;
        this.location = string2;
        this.nbOfRegistrationInfo = n4;
        this.namespace = nArray;
        this.kpdnrcx = byArray;
        this.payloadType = nArray2;
        this.qosFlags = nArray3;
        this.timeout = nArray4;
        this.dbchangeOpFilter = nArray5;
        this.dbchangeTxnLag = nArray6;
        this.dbchangeRegistrationId = lArray;
        this.kpdnrgrpcla = byArray2;
        this.kpdnrgrpval = nArray7;
        this.kpdnrgrptyp = byArray3;
        this.kpdnrgrpstatim = tIMESTAMPTZArray;
        this.kpdnrgrprepcnt = nArray8;
        this.registeredAgentName = new byte[this.nbOfRegistrationInfo][];
        for (int i2 = 0; i2 < this.nbOfRegistrationInfo; ++i2) {
            if (stringArray[i2] == null) continue;
            this.registeredAgentName[i2] = this.meg.conv.StringToCharBytes(stringArray[i2]);
        }
        this.userArr = (byte[])(this.user != null ? this.meg.conv.StringToCharBytes(this.user) : null);
        this.locationArr = (byte[])(this.location != null ? this.meg.conv.StringToCharBytes(this.location) : null);
        this.regid = 0L;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        int n2 = 1;
        int n3 = 2;
        this.meg.marshalUB1((byte)this.opcode);
        this.meg.marshalUB4(this.mode);
        if (this.userArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.userArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.locationArr != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.locationArr.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.nbOfRegistrationInfo);
        this.meg.marshalUB2(n2);
        this.meg.marshalUB2(n3);
        if (this.connection.getTTCVersion() >= 4) {
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            if (this.connection.getTTCVersion() >= 5) {
                this.meg.marshalNULLPTR();
                this.meg.marshalPTR();
            }
        }
        if (this.userArr != null) {
            this.meg.marshalCHR(this.userArr);
        }
        if (this.locationArr != null) {
            this.meg.marshalCHR(this.locationArr);
        }
        for (int i2 = 0; i2 < this.nbOfRegistrationInfo; ++i2) {
            this.meg.marshalUB4(this.namespace[i2]);
            byte[] byArray = this.registeredAgentName[i2];
            if (byArray != null && byArray.length > 0) {
                this.meg.marshalUB4(byArray.length);
                this.meg.marshalCLR(byArray, 0, byArray.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            if (this.kpdnrcx[i2] != null && this.kpdnrcx[i2].length > 0) {
                this.meg.marshalUB4(this.kpdnrcx[i2].length);
                this.meg.marshalCLR(this.kpdnrcx[i2], 0, this.kpdnrcx[i2].length);
            } else {
                this.meg.marshalUB4(0L);
            }
            this.meg.marshalUB4(this.payloadType[i2]);
            if (this.connection.getTTCVersion() < 4) continue;
            this.meg.marshalUB4(this.qosFlags[i2]);
            byte[] byArray2 = new byte[]{};
            this.meg.marshalUB4(byArray2.length);
            if (byArray2.length > 0) {
                this.meg.marshalCLR(byArray2, byArray2.length);
            }
            this.meg.marshalUB4(this.timeout[i2]);
            int n4 = 0;
            this.meg.marshalUB4(n4);
            this.meg.marshalUB4(this.dbchangeOpFilter[i2]);
            this.meg.marshalUB4(this.dbchangeTxnLag[i2]);
            this.meg.marshalUB4((int)this.dbchangeRegistrationId[i2]);
            if (this.connection.getTTCVersion() < 5) continue;
            this.meg.marshalUB1(this.kpdnrgrpcla[i2]);
            this.meg.marshalUB4(this.kpdnrgrpval[i2]);
            this.meg.marshalUB1(this.kpdnrgrptyp[i2]);
            if (this.kpdnrgrpstatim[i2] == null) {
                this.meg.marshalDALC(null);
            } else {
                this.meg.marshalDALC(this.kpdnrgrpstatim[i2].shareBytes());
            }
            this.meg.marshalSB4(this.kpdnrgrprepcnt[i2]);
            this.meg.marshalSB8(this.dbchangeRegistrationId[i2]);
        }
    }

    long getRegistrationId() {
        return this.regid;
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int n2;
        int n3 = (int)this.meg.unmarshalUB4();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.meg.unmarshalUB4();
        }
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = (int)this.meg.unmarshalUB4();
        }
        this.regid = nArray[0];
        if (this.connection.getTTCVersion() >= 5) {
            long l2;
            n2 = (int)this.meg.unmarshalUB4();
            this.regid = l2 = this.meg.unmarshalSB8();
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

