/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.InvalidContentLengthException;
import com.jsunsoft.http.ResponseBodyReadableContext;
import com.jsunsoft.http.ResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReaderContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStringResponseBodyReader
implements ResponseBodyReader<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStringResponseBodyReader.class);
    static final ResponseBodyReader<String> INSTANCE = new DefaultStringResponseBodyReader();

    DefaultStringResponseBodyReader() {
    }

    @Override
    public boolean isReadable(ResponseBodyReadableContext bodyReadableContext) {
        return bodyReadableContext.getType() == String.class;
    }

    @Override
    public String read(ResponseBodyReaderContext<String> bodyReaderContext) throws IOException {
        long startTime = System.currentTimeMillis();
        String result = null;
        InputStream inputStream = bodyReaderContext.getContent();
        if (inputStream != null) {
            int length;
            int bufferInitialSize = this.resolveBufferInitialSize(bodyReaderContext);
            byte[] buffer = new byte[bufferInitialSize];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(buffer.length);
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            ContentType contentType = bodyReaderContext.getContentType();
            Charset charset = contentType == null || contentType.getCharset() == null ? StandardCharsets.UTF_8 : contentType.getCharset();
            result = outputStream.toString(charset.name());
        }
        LOGGER.trace("Content type is: {}", result);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executed response body as string. Time: {}, length of response body: {}", (Object)HttpRequestUtils.humanTime(startTime), (Object)(result == null ? 0 : result.length()));
        }
        return result;
    }

    private int resolveBufferInitialSize(ResponseBodyReaderContext<String> bodyReaderContext) throws IOException {
        long contentLength = bodyReaderContext.getContentLength();
        if (contentLength > Integer.MAX_VALUE) {
            throw new InvalidContentLengthException(contentLength, "Content length is large. Content length greater than Integer.MAX_VALUE");
        }
        int integerContentLength = (int)contentLength;
        int result = integerContentLength >= 0 ? integerContentLength : 1024;
        return result;
    }
}

