/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;

class HttpRequestUtils {
    private HttpRequestUtils() {
        throw new AssertionError((Object)"No com.jsunsoft.http.HttpRequestUtils instances for you!");
    }

    static String humanTime(long startTime) {
        long difference = System.currentTimeMillis() - startTime;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(difference);
        return String.format("%d sec, %d millis", seconds, difference - TimeUnit.SECONDS.toMillis(seconds));
    }

    static boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    static boolean isNonSuccess(int statusCode) {
        return !HttpRequestUtils.isSuccess(statusCode);
    }

    static boolean isRedirected(int statusCode) {
        return statusCode >= 300 && statusCode < 400;
    }

    static boolean hasBody(int statusCode) {
        return statusCode >= 200 && statusCode != 204 && statusCode != 304 && statusCode != 205;
    }

    static boolean hasNotBody(int statusCode) {
        return !HttpRequestUtils.hasBody(statusCode);
    }

    static boolean isVoidType(Type type) {
        return type == Void.class;
    }

    static <T> T orDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }
}

