/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.BasicDateDeserializeContext;
import com.jsunsoft.http.DefaultResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class ResponseBodyReaderConfig {
    private final ResponseBodyReader<?> defaultResponseBodyReader;
    private final Collection<ResponseBodyReader<?>> responseBodyReaders;
    private final boolean useDefaultReader;

    private ResponseBodyReaderConfig(ResponseBodyReader<?> defaultResponseBodyReader, Collection<ResponseBodyReader<?>> responseBodyReaders, boolean useDefaultReader) {
        this.defaultResponseBodyReader = defaultResponseBodyReader;
        this.responseBodyReaders = Collections.unmodifiableList(new ArrayList(ArgsCheck.notNull(responseBodyReaders, "responseBodyReaders")));
        this.useDefaultReader = useDefaultReader;
    }

    ResponseBodyReader<?> getDefaultResponseBodyReader() {
        return this.defaultResponseBodyReader;
    }

    Collection<ResponseBodyReader<?>> getResponseBodyReaders() {
        return this.responseBodyReaders;
    }

    boolean isUseDefaultReader() {
        return this.useDefaultReader;
    }

    static Builder create() {
        return new Builder();
    }

    static class Builder {
        private ResponseBodyReader<?> defaultResponseBodyReader;
        private Collection<ResponseBodyReader<?>> responseBodyReaders;
        private boolean useDefaultReader = true;

        private Builder() {
        }

        Builder setDefaultResponseBodyReader(ResponseBodyReader<?> defaultResponseBodyReader) {
            this.defaultResponseBodyReader = defaultResponseBodyReader;
            return this;
        }

        Builder addResponseBodyReader(ResponseBodyReader<?> responseBodyReader) {
            if (this.responseBodyReaders == null) {
                this.responseBodyReaders = new ArrayList();
            }
            this.responseBodyReaders.add(responseBodyReader);
            return this;
        }

        Builder setUseDefaultBodyReader(boolean useDefaultReader) {
            this.useDefaultReader = useDefaultReader;
            return this;
        }

        ResponseBodyReaderConfig build() {
            if (this.useDefaultReader && this.defaultResponseBodyReader == null) {
                this.defaultResponseBodyReader = new DefaultResponseBodyReader(BasicDateDeserializeContext.DEFAULT);
            }
            if (this.responseBodyReaders == null) {
                this.responseBodyReaders = Collections.emptyList();
            }
            return new ResponseBodyReaderConfig(this.defaultResponseBodyReader, this.responseBodyReaders, this.useDefaultReader);
        }
    }
}

