/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.FilterSupport;
import com.jsunsoft.http.OtherwiseSupport;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;

public interface ResponseHandler<T> {
    public boolean hasContent();

    default public boolean hasNotContent() {
        return !this.hasContent();
    }

    public int getStatusCode();

    public T orElse(T var1);

    public T orElseThrow(T var1);

    public <X extends Throwable> T orThrow(Function<ResponseHandler<? super T>, X> var1) throws X;

    public <X extends Throwable> T orThrow(T var1, Function<ResponseHandler<? super T>, X> var2) throws X;

    public <X extends Throwable> T getOrThrow(Supplier<X> var1) throws X;

    public <X extends Throwable> T getOrThrow(T var1, Supplier<X> var2) throws X;

    public T orElseThrow();

    public T get();

    public String getErrorText();

    public URI getURI();

    public StatusLine getStatusLine();

    public ContentType getContentType();

    public boolean isSuccess();

    default public boolean isNonSuccess() {
        return !this.isSuccess();
    }

    public void ifHasContent(Consumer<? super T> var1);

    public OtherwiseSupport<T> ifSuccess(Consumer<ResponseHandler<T>> var1);

    public void ifNotSuccess(Consumer<ResponseHandler<T>> var1);

    public FilterSupport<T> filter(Predicate<ResponseHandler<T>> var1);
}

