/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.ResponseBodyReaderContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;

final class BasicResponseBodyReaderContext<T>
implements ResponseBodyReaderContext<T> {
    private final HttpResponse httpResponse;
    private final Class<T> type;
    private final Type genericType;
    private final URI uri;

    BasicResponseBodyReaderContext(HttpResponse httpResponse, Class<T> type, Type genericType, URI uri) {
        this.httpResponse = ArgsCheck.notNull(httpResponse, "httpResponse");
        this.type = ArgsCheck.notNull(type, "type");
        this.genericType = ArgsCheck.notNull(genericType, "genericType");
        this.uri = ArgsCheck.notNull(uri, "uri");
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.httpResponse.getEntity().getContent();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.get((HttpEntity)this.getHttpEntity());
    }

    @Override
    public long getContentLength() {
        return this.getHttpEntity().getContentLength();
    }

    @Override
    public HttpEntity getHttpEntity() {
        return this.httpResponse.getEntity();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean hasEntity() {
        return this.getHttpEntity() != null;
    }
}

