/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.BasicConnectionFailureType;
import com.jsunsoft.http.ConnectionFailureType;
import com.jsunsoft.http.FilterSupport;
import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.MissingResponseBodyException;
import com.jsunsoft.http.NoSuchContentException;
import com.jsunsoft.http.OtherwiseSupport;
import com.jsunsoft.http.ResponseHandler;
import com.jsunsoft.http.UnexpectedStatusCodeException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;
import org.apache.http.message.HeaderGroup;

final class BasicResponseHandler<T>
implements ResponseHandler<T> {
    private final int statusCode;
    private final T content;
    private final HeaderGroup headerGroup;
    private final String errorText;
    private final boolean isVoidType;
    private final ContentType contentType;
    private final URI uri;
    private final boolean success;
    private final ConnectionFailureType connectionFailureType;
    private final StatusLine statusLine;

    BasicResponseHandler(T content, int statusCode, String errorText, Type type, ContentType contentType, URI uri, ConnectionFailureType connectionFailureType) {
        this(content, statusCode, new HeaderGroup(), errorText, type, contentType, uri, connectionFailureType, null);
    }

    BasicResponseHandler(T content, int statusCode, HeaderGroup headerGroup, String errorText, Type type, ContentType contentType, URI uri, StatusLine statusLine) {
        this(content, statusCode, headerGroup, errorText, type, contentType, uri, BasicConnectionFailureType.NONE, statusLine);
    }

    private BasicResponseHandler(T content, int statusCode, HeaderGroup headerGroup, String errorText, Type type, ContentType contentType, URI uri, ConnectionFailureType connectionFailureType, StatusLine statusLine) {
        this.statusCode = statusCode;
        this.content = content;
        this.headerGroup = headerGroup;
        this.errorText = errorText;
        this.isVoidType = HttpRequestUtils.isVoidType(type);
        this.contentType = contentType;
        this.uri = ArgsCheck.notNull(uri, "uri");
        this.success = HttpRequestUtils.isSuccess(statusCode);
        this.connectionFailureType = ArgsCheck.notNull(connectionFailureType, "connectionFailureType");
        this.statusLine = statusLine;
    }

    @Override
    public boolean hasContent() {
        return this.content != null;
    }

    @Override
    public boolean hasNotContent() {
        return this.content == null;
    }

    @Override
    public int getCode() {
        return this.statusCode;
    }

    @Override
    public T orElse(T defaultValue) {
        this.check();
        return this.content == null ? defaultValue : this.content;
    }

    @Override
    public T orElseThrow(T defaultValue) {
        this.check();
        if (this.isNonSuccess()) {
            throw new UnexpectedStatusCodeException(this.statusCode, this.errorText, this.uri);
        }
        return this.content == null ? defaultValue : this.content;
    }

    @Override
    public <X extends Throwable> T orThrow(Function<ResponseHandler<? super T>, X> exceptionFunction) throws X {
        this.check();
        if (this.isNonSuccess()) {
            throw (Throwable)exceptionFunction.apply(this);
        }
        return this.content;
    }

    @Override
    public <X extends Throwable> T orThrow(T defaultValue, Function<ResponseHandler<? super T>, X> exceptionFunction) throws X {
        this.check();
        if (this.isNonSuccess()) {
            throw (Throwable)exceptionFunction.apply(this);
        }
        return this.content == null ? defaultValue : this.content;
    }

    @Override
    public <X extends Throwable> T getOrThrow(Supplier<X> exceptionSupplier) throws X {
        this.check();
        if (this.isNonSuccess()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.content;
    }

    @Override
    public <X extends Throwable> T getOrThrow(T defaultValue, Supplier<X> exceptionSupplier) throws X {
        this.check();
        if (this.isNonSuccess()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.content == null ? defaultValue : this.content;
    }

    @Override
    public T orElseThrow() {
        this.check();
        if (this.isSuccess()) {
            return this.content;
        }
        throw new UnexpectedStatusCodeException(this.statusCode, this.errorText, this.uri);
    }

    @Override
    public T get() {
        this.check();
        if (this.content == null) {
            throw new NoSuchContentException("Content is not present: Response code: [" + this.statusCode + ']');
        }
        return this.content;
    }

    @Override
    public T requiredGet() {
        this.check();
        if (this.isSuccess()) {
            if (this.hasContent()) {
                return this.content;
            }
            throw new MissingResponseBodyException(this.statusCode, this.uri);
        }
        throw new UnexpectedStatusCodeException(this.statusCode, this.errorText, this.uri);
    }

    @Override
    public Optional<T> getAsOptional() {
        this.check();
        return Optional.ofNullable(this.content);
    }

    @Override
    public Optional<T> getAsOptionalOrThrow() {
        this.check();
        if (this.isSuccess()) {
            return Optional.ofNullable(this.content);
        }
        throw new UnexpectedStatusCodeException(this.statusCode, this.errorText, this.uri);
    }

    @Override
    public void throwIfNotSuccess() throws UnexpectedStatusCodeException {
        if (this.isNonSuccess()) {
            throw new UnexpectedStatusCodeException(this.statusCode, this.errorText, this.uri);
        }
    }

    @Override
    public String getErrorText() {
        if (this.errorText == null) {
            throw new IllegalStateException("Error text is not available: Response code: [" + this.statusCode + ']');
        }
        return this.errorText;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public boolean isNonSuccess() {
        return !this.isSuccess();
    }

    @Override
    public void ifHasContent(Consumer<? super T> consumer) {
        ArgsCheck.notNull(consumer, "consumer");
        if (this.content != null) {
            consumer.accept(this.content);
        }
    }

    @Override
    public OtherwiseSupport<T> ifSuccess(Consumer<ResponseHandler<T>> consumer) {
        OtherwiseSupport otherwiseSupportResult;
        ArgsCheck.notNull(consumer, "consumer");
        if (this.success) {
            consumer.accept(this);
            otherwiseSupportResult = OtherwiseSupport.createIgnored(this);
        } else {
            otherwiseSupportResult = OtherwiseSupport.createNotIgnored(this);
        }
        return otherwiseSupportResult;
    }

    @Override
    public void ifNotSuccess(Consumer<ResponseHandler<T>> consumer) {
        ArgsCheck.notNull(consumer, "consumer");
        if (!this.success) {
            consumer.accept(this);
        }
    }

    @Override
    public FilterSupport<T> filter(Predicate<ResponseHandler<T>> predicate) {
        return FilterSupport.create(this, predicate);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headerGroup.containsHeader(name);
    }

    @Override
    public Header[] getHeaders(String name) {
        return this.headerGroup.getHeaders(name);
    }

    @Override
    public Header getFirstHeader(String name) {
        return this.headerGroup.getFirstHeader(name);
    }

    @Override
    public Header getLastHeader(String name) {
        return this.headerGroup.getLastHeader(name);
    }

    @Override
    public Header[] getAllHeaders() {
        return this.headerGroup.getAllHeaders();
    }

    ConnectionFailureType getConnectionFailureType() {
        return this.connectionFailureType;
    }

    public String toString() {
        return "ResponseHandler{statusCode=" + this.statusCode + ", content=" + this.content + ", errorText='" + this.errorText + '\'' + ", uri=" + this.uri + ", connectionFailureType=" + this.connectionFailureType + ", statusLine=" + this.statusLine + '}';
    }

    private void check() {
        if (this.isVoidType) {
            throw new UnsupportedOperationException("Content is not available. Generic type is a Void");
        }
    }
}

