/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.InvalidMimeTypeException;
import com.jsunsoft.http.ResponseBodyReadableContext;
import com.jsunsoft.http.ResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReaderContext;
import com.jsunsoft.http.ResponseBodyReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultResponseBodyReader<T>
implements ResponseBodyReader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponseBodyReader.class);
    private final ObjectMapper jsonSerializer;
    private final ObjectMapper xmlSerializer;

    DefaultResponseBodyReader(ObjectMapper jsonSerializer, ObjectMapper xmlSerializer) {
        this.jsonSerializer = jsonSerializer;
        this.xmlSerializer = xmlSerializer;
    }

    @Override
    public boolean isReadable(ResponseBodyReadableContext bodyReadableContext) {
        return bodyReadableContext.hasEntity();
    }

    @Override
    public T read(ResponseBodyReaderContext<T> bodyReaderContext) throws IOException, ResponseBodyReaderException {
        Object result;
        if (bodyReaderContext.getType() == String.class) {
            result = ResponseBodyReader.stringReader().read(bodyReaderContext);
        } else if (byte[].class == bodyReaderContext.getType()) {
            result = EntityUtils.toByteArray((HttpEntity)bodyReaderContext.getHttpEntity());
        } else {
            String mimeType;
            ContentType contentType = bodyReaderContext.getContentType();
            String string = mimeType = contentType == null ? null : contentType.getMimeType();
            if (ContentType.APPLICATION_JSON.getMimeType().equalsIgnoreCase(mimeType)) {
                result = this.deserialize(bodyReaderContext, this.jsonSerializer);
            } else if (ContentType.APPLICATION_XML.getMimeType().equalsIgnoreCase(mimeType) || ContentType.TEXT_XML.getMimeType().equalsIgnoreCase(mimeType)) {
                result = this.deserialize(bodyReaderContext, this.xmlSerializer);
            } else {
                throw new InvalidMimeTypeException(mimeType, "Default response body reader doesn't supported mimeType " + mimeType + " for converting response content to: " + bodyReaderContext.getType());
            }
        }
        return (T)result;
    }

    protected T deserialize(ResponseBodyReaderContext<T> responseBodyReaderContext, ObjectMapper objectMapper) throws ResponseBodyReaderException {
        try {
            InputStream content = responseBodyReaderContext.getContent();
            if (content == null) {
                LOGGER.warn("No content to read. Content length is: {}", (Object)responseBodyReaderContext.getContentLength());
                return null;
            }
            return DefaultResponseBodyReader.deserialize(content, responseBodyReaderContext.getGenericType(), objectMapper);
        }
        catch (IOException e) {
            throw new ResponseBodyReaderException(e);
        }
    }

    private static <T> T deserialize(InputStream inputStreamToDeserialize, Type type, ObjectMapper objectMapper) throws IOException {
        ArgsCheck.notNull(inputStreamToDeserialize, "inputStreamToDeserialize");
        ArgsCheck.notNull(type, "type");
        long startTime = System.currentTimeMillis();
        JavaType javaType = objectMapper.constructType(type);
        Object result = objectMapper.readValue(inputStreamToDeserialize, javaType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time of deserialization inputStream to type: [{}] is {}", (Object)type, (Object)HttpRequestUtils.humanTime(startTime));
        }
        return (T)result;
    }
}

