/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.ResponseBodyReadableContext;
import com.jsunsoft.http.ResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReaderContext;
import com.jsunsoft.http.ResponseBodyReaderException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStringResponseBodyReader
implements ResponseBodyReader<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStringResponseBodyReader.class);

    DefaultStringResponseBodyReader() {
    }

    @Override
    public boolean isReadable(ResponseBodyReadableContext bodyReadableContext) {
        return bodyReadableContext.getType() == String.class && bodyReadableContext.hasEntity();
    }

    @Override
    public String read(ResponseBodyReaderContext<String> bodyReaderContext) throws IOException {
        String result;
        long startTime = System.currentTimeMillis();
        ContentType contentType = bodyReaderContext.getContentType();
        LOGGER.trace("Content type is: {}", (Object)contentType);
        try {
            result = EntityUtils.toString((HttpEntity)bodyReaderContext.getHttpEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (ParseException e) {
            throw new ResponseBodyReaderException(e);
        }
        if (result == null || result.isEmpty()) {
            LOGGER.warn("No content to read. Content length is: {}", (Object)bodyReaderContext.getContentLength());
            return null;
        }
        LOGGER.trace("Content is: {}", (Object)result);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executed response body as string. Time: {}, length of response body: {}", (Object)HttpRequestUtils.humanTime(startTime), (Object)result.length());
        }
        return result;
    }
}

