/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderGroup;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;

class HttpUriRequestBuilder {
    private String method;
    private Charset charset;
    private ProtocolVersion version;
    private URI uri;
    private HeaderGroup headerGroup;
    private HttpEntity entity;
    private List<NameValuePair> parameters;
    private RequestConfig config;

    HttpUriRequestBuilder(String method) {
        this.charset = Consts.UTF_8;
        this.method = method;
    }

    HttpUriRequestBuilder(String method, URI uri) {
        this.method = method;
        this.uri = uri;
    }

    HttpUriRequestBuilder(String method, String uri) {
        this.method = method;
        this.uri = uri != null ? URI.create(uri) : null;
    }

    HttpUriRequestBuilder() {
        this(null);
    }

    public static HttpUriRequestBuilder create(String method) {
        Args.notBlank((CharSequence)method, (String)"HTTP method");
        return new HttpUriRequestBuilder(method);
    }

    public HttpUriRequestBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public static HttpUriRequestBuilder copy(HttpRequest request) {
        Args.notNull((Object)request, (String)"HTTP request");
        return new HttpUriRequestBuilder().doCopy(request);
    }

    private HttpUriRequestBuilder doCopy(HttpRequest request) {
        if (request == null) {
            return this;
        }
        this.method = request.getRequestLine().getMethod();
        this.version = request.getRequestLine().getProtocolVersion();
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.clear();
        this.headerGroup.setHeaders(request.getAllHeaders());
        this.parameters = null;
        this.entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity originalEntity = ((HttpEntityEnclosingRequest)request).getEntity();
            ContentType contentType = ContentType.get((HttpEntity)originalEntity);
            if (contentType != null && contentType.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                try {
                    List formParams = URLEncodedUtils.parse((HttpEntity)originalEntity);
                    if (!formParams.isEmpty()) {
                        this.parameters = formParams;
                    }
                }
                catch (IOException iOException) {}
            } else {
                this.entity = originalEntity;
            }
        }
        this.uri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : URI.create(request.getRequestLine().getUri());
        this.config = request instanceof Configurable ? ((Configurable)request).getConfig() : null;
        return this;
    }

    HttpUriRequestBuilder copyBuilder() {
        HttpUriRequestBuilder copyHttpUriRequestBuilder = new HttpUriRequestBuilder();
        copyHttpUriRequestBuilder.method = this.method;
        copyHttpUriRequestBuilder.charset = this.charset;
        copyHttpUriRequestBuilder.version = this.version;
        copyHttpUriRequestBuilder.uri = this.uri;
        if (this.headerGroup != null) {
            copyHttpUriRequestBuilder.headerGroup = new HeaderGroup();
            copyHttpUriRequestBuilder.headerGroup.setHeaders(this.headerGroup.getAllHeaders());
        }
        if (this.entity != null) {
            throw new IllegalStateException("After initializing the httpEntity builder can't be copied.");
        }
        if (this.parameters != null) {
            copyHttpUriRequestBuilder.parameters = new ArrayList<NameValuePair>(this.parameters);
        }
        if (this.config != null) {
            copyHttpUriRequestBuilder.config = RequestConfig.copy((RequestConfig)this.config).build();
        }
        return copyHttpUriRequestBuilder;
    }

    public HttpUriRequestBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getMethod() {
        return this.method;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public HttpUriRequestBuilder setVersion(ProtocolVersion version) {
        this.version = version;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    HttpUriRequestBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    HttpUriRequestBuilder setUri(String uri) {
        this.uri = uri != null ? URI.create(uri) : null;
        return this;
    }

    public Header getFirstHeader(String name) {
        return this.headerGroup != null ? this.headerGroup.getFirstHeader(name) : null;
    }

    public Header getLastHeader(String name) {
        return this.headerGroup != null ? this.headerGroup.getLastHeader(name) : null;
    }

    public Header[] getHeaders(String name) {
        return this.headerGroup != null ? this.headerGroup.getHeaders(name) : null;
    }

    public HttpUriRequestBuilder addHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader(header);
        return this;
    }

    public HttpUriRequestBuilder addHeader(String name, String value) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader((Header)new BasicHeader(name, value));
        return this;
    }

    public HttpUriRequestBuilder removeHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.removeHeader(header);
        return this;
    }

    public HttpUriRequestBuilder removeHeaders(String name) {
        if (name == null || this.headerGroup == null) {
            return this;
        }
        HeaderIterator i = this.headerGroup.iterator();
        while (i.hasNext()) {
            Header header = i.nextHeader();
            if (!name.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
        return this;
    }

    public HttpUriRequestBuilder setHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.updateHeader(header);
        return this;
    }

    public HttpUriRequestBuilder setHeader(String name, String value) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.updateHeader((Header)new BasicHeader(name, value));
        return this;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public HttpUriRequestBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public List<NameValuePair> getParameters() {
        return this.parameters != null ? new ArrayList<NameValuePair>(this.parameters) : new ArrayList();
    }

    public HttpUriRequestBuilder addParameter(NameValuePair nvp) {
        Args.notNull((Object)nvp, (String)"Name value pair");
        if (this.parameters == null) {
            this.parameters = new LinkedList<NameValuePair>();
        }
        this.parameters.add(nvp);
        return this;
    }

    public HttpUriRequestBuilder addParameter(String name, String value) {
        return this.addParameter((NameValuePair)new BasicNameValuePair(name, value));
    }

    public HttpUriRequestBuilder addParameters(NameValuePair ... nvps) {
        for (NameValuePair nvp : nvps) {
            this.addParameter(nvp);
        }
        return this;
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public HttpUriRequestBuilder setConfig(RequestConfig config) {
        this.config = config;
        return this;
    }

    public HttpUriRequest build() {
        Object result;
        URI uriNotNull = this.uri != null ? this.uri : URI.create("/");
        HttpEntity entityCopy = this.entity;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (entityCopy == null && ("POST".equalsIgnoreCase(this.method) || "PUT".equalsIgnoreCase(this.method))) {
                entityCopy = new UrlEncodedFormEntity(this.parameters, this.charset != null ? this.charset : HTTP.DEF_CONTENT_CHARSET);
            } else {
                try {
                    uriNotNull = new URIBuilder(uriNotNull).setCharset(this.charset).addParameters(this.parameters).build();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        if (entityCopy == null) {
            result = new InternalRequest(this.method);
        } else {
            InternalEntityEclosingRequest request = new InternalEntityEclosingRequest(this.method);
            request.setEntity(entityCopy);
            result = request;
        }
        result.setProtocolVersion(this.version);
        result.setURI(uriNotNull);
        if (this.headerGroup != null) {
            result.setHeaders(this.headerGroup.getAllHeaders());
        }
        result.setConfig(this.config);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RequestBuilder [method=").append(this.method).append(", charset=").append(this.charset).append(", version=").append(this.version).append(", uri=").append(this.uri).append(", headerGroup=").append(this.headerGroup).append(", entity=").append(this.entity).append(", parameters=").append(this.parameters).append(", config=").append(this.config).append("]");
        return builder.toString();
    }

    static class InternalEntityEclosingRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        InternalEntityEclosingRequest(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }

    static class InternalRequest
    extends HttpRequestBase {
        private final String method;

        InternalRequest(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

