/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.InvalidContentLengthException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class IOUtils {
    private IOUtils() {
        throw new AssertionError((Object)"No com.jsunsoft.http.IOUtils instances for you!");
    }

    static ByteArrayOutputStream toByteArrayOutputStream(InputStream inputStream, long contentLength) throws IOException {
        int length;
        if (inputStream == null || contentLength == 0L) {
            return null;
        }
        int bufferInitialSize = IOUtils.resolveBufferInitialSize(contentLength);
        byte[] buffer = new byte[bufferInitialSize];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(buffer.length);
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream;
    }

    static byte[] toByteArray(InputStream inputStream, long contentLength) throws IOException {
        ByteArrayOutputStream outputStream = IOUtils.toByteArrayOutputStream(inputStream, contentLength);
        return outputStream == null ? null : outputStream.toByteArray();
    }

    private static int resolveBufferInitialSize(long contentLength) throws IOException {
        if (contentLength > Integer.MAX_VALUE) {
            throw new InvalidContentLengthException(contentLength, "Content length is large. Content length greater than Integer.MAX_VALUE");
        }
        int integerContentLength = (int)contentLength;
        int result = integerContentLength > 0 ? integerContentLength : 1024;
        return result;
    }
}

