/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.BasicWebTarget;
import com.jsunsoft.http.HttpMethod;
import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.HttpUriRequestBuilder;
import com.jsunsoft.http.RequestBodySerializeConfig;
import com.jsunsoft.http.Response;
import com.jsunsoft.http.ResponseBodyReaderConfig;
import com.jsunsoft.http.ResponseHandler;
import com.jsunsoft.http.TypeReference;
import com.jsunsoft.http.WebTarget;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

class ImmutableWebTarget
extends BasicWebTarget {
    ImmutableWebTarget(CloseableHttpClient closeableHttpClient, URI uri, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, ResponseBodyReaderConfig responseBodyReaderConfig, RequestBodySerializeConfig requestBodySerializeConfig) {
        super(closeableHttpClient, uri, defaultHeaders, defaultRequestParameters, responseBodyReaderConfig, requestBodySerializeConfig);
    }

    ImmutableWebTarget(CloseableHttpClient closeableHttpClient, String uri, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, ResponseBodyReaderConfig responseBodyReaderConfig, RequestBodySerializeConfig requestBodySerializeConfig) throws URISyntaxException {
        super(closeableHttpClient, uri, defaultHeaders, defaultRequestParameters, responseBodyReaderConfig, requestBodySerializeConfig);
    }

    private ImmutableWebTarget(CloseableHttpClient closeableHttpClient, URIBuilder uriBuilder, HttpUriRequestBuilder httpUriRequestBuilder, ResponseBodyReaderConfig responseBodyReaderConfig, RequestBodySerializeConfig requestBodySerializeConfig) {
        super(closeableHttpClient, uriBuilder, httpUriRequestBuilder, responseBodyReaderConfig, requestBodySerializeConfig);
    }

    private WebTarget toBasicWebTarget() {
        return new BasicWebTarget(this);
    }

    @Override
    public WebTarget path(String path) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), HttpRequestUtils.appendPath(this.getUriBuilder(), path), this.getHttpUriRequestBuilder(), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public WebTarget setPath(String path) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder().setPath(path), this.getHttpUriRequestBuilder(), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public WebTarget removeHeader(Header header) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().removeHeader(header), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public WebTarget removeHeaders(String name) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().removeHeaders(name), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public WebTarget updateHeader(Header header) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().setHeader(header), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public WebTarget addHeader(Header header) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().addHeader(header), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public WebTarget setCharset(Charset charset) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().setCharset(charset), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public WebTarget setRequestConfig(RequestConfig requestConfig) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().setConfig(requestConfig), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public WebTarget addParameter(NameValuePair nameValuePair) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().addParameter(nameValuePair), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig());
    }

    @Override
    public Response request(HttpMethod method, HttpEntity httpEntity) {
        return new BasicWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder(), this.getResponseBodyReaderConfig(), this.getRequestBodySerializeConfig()).request(method, httpEntity);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, HttpEntity httpEntity, Class<T> responseType) {
        return this.toBasicWebTarget().request(method, httpEntity, responseType);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.toBasicWebTarget().request(method, httpEntity, responseType);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, Class<T> responseType) {
        return this.toBasicWebTarget().request(method, responseType);
    }

    @Override
    public Response request(HttpMethod method) {
        return this.toBasicWebTarget().request(method);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, TypeReference<T> typeReference) {
        return this.toBasicWebTarget().request(method, typeReference);
    }
}

