/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.jsunsoft.http.BasicDateDeserializeContext;
import com.jsunsoft.http.DateDeserializeContext;
import com.jsunsoft.http.DefaultDateDeserializeContext;
import java.util.Map;

class ObjectMapperInitializer {
    private ObjectMapperInitializer() {
    }

    static ObjectMapper initJsonMapperIfNull(ObjectMapper objectMapper, Map<Class<?>, String> dateTypeToPattern) {
        return objectMapper != null ? objectMapper : ObjectMapperInitializer.defaultInit(new ObjectMapper(), dateTypeToPattern);
    }

    static ObjectMapper initJsonMapperIfNull(ObjectMapper objectMapper, DateDeserializeContext dateDeserializeContext) {
        return objectMapper != null ? objectMapper : ObjectMapperInitializer.defaultInit(new ObjectMapper(), dateDeserializeContext);
    }

    static ObjectMapper initXmlMapperIfNull(ObjectMapper objectMapper, Map<Class<?>, String> dateTypeToPattern) {
        return objectMapper != null ? objectMapper : ObjectMapperInitializer.defaultInit((ObjectMapper)new XmlMapper(), dateTypeToPattern);
    }

    static ObjectMapper initXmlMapperIfNull(ObjectMapper objectMapper, DateDeserializeContext dateDeserializeContext) {
        return objectMapper != null ? objectMapper : ObjectMapperInitializer.defaultInit((ObjectMapper)new XmlMapper(), dateDeserializeContext);
    }

    static ObjectMapper defaultInit(ObjectMapper objectMapper, Map<Class<?>, String> dateTypeToPattern) {
        DateDeserializeContext dateDeserializeContext = dateTypeToPattern == null || dateTypeToPattern.isEmpty() ? DefaultDateDeserializeContext.DEFAULT : new BasicDateDeserializeContext(dateTypeToPattern);
        return ObjectMapperInitializer.defaultInit(objectMapper, dateDeserializeContext);
    }

    static ObjectMapper defaultInit(ObjectMapper objectMapper, DateDeserializeContext dateDeserializeContext) {
        dateDeserializeContext.getDateTypeToPattern().forEach((type, pattern) -> objectMapper.configOverride(type).setFormat(JsonFormat.Value.forPattern((String)pattern)));
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModules(new Module[]{new JodaModule(), new ParameterNamesModule(JsonCreator.Mode.PROPERTIES), new Jdk8Module(), new JavaTimeModule()});
        return objectMapper;
    }
}

