/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ResponseHandler;
import java.util.function.Consumer;

public class OtherwiseSupport<T> {
    private final ResponseHandler<T> responseHandler;
    private final boolean ignored;

    private OtherwiseSupport(ResponseHandler<T> responseHandler, boolean ignored) {
        this.responseHandler = responseHandler;
        this.ignored = ignored;
    }

    public void otherwise(Consumer<ResponseHandler<T>> consumer) {
        if (!this.ignored) {
            consumer.accept(this.responseHandler);
        }
    }

    static <T> OtherwiseSupport<T> createIgnored(ResponseHandler<T> responseHandler) {
        return new OtherwiseSupport<T>(responseHandler, true);
    }

    static <T> OtherwiseSupport<T> createNotIgnored(ResponseHandler<T> responseHandler) {
        return new OtherwiseSupport<T>(responseHandler, false);
    }
}

