/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jsunsoft.http.ObjectMapperInitializer;
import java.util.HashMap;
import java.util.Map;

class RequestBodySerializeConfig {
    private final ObjectMapper defaultJsonMapper;
    private final ObjectMapper defaultXmlMapper;

    RequestBodySerializeConfig(ObjectMapper defaultJsonMapper, ObjectMapper defaultXmlMapper) {
        this.defaultJsonMapper = defaultJsonMapper;
        this.defaultXmlMapper = defaultXmlMapper;
    }

    public ObjectMapper getDefaultJsonMapper() {
        return this.defaultJsonMapper;
    }

    public ObjectMapper getDefaultXmlMapper() {
        return this.defaultXmlMapper;
    }

    static Builder create() {
        return new Builder();
    }

    static class Builder {
        private ObjectMapper defaultJsonMapper;
        private ObjectMapper defaultXmlMapper;
        private Map<Class<?>, String> dateTypeToPattern;

        private Builder() {
        }

        Builder addDateDeserializationPattern(Class<?> dateType, String pattern) {
            if (this.dateTypeToPattern == null) {
                this.dateTypeToPattern = new HashMap();
            }
            this.dateTypeToPattern.put(dateType, pattern);
            return this;
        }

        public Builder setDefaultJsonMapper(ObjectMapper defaultJsonMapper) {
            this.defaultJsonMapper = defaultJsonMapper;
            return this;
        }

        public Builder setDefaultXmlMapper(ObjectMapper defaultXmlMapper) {
            this.defaultXmlMapper = defaultXmlMapper;
            return this;
        }

        RequestBodySerializeConfig build() {
            ObjectMapper json = ObjectMapperInitializer.initJsonMapperIfNull(this.defaultJsonMapper, this.dateTypeToPattern);
            ObjectMapper xml = ObjectMapperInitializer.initXmlMapperIfNull(this.defaultXmlMapper, this.dateTypeToPattern);
            return new RequestBodySerializeConfig(json, xml);
        }
    }
}

