/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.DefaultResponseBodyReader;
import com.jsunsoft.http.ObjectMapperInitializer;
import com.jsunsoft.http.ResponseBodyReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

class ResponseBodyReaderConfig {
    private final ResponseBodyReader<?> defaultResponseBodyReader;
    private final Collection<ResponseBodyReader<?>> responseBodyReaders;
    private final boolean useDefaultReader;

    private ResponseBodyReaderConfig(ResponseBodyReader<?> defaultResponseBodyReader, Collection<ResponseBodyReader<?>> responseBodyReaders, boolean useDefaultReader) {
        this.defaultResponseBodyReader = defaultResponseBodyReader;
        this.responseBodyReaders = Collections.unmodifiableList(new ArrayList(ArgsCheck.notNull(responseBodyReaders, "responseBodyReaders")));
        this.useDefaultReader = useDefaultReader;
    }

    static Builder create() {
        return new Builder();
    }

    ResponseBodyReader<?> getDefaultResponseBodyReader() {
        return this.defaultResponseBodyReader;
    }

    Collection<ResponseBodyReader<?>> getResponseBodyReaders() {
        return this.responseBodyReaders;
    }

    boolean isUseDefaultReader() {
        return this.useDefaultReader;
    }

    static class Builder {
        private ResponseBodyReader<?> defaultResponseBodyReader;
        private Collection<ResponseBodyReader<?>> responseBodyReaders;
        private boolean useDefaultReader = true;
        private ObjectMapper defaultJsonMapper;
        private ObjectMapper defaultXmlMapper;
        private Map<Class<?>, String> dateTypeToPattern;

        private Builder() {
        }

        Builder setDefaultResponseBodyReader(ResponseBodyReader<?> defaultResponseBodyReader) {
            this.defaultResponseBodyReader = defaultResponseBodyReader;
            return this;
        }

        Builder addResponseBodyReader(ResponseBodyReader<?> responseBodyReader) {
            if (this.responseBodyReaders == null) {
                this.responseBodyReaders = new LinkedHashSet();
            }
            this.responseBodyReaders.add(responseBodyReader);
            return this;
        }

        Builder setUseDefaultBodyReader(boolean useDefaultReader) {
            this.useDefaultReader = useDefaultReader;
            return this;
        }

        Builder addDateDeserializationPattern(Class<?> dateType, String pattern) {
            if (this.dateTypeToPattern == null) {
                this.dateTypeToPattern = new HashMap();
            }
            this.dateTypeToPattern.put(dateType, pattern);
            return this;
        }

        public Builder setDefaultJsonMapper(ObjectMapper defaultJsonMapper) {
            this.defaultJsonMapper = defaultJsonMapper;
            return this;
        }

        public Builder setDefaultXmlMapper(ObjectMapper defaultXmlMapper) {
            this.defaultXmlMapper = defaultXmlMapper;
            return this;
        }

        ResponseBodyReaderConfig build() {
            if (this.useDefaultReader && this.defaultResponseBodyReader == null) {
                ObjectMapper json = ObjectMapperInitializer.initJsonMapperIfNull(this.defaultJsonMapper, this.dateTypeToPattern);
                ObjectMapper xml = ObjectMapperInitializer.initXmlMapperIfNull(this.defaultXmlMapper, this.dateTypeToPattern);
                this.defaultResponseBodyReader = new DefaultResponseBodyReader(json, xml);
            } else {
                if (this.defaultJsonMapper != null) {
                    throw new IllegalArgumentException("Do not provide defaultJsonMapper if default body reader is not used.");
                }
                if (this.defaultXmlMapper != null) {
                    throw new IllegalArgumentException("Do not provide defaultXmlMapper if default body reader is not used.");
                }
                if (this.dateTypeToPattern != null) {
                    throw new IllegalArgumentException("Do not provide dateTypeToPattern if default body reader is not used.");
                }
            }
            if (this.responseBodyReaders == null) {
                this.responseBodyReaders = Collections.emptyList();
            }
            return new ResponseBodyReaderConfig(this.defaultResponseBodyReader, this.responseBodyReaders, this.useDefaultReader);
        }
    }
}

