/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.Response;
import com.jsunsoft.http.WebTarget;
import com.jsunsoft.http.annotations.Beta;
import org.apache.http.Header;
import org.slf4j.LoggerFactory;

@Beta
public interface RetryContext {
    public int getRetryCount();

    default public int getRetryDelay(Response response) {
        int retryAfterSec = 5;
        Header retryAfter = response.getFirstHeader("Retry-After");
        if (retryAfter != null) {
            try {
                retryAfterSec = Integer.parseInt(retryAfter.getValue());
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(RetryContext.class).warn("Can't parse {} header's value: {} to integer. {}", new Object[]{"Retry-After", retryAfter.getValue(), e.getMessage()});
            }
        }
        return retryAfterSec;
    }

    default public boolean mustBeRetried(Response response) {
        return response.getStatusCode() == 503;
    }

    default public WebTarget beforeRetry(WebTarget webTarget) {
        return webTarget;
    }
}

