/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.BasicWebTarget;
import com.jsunsoft.http.HttpMethod;
import com.jsunsoft.http.RequestBodySerializeConfig;
import com.jsunsoft.http.Response;
import com.jsunsoft.http.ResponseBodyReaderConfig;
import com.jsunsoft.http.RetryContext;
import com.jsunsoft.http.annotations.Beta;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
class RetryableWebTarget
extends BasicWebTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryableWebTarget.class);
    private final RetryContext retryContext;

    RetryableWebTarget(CloseableHttpClient closeableHttpClient, URI uri, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, RetryContext retryContext, ResponseBodyReaderConfig responseBodyReaderConfig, RequestBodySerializeConfig requestBodySerializeConfig) {
        super(closeableHttpClient, uri, defaultHeaders, defaultRequestParameters, responseBodyReaderConfig, requestBodySerializeConfig);
        this.retryContext = retryContext;
    }

    RetryableWebTarget(CloseableHttpClient closeableHttpClient, String uri, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, RetryContext retryContext, ResponseBodyReaderConfig responseBodyReaderConfig, RequestBodySerializeConfig requestBodySerializeConfig) throws URISyntaxException {
        super(closeableHttpClient, uri, defaultHeaders, defaultRequestParameters, responseBodyReaderConfig, requestBodySerializeConfig);
        this.retryContext = retryContext;
    }

    @Override
    public Response request(HttpMethod method) {
        Response response = super.request(method);
        try {
            for (int retryCount = this.retryContext.getRetryCount(); retryCount > 0 && this.retryContext.mustBeRetried(response); --retryCount) {
                LOGGER.debug("Request to URI: [{}] has been retried. Response code: [{}]", (Object)response.getURI(), (Object)response.getCode());
                TimeUnit.SECONDS.sleep(this.retryContext.getRetryDelay(response));
                this.closeResponse(response);
                response = this.retryContext.beforeRetry(this).request(method);
            }
        }
        catch (InterruptedException e) {
            this.closeResponse(response);
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread was interrupted.", e);
        }
        return response;
    }

    private void closeResponse(Response response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to close response.", (Throwable)ex);
            }
        }
    }
}

