/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.HttpMethod;
import com.jsunsoft.http.Response;
import com.jsunsoft.http.ResponseHandler;
import com.jsunsoft.http.TypeReference;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.Args;

public interface WebTarget {
    public WebTarget path(String var1);

    public WebTarget setPath(String var1);

    public Response request(HttpMethod var1);

    public Response request(HttpMethod var1, HttpEntity var2);

    public <T> ResponseHandler<T> request(HttpMethod var1, HttpEntity var2, Class<T> var3);

    public <T> ResponseHandler<T> request(HttpMethod var1, HttpEntity var2, TypeReference<T> var3);

    public <T> ResponseHandler<T> request(HttpMethod var1, Class<T> var2);

    public <T> ResponseHandler<T> request(HttpMethod var1, TypeReference<T> var2);

    default public ResponseHandler<?> rawRequest(HttpMethod method) {
        return this.request(method, Void.class);
    }

    default public ResponseHandler<?> rawRequest(HttpMethod method, HttpEntity httpEntity) {
        return this.request(method, httpEntity, Void.class);
    }

    default public ResponseHandler<?> rawRequest(HttpMethod method, String payload) {
        return this.request(method, payload, Void.class);
    }

    public ResponseHandler<?> rawRequest(HttpMethod var1, Object var2);

    public WebTarget removeHeader(Header var1);

    public WebTarget removeHeaders(String var1);

    public WebTarget updateHeader(Header var1);

    public WebTarget addHeader(Header var1);

    public WebTarget setCharset(Charset var1);

    public <T> ResponseHandler<T> request(HttpMethod var1, String var2, Class<T> var3);

    public <T> ResponseHandler<T> request(HttpMethod var1, Object var2, Class<T> var3);

    public <T> ResponseHandler<T> request(HttpMethod var1, String var2, TypeReference<T> var3);

    public <T> ResponseHandler<T> request(HttpMethod var1, Object var2, TypeReference<T> var3);

    public Response request(HttpMethod var1, String var2);

    public Response request(HttpMethod var1, Object var2);

    default public WebTarget addHeader(String name, String value) {
        ArgsCheck.notNull(name, "name");
        return this.addHeader((Header)new BasicHeader(name, value));
    }

    default public WebTarget addHeaders(Collection<? extends Header> headers) {
        ArgsCheck.notNull(headers, "headers");
        WebTarget result = this;
        for (Header header : headers) {
            result = result.addHeader(header);
        }
        return result;
    }

    default public WebTarget updateHeader(String name, String value) {
        ArgsCheck.notNull(name, "name");
        return this.updateHeader((Header)new BasicHeader(name, value));
    }

    default public WebTarget addContentType(ContentType contentType) {
        return this.addHeader("Content-Type", contentType.toString());
    }

    public WebTarget setRequestConfig(RequestConfig var1);

    public WebTarget addParameter(NameValuePair var1);

    public String getURIString();

    public URI getURI();

    default public WebTarget addParameters(NameValuePair ... parameters) {
        ArgsCheck.notNull(parameters, "parameters");
        WebTarget result = this;
        for (NameValuePair parameter : parameters) {
            result = result.addParameter(parameter);
        }
        return result;
    }

    default public WebTarget addParameters(String queryString, Charset charset) {
        ArgsCheck.notNull(queryString, "queryString");
        ArgsCheck.notNull(charset, "charset");
        return this.addParameters(URLEncodedUtils.parse((String)queryString, (Charset)charset));
    }

    default public WebTarget addParameters(String queryString) {
        return this.addParameters(queryString, StandardCharsets.UTF_8);
    }

    default public WebTarget addParameters(String ... nameValues) {
        int nameValuesLength = ArgsCheck.notNull(nameValues, "nameValues").length;
        Args.check((nameValuesLength != 0 ? 1 : 0) != 0, (String)"Length of parameter can't be ZERO");
        Args.check((nameValuesLength % 2 == 0 ? 1 : 0) != 0, (String)"Length of nameValues can't be odd");
        WebTarget result = this;
        int end = nameValuesLength - 2;
        for (int i = 0; i <= end; i += 2) {
            result = result.addParameter((NameValuePair)new BasicNameValuePair(nameValues[i], nameValues[i + 1]));
        }
        return result;
    }

    default public WebTarget addParameters(Collection<? extends NameValuePair> parameters) {
        ArgsCheck.notNull(parameters, "parameters");
        WebTarget result = this;
        for (NameValuePair nameValuePair : parameters) {
            result = result.addParameter(nameValuePair);
        }
        return result;
    }

    default public WebTarget addParameters(Map<String, String> parameters) {
        ArgsCheck.notNull(parameters, "parameters");
        WebTarget result = this;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            BasicNameValuePair parameter = new BasicNameValuePair(entry.getKey(), entry.getValue());
            result = result.addParameter((NameValuePair)parameter);
        }
        return result;
    }

    default public WebTarget addParameter(String name, String value) {
        ArgsCheck.notNull(name, "name");
        return this.addParameter((NameValuePair)new BasicNameValuePair(name, value));
    }

    default public Response get() {
        return this.request(HttpMethod.GET);
    }

    default public ResponseHandler<?> rawGet() {
        return this.rawRequest(HttpMethod.GET);
    }

    default public <T> ResponseHandler<T> get(Class<T> responseType) {
        return this.request(HttpMethod.GET, responseType);
    }

    default public <T> ResponseHandler<T> get(TypeReference<T> responseType) {
        return this.request(HttpMethod.GET, responseType);
    }

    default public Response put() {
        return this.request(HttpMethod.PUT);
    }

    default public ResponseHandler<?> rawPut() {
        return this.rawRequest(HttpMethod.PUT);
    }

    default public ResponseHandler<?> rawPut(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.PUT, httpEntity);
    }

    default public ResponseHandler<?> rawPut(String payload) {
        return this.rawRequest(HttpMethod.PUT, payload);
    }

    default public ResponseHandler<?> rawPut(Object body) {
        return this.rawRequest(HttpMethod.PUT, body);
    }

    default public Response put(HttpEntity httpEntity) {
        return this.request(HttpMethod.PUT, httpEntity);
    }

    default public <T> ResponseHandler<T> put(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.PUT, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> put(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.PUT, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> put(String payload, Class<T> responseType) {
        return this.request(HttpMethod.PUT, payload, responseType);
    }

    default public <T> ResponseHandler<T> put(Object body, Class<T> responseType) {
        return this.request(HttpMethod.PUT, body, responseType);
    }

    default public <T> ResponseHandler<T> put(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.PUT, payload, responseType);
    }

    default public <T> ResponseHandler<T> put(Object body, TypeReference<T> responseType) {
        return this.request(HttpMethod.PUT, body, responseType);
    }

    default public Response put(String payload) {
        return this.request(HttpMethod.PUT, payload);
    }

    default public Response put(Object body) {
        return this.request(HttpMethod.PUT, body);
    }

    default public <T> ResponseHandler<T> put(Class<T> responseType) {
        return this.request(HttpMethod.PUT, responseType);
    }

    default public <T> ResponseHandler<T> put(TypeReference<T> responseType) {
        return this.request(HttpMethod.PUT, responseType);
    }

    default public Response post() {
        return this.request(HttpMethod.POST);
    }

    default public ResponseHandler<?> rawPost() {
        return this.rawRequest(HttpMethod.POST);
    }

    default public ResponseHandler<?> rawPost(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.POST, httpEntity);
    }

    default public ResponseHandler<?> rawPost(String payload) {
        return this.rawRequest(HttpMethod.POST, payload);
    }

    default public ResponseHandler<?> rawPost(Object body) {
        return this.rawRequest(HttpMethod.POST, body);
    }

    default public Response post(HttpEntity httpEntity) {
        return this.request(HttpMethod.POST, httpEntity);
    }

    default public <T> ResponseHandler<T> post(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.POST, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> post(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.POST, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> post(String payload, Class<T> responseType) {
        return this.request(HttpMethod.POST, payload, responseType);
    }

    default public <T> ResponseHandler<T> post(Object body, Class<T> responseType) {
        return this.request(HttpMethod.POST, body, responseType);
    }

    default public <T> ResponseHandler<T> post(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.POST, payload, responseType);
    }

    default public <T> ResponseHandler<T> post(Object body, TypeReference<T> responseType) {
        return this.request(HttpMethod.POST, body, responseType);
    }

    default public Response post(String payload) {
        return this.request(HttpMethod.POST, payload);
    }

    default public Response post(Object body) {
        return this.request(HttpMethod.POST, body);
    }

    default public <T> ResponseHandler<T> post(Class<T> responseType) {
        return this.request(HttpMethod.POST, responseType);
    }

    default public <T> ResponseHandler<T> post(TypeReference<T> responseType) {
        return this.request(HttpMethod.POST, responseType);
    }

    default public Response head() {
        return this.request(HttpMethod.HEAD);
    }

    default public ResponseHandler<?> rawHead() {
        return this.rawRequest(HttpMethod.HEAD);
    }

    default public Response delete() {
        return this.request(HttpMethod.DELETE);
    }

    default public ResponseHandler<?> rawDelete() {
        return this.rawRequest(HttpMethod.DELETE);
    }

    default public ResponseHandler<?> rawDelete(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.DELETE, httpEntity);
    }

    default public ResponseHandler<?> rawDelete(String payload) {
        return this.rawRequest(HttpMethod.DELETE, payload);
    }

    default public ResponseHandler<?> rawDelete(Object body) {
        return this.rawRequest(HttpMethod.DELETE, body);
    }

    default public Response delete(HttpEntity httpEntity) {
        return this.request(HttpMethod.DELETE, httpEntity);
    }

    default public <T> ResponseHandler<T> delete(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.DELETE, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> delete(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.DELETE, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> delete(String payload, Class<T> responseType) {
        return this.request(HttpMethod.DELETE, payload, responseType);
    }

    default public <T> ResponseHandler<T> delete(Object body, Class<T> responseType) {
        return this.request(HttpMethod.DELETE, body, responseType);
    }

    default public <T> ResponseHandler<T> delete(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.DELETE, payload, responseType);
    }

    default public <T> ResponseHandler<T> delete(Object body, TypeReference<T> responseType) {
        return this.request(HttpMethod.DELETE, body, responseType);
    }

    default public Response delete(String payload) {
        return this.request(HttpMethod.DELETE, payload);
    }

    default public Response delete(Object body) {
        return this.request(HttpMethod.DELETE, body);
    }

    default public <T> ResponseHandler<T> delete(Class<T> responseType) {
        return this.request(HttpMethod.DELETE, responseType);
    }

    default public <T> ResponseHandler<T> delete(TypeReference<T> responseType) {
        return this.request(HttpMethod.DELETE, responseType);
    }

    default public Response options() {
        return this.request(HttpMethod.OPTIONS);
    }

    default public ResponseHandler<?> rawOptions() {
        return this.rawRequest(HttpMethod.OPTIONS);
    }

    default public ResponseHandler<?> rawOptions(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.OPTIONS, httpEntity);
    }

    default public ResponseHandler<?> rawOptions(String payload) {
        return this.rawRequest(HttpMethod.OPTIONS, payload);
    }

    default public ResponseHandler<?> rawOptions(Object body) {
        return this.rawRequest(HttpMethod.OPTIONS, body);
    }

    default public Response options(HttpEntity httpEntity) {
        return this.request(HttpMethod.OPTIONS, httpEntity);
    }

    default public <T> ResponseHandler<T> options(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.OPTIONS, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> options(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.OPTIONS, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> options(String payload, Class<T> responseType) {
        return this.request(HttpMethod.OPTIONS, payload, responseType);
    }

    default public <T> ResponseHandler<T> options(Object body, Class<T> responseType) {
        return this.request(HttpMethod.OPTIONS, body, responseType);
    }

    default public <T> ResponseHandler<T> options(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.OPTIONS, payload, responseType);
    }

    default public <T> ResponseHandler<T> options(Object body, TypeReference<T> responseType) {
        return this.request(HttpMethod.OPTIONS, body, responseType);
    }

    default public Response options(String payload) {
        return this.request(HttpMethod.OPTIONS, payload);
    }

    default public Response options(Object body) {
        return this.request(HttpMethod.OPTIONS, body);
    }

    default public <T> ResponseHandler<T> options(Class<T> responseType) {
        return this.request(HttpMethod.OPTIONS, responseType);
    }

    default public <T> ResponseHandler<T> options(TypeReference<T> responseType) {
        return this.request(HttpMethod.OPTIONS, responseType);
    }

    default public Response patch() {
        return this.request(HttpMethod.PATCH);
    }

    default public ResponseHandler<?> rawPatch() {
        return this.rawRequest(HttpMethod.PATCH);
    }

    default public ResponseHandler<?> rawPatch(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.PATCH, httpEntity);
    }

    default public ResponseHandler<?> rawPatch(String payload) {
        return this.rawRequest(HttpMethod.PATCH, payload);
    }

    default public ResponseHandler<?> rawPatch(Object body) {
        return this.rawRequest(HttpMethod.PATCH, body);
    }

    default public Response patch(HttpEntity httpEntity) {
        return this.request(HttpMethod.PATCH, httpEntity);
    }

    default public <T> ResponseHandler<T> patch(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.PATCH, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> patch(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.PATCH, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> patch(String payload, Class<T> responseType) {
        return this.request(HttpMethod.PATCH, payload, responseType);
    }

    default public <T> ResponseHandler<T> patch(Object body, Class<T> responseType) {
        return this.request(HttpMethod.PATCH, body, responseType);
    }

    default public <T> ResponseHandler<T> patch(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.PATCH, payload, responseType);
    }

    default public <T> ResponseHandler<T> patch(Object body, TypeReference<T> responseType) {
        return this.request(HttpMethod.PATCH, body, responseType);
    }

    default public Response patch(String payload) {
        return this.request(HttpMethod.PATCH, payload);
    }

    default public Response patch(Object body) {
        return this.request(HttpMethod.PATCH, body);
    }

    default public <T> ResponseHandler<T> patch(Class<T> responseType) {
        return this.request(HttpMethod.PATCH, responseType);
    }

    default public <T> ResponseHandler<T> patch(TypeReference<T> responseType) {
        return this.request(HttpMethod.PATCH, responseType);
    }

    default public Response trace() {
        return this.request(HttpMethod.TRACE);
    }

    default public ResponseHandler<?> rawTrace() {
        return this.rawRequest(HttpMethod.TRACE);
    }

    default public <T> ResponseHandler<T> trace(Class<T> responseType) {
        return this.request(HttpMethod.TRACE, responseType);
    }

    default public <T> ResponseHandler<T> trace(TypeReference<T> responseType) {
        return this.request(HttpMethod.TRACE, responseType);
    }
}

