/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.plaf.ColorUIResource;

public class AcrylIcons
extends BaseIcons {
    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacIconIcon() : new TitleButtonIcon(0);
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMinIcon() : new TitleButtonIcon(1);
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMaxIcon() : new TitleButtonIcon(2);
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacCloseIcon() : new TitleButtonIcon(3);
        }
        return closeIcon;
    }

    public static Icon getTreeExpandedIcon() {
        if (!AbstractLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getTreeExpandedIcon();
        }
        if (treeExpandedIcon == null) {
            treeExpandedIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("acryl/icons/small/tree_expanded_11x11.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("acryl/icons/medium/tree_expanded_13x13.png") : new LazyImageIcon("acryl/icons/large/tree_expanded_15x15.png"));
        }
        return treeExpandedIcon;
    }

    public static Icon getTreeCollapsedIcon() {
        if (!AbstractLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getTreeCollapsedIcon();
        }
        if (treeCollapsedIcon == null) {
            treeCollapsedIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("acryl/icons/small/tree_collapsed_11x11.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("acryl/icons/medium/tree_collapsed_13x13.png") : new LazyImageIcon("acryl/icons/large/tree_collapsed_15x15.png"));
        }
        return treeCollapsedIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getThumbHorIcon() {
        if (!AbstractLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getThumbHorIcon();
        }
        if (thumbHorIcon == null) {
            thumbHorIcon = new LazyImageIcon("acryl/icons/thumb_hor.gif");
        }
        return thumbHorIcon;
    }

    public static Icon getThumbVerIcon() {
        if (!AbstractLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getThumbVerIcon();
        }
        if (thumbVerIcon == null) {
            thumbVerIcon = new LazyImageIcon("acryl/icons/thumb_ver.gif");
        }
        return thumbVerIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (!AbstractLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getThumbHorIconRollover();
        }
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = new LazyImageIcon("acryl/icons/thumb_hor_rollover.gif");
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (!AbstractLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getThumbVerIconRollover();
        }
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = new LazyImageIcon("acryl/icons/thumb_ver_rollover.gif");
        }
        return thumbVerIconRollover;
    }

    private static class RadioButtonIcon
    implements Icon {
        private static final int GAP = 2;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += 2;
            }
            int w = this.getIconWidth() - 2;
            int h = this.getIconHeight();
            Graphics2D g2D = (Graphics2D)g;
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color frameColor = AbstractLookAndFeel.getFrameColor();
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            Shape savedClip = g.getClip();
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Area clipArea = new Area(new Ellipse2D.Double(x, y, w + 1, h + 1));
            if (savedClip != null) {
                clipArea.intersect(new Area(savedClip));
            }
            g2D.setClip(clipArea);
            if (button.isEnabled()) {
                if (button.isRolloverEnabled() && model.isRollover() || model.isPressed() && model.isArmed()) {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getRolloverColors(), x, y, w, h);
                    frameColor = ColorHelper.brighter(frameColor, 30.0);
                } else if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && button.hasFocus()) {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getFocusColors(), x, y, w, h);
                } else {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getCheckBoxColors(), x, y, w, h);
                }
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getDisabledColors(), x, y, w, h);
                frameColor = ColorHelper.brighter(frameColor, 40.0);
            }
            g2D.setClip(savedClip);
            g2D.setColor(frameColor);
            g2D.drawOval(x, y, w, h);
            if (model.isSelected()) {
                if (!model.isEnabled()) {
                    g.setColor(AbstractLookAndFeel.getTheme().getDisabledForegroundColor());
                    g.fillOval(x + w / 2 - 2, y + h / 2 - 2, 5, 5);
                } else {
                    int gv = model.isRollover() ? ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getRolloverColorDark()) : ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getControlColorDark());
                    if (gv > 128) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.white);
                    }
                    if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                        g2D.fillOval(x + 4, y + 4, w - 7, h - 7);
                    } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                        g2D.fillOval(x + 4, y + 4, w - 7, h - 7);
                    } else {
                        g2D.fillOval(x + 5, y + 5, w - 9, h - 9);
                    }
                }
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        public int getIconWidth() {
            int w = AbstractLookAndFeel.getTheme().isSmallFontSize() ? 14 : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? 16 : 18);
            return w + 2;
        }

        public int getIconHeight() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 14;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 16;
            }
            return 18;
        }
    }

    private static class CheckBoxIcon
    implements Icon {
        private static final int GAP = 2;
        private static final Icon SMALL_CHECK_ICON = new LazyImageIcon("acryl/icons/small/check_symbol_12x11.png");
        private static final Icon SMALL_CHECK_INVERSE_ICON = new LazyImageIcon("icons/small/check_symbol_10x10.png");
        private static final Icon SMALL_CHECK_DISABLED_ICON = new LazyImageIcon("icons/small/check_symbol_disabled_10x10.png");
        private static final Icon MEDIUM_CHECK_ICON = new LazyImageIcon("acryl/icons/medium/check_symbol_14x13.png");
        private static final Icon MEDIUM_CHECK_INVERSE_ICON = new LazyImageIcon("icons/medium/check_symbol_12x12.png");
        private static final Icon MEDIUM_CHECK_DISABLED_ICON = new LazyImageIcon("icons/medium/check_symbol_disabled_12x12.png");
        private static final Icon LARGE_CHECK_ICON = new LazyImageIcon("acryl/icons/large/check_symbol_16x15.png");
        private static final Icon LARGE_CHECK_INVERSE_ICON = new LazyImageIcon("icons/large/check_symbol_14x14.png");
        private static final Icon LARGE_CHECK_DISABLED_ICON = new LazyImageIcon("icons/large/check_symbol_disabled_14x14.png");

        private CheckBoxIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon checkInverseIcon;
            Icon checkDisabledIcon;
            Icon checkIcon;
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += 2;
            }
            int w = this.getIconWidth() - 2;
            int h = this.getIconHeight();
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color frameColor = AbstractLookAndFeel.getFrameColor();
            if (button.isEnabled()) {
                if (button.isRolloverEnabled() && model.isRollover()) {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getRolloverColors(), x + 1, y + 1, w - 2, h - 2);
                    frameColor = ColorHelper.brighter(frameColor, 30.0);
                } else if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && button.hasFocus()) {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getFocusColors(), x + 1, y + 1, w - 2, h - 2);
                } else {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getCheckBoxColors(), x + 1, y + 1, w - 2, h - 2);
                }
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getDisabledColors(), x + 1, y + 1, w - 2, h - 2);
                frameColor = ColorHelper.brighter(frameColor, 40.0);
            }
            g.setColor(AbstractLookAndFeel.getTheme().getControlShadowColor());
            g.drawRect(x, y, w - 1, h - 1);
            g.setColor(frameColor);
            g.drawLine(x + 1, y, x + w - 2, y);
            g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
            g.drawLine(x, y + 1, x, y + h - 2);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                checkIcon = SMALL_CHECK_ICON;
                checkDisabledIcon = SMALL_CHECK_DISABLED_ICON;
                checkInverseIcon = SMALL_CHECK_INVERSE_ICON;
            } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                checkIcon = MEDIUM_CHECK_ICON;
                checkDisabledIcon = MEDIUM_CHECK_DISABLED_ICON;
                checkInverseIcon = MEDIUM_CHECK_INVERSE_ICON;
            } else {
                checkIcon = LARGE_CHECK_ICON;
                checkDisabledIcon = LARGE_CHECK_DISABLED_ICON;
                checkInverseIcon = LARGE_CHECK_INVERSE_ICON;
            }
            int gv = model.isRollover() ? ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getRolloverColorDark()) : ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getControlColorDark());
            int xi = x + (w - checkIcon.getIconWidth()) / 2;
            int yi = y + (h - checkIcon.getIconHeight()) / 2;
            if (model.isPressed() && model.isArmed()) {
                ColorUIResource bc = gv > 128 ? AbstractLookAndFeel.getTheme().getSelectionBackgroundColor() : AbstractLookAndFeel.getTheme().getSelectionForegroundColor();
                Color fc = gv > 128 ? ColorHelper.darker(bc, 40.0) : ColorHelper.brighter(bc, 20.0);
                g.setColor(fc);
                g.drawRect(x + 4, y + 4, w - 9, h - 9);
                g.setColor(bc);
                g.fillRect(x + 5, y + 5, w - 10, h - 10);
            } else if (model.isSelected()) {
                if (!model.isEnabled()) {
                    checkDisabledIcon.paintIcon(c, g, xi + 1, yi + 1);
                } else if (gv > 128) {
                    checkInverseIcon.paintIcon(c, g, xi + 1, yi + 1);
                } else {
                    checkIcon.paintIcon(c, g, xi, yi);
                }
            }
        }

        public int getIconWidth() {
            int w = AbstractLookAndFeel.getTheme().isSmallFontSize() ? 14 : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? 16 : 18);
            return w + 2;
        }

        public int getIconHeight() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 14;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 16;
            }
            return 18;
        }
    }

    private static class TitleButtonIcon
    implements Icon {
        private static final Color extraLightGray = new Color(240, 240, 240);
        private static final Color closerColorLight = new Color(241, 172, 154);
        private static final Color closerColorDark = new Color(224, 56, 2);
        public static final int ICON_ICON_TYP = 0;
        public static final int MIN_ICON_TYP = 1;
        public static final int MAX_ICON_TYP = 2;
        public static final int CLOSE_ICON_TYP = 3;
        private int iconTyp = 0;

        public TitleButtonIcon(int typ) {
            this.iconTyp = typ;
        }

        public int getIconHeight() {
            return 20;
        }

        public int getIconWidth() {
            return 20;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = c.getWidth();
            int h = c.getHeight();
            JButton b = (JButton)c;
            Graphics2D g2D = (Graphics2D)g;
            boolean isPressed = b.getModel().isPressed();
            boolean isArmed = b.getModel().isArmed();
            boolean isRollover = b.getModel().isRollover();
            ColorUIResource cFrame = AbstractLookAndFeel.getTheme().getWindowBorderColor();
            Color cFrameInner = ColorHelper.brighter(cFrame, 60.0);
            Color cHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowTitleColorLight(), 40.0);
            Color cLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 10.0);
            Color cShadow = Color.black;
            if (this.iconTyp == 3) {
                cHi = closerColorLight;
                cLo = closerColorDark;
            }
            if (isPressed && isArmed) {
                Color cTemp = ColorHelper.darker(cLo, 10.0);
                cLo = ColorHelper.darker(cHi, 10.0);
                cHi = cTemp;
                g2D.setPaint(new GradientPaint(0.0f, 0.0f, cHi, w, h, cLo));
                g.fillRect(2, 2, w - 3, h - 3);
            } else if (isRollover) {
                cFrameInner = ColorHelper.brighter(cFrameInner, 50.0);
                if (this.iconTyp == 3) {
                    cHi = closerColorLight;
                    cShadow = cLo = closerColorDark;
                    g2D.setPaint(new GradientPaint(0.0f, 0.0f, cHi, w, h, cLo));
                    g2D.fillRect(2, 2, w - 3, h - 3);
                } else {
                    JTattooUtilities.fillHorGradient(g2D, AbstractLookAndFeel.getTheme().getRolloverColors(), 2, 2, w - 3, h - 3);
                }
            }
            g2D.setColor(cFrame);
            g2D.drawLine(1, 0, w - 2, 0);
            g2D.drawLine(1, h - 1, w - 2, h - 1);
            g2D.drawLine(0, 1, 0, h - 2);
            g2D.drawLine(w - 1, 1, w - 1, h - 2);
            g2D.setColor(cFrameInner);
            g2D.drawRect(1, 1, w - 3, h - 3);
            Icon icon = null;
            if (this.iconTyp == 0) {
                icon = new BaseIcons.IconSymbol(extraLightGray, cShadow, null, new Insets(0, 5, 0, 5));
            } else if (this.iconTyp == 1) {
                icon = new BaseIcons.MinSymbol(extraLightGray, cShadow, null, new Insets(0, 4, 0, 4));
            } else if (this.iconTyp == 2) {
                icon = new BaseIcons.MaxSymbol(extraLightGray, cShadow, null, new Insets(0, 4, 0, 4));
            } else if (this.iconTyp == 3) {
                icon = new BaseIcons.CloseSymbol(Color.white, ColorHelper.darker(cShadow, 50.0), null, new Insets(0, 5, 0, 5));
            }
            if (icon != null) {
                icon.paintIcon(c, g, 0, 0);
            }
        }
    }
}

