/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonListener;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class BaseToggleButtonUI
extends BasicToggleButtonUI {
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent b) {
        return new BaseToggleButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setRolloverEnabled(true);
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setOpaque(true);
        b.setRolloverEnabled(false);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BaseButtonListener(b);
    }

    protected void paintBackground(Graphics g, AbstractButton b) {
        Color background;
        if (!b.isContentAreaFilled() || b.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b.getWidth();
        int height = b.getHeight();
        ButtonModel model = b.getModel();
        Color[] colors = b.isEnabled() ? ((background = b.getBackground()) instanceof ColorUIResource ? (b.isRolloverEnabled() && model.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (model.isPressed() && model.isArmed() || model.isSelected() ? AbstractLookAndFeel.getTheme().getPressedColors() : (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus() ? AbstractLookAndFeel.getTheme().getFocusColors() : AbstractLookAndFeel.getTheme().getButtonColors()))) : (model.isPressed() && model.isArmed() ? ColorHelper.createColorArr(ColorHelper.darker(background, 30.0), ColorHelper.darker(background, 10.0), 20) : (b.isRolloverEnabled() && model.isRollover() ? (model.isSelected() ? ColorHelper.createColorArr(ColorHelper.darker(background, 20.0), background, 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 50.0), ColorHelper.brighter(background, 10.0), 20)) : (model.isSelected() ? ColorHelper.createColorArr(ColorHelper.darker(background, 40.0), ColorHelper.darker(background, 20.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 30.0), ColorHelper.darker(background, 10.0), 20))))) : AbstractLookAndFeel.getTheme().getDisabledColors();
        JTattooUtilities.fillHorGradient(g, colors, 1, 1, width - 2, height - 2);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(b, g, b.getFont());
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            Object sc;
            Color foreground = b.getForeground();
            Color background = b.getBackground();
            int offs = 0;
            if (model.isArmed() && model.isPressed() || model.isSelected()) {
                offs = 1;
                if (foreground instanceof ColorUIResource && background instanceof ColorUIResource) {
                    foreground = AbstractLookAndFeel.getTheme().getPressedForegroundColor();
                }
            }
            if (model.isRollover() && foreground instanceof ColorUIResource && background instanceof ColorUIResource) {
                foreground = AbstractLookAndFeel.getTheme().getRolloverForegroundColor();
            }
            if ((sc = b.getClientProperty("shadowColor")) instanceof Color) {
                g.setColor((Color)sc);
                JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs, textRect.y + fm.getAscent() * offs + 1);
            }
            g.setColor(foreground);
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs, textRect.y + fm.getAscent() + offs);
        } else {
            g.setColor(Color.white);
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + 1, textRect.y + fm.getAscent() + 1);
            g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, 4, 3, b.getWidth() - 8, b.getHeight() - 6);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2D = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        g.setFont(b.getFont());
        FontMetrics fm = JTattooUtilities.getFontMetrics(b, g, b.getFont());
        Insets insets = c.getInsets();
        BaseToggleButtonUI.viewRect.x = insets.left;
        BaseToggleButtonUI.viewRect.y = insets.top;
        BaseToggleButtonUI.viewRect.width = b.getWidth() - (insets.right + BaseToggleButtonUI.viewRect.x);
        BaseToggleButtonUI.viewRect.height = b.getHeight() - (insets.bottom + BaseToggleButtonUI.viewRect.y);
        BaseToggleButtonUI.textRect.height = 0;
        BaseToggleButtonUI.textRect.width = 0;
        BaseToggleButtonUI.textRect.y = 0;
        BaseToggleButtonUI.textRect.x = 0;
        BaseToggleButtonUI.iconRect.height = 0;
        BaseToggleButtonUI.iconRect.width = 0;
        BaseToggleButtonUI.iconRect.y = 0;
        BaseToggleButtonUI.iconRect.x = 0;
        int iconTextGap = b.getIconTextGap();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : iconTextGap);
        this.paintBackground(g, b);
        if (b.getIcon() != null) {
            if (!b.isEnabled()) {
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                this.paintIcon(g, c, iconRect);
                g2D.setComposite(savedComposite);
            } else {
                this.paintIcon(g, c, iconRect);
            }
        }
        if (text != null && !text.equals("") && textRect != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                Object savedRenderingHint = null;
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
                }
                v.paint(g, textRect);
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
                }
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }
}

