/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LazyImageIcon
implements Icon {
    private String name = null;
    private ImageIcon icon = null;

    public LazyImageIcon(String name) {
        this.name = name;
    }

    private Icon getIcon() {
        if (this.icon == null) {
            try {
                this.icon = new ImageIcon(LazyImageIcon.class.getResource(this.name));
            }
            catch (Throwable t) {
                System.out.println("ERROR: loading image " + this.name + " failed!");
            }
        }
        return this.icon;
    }

    public Image getImage() {
        if (this.getIcon() != null) {
            return this.icon.getImage();
        }
        return null;
    }

    @Override
    public int getIconHeight() {
        if (this.getIcon() != null) {
            return this.icon.getIconHeight();
        }
        return 16;
    }

    @Override
    public int getIconWidth() {
        if (this.getIcon() != null) {
            return this.icon.getIconWidth();
        }
        return 16;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.getIcon() != null) {
            this.icon.paintIcon(c, g, x, y);
        } else {
            g.setColor(Color.red);
            g.fillRect(x, y, 16, 16);
            g.setColor(Color.white);
            g.drawLine(x, y, x + 15, y + 15);
            g.drawLine(x + 15, y, x, y + 15);
        }
    }
}

