/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BaseBorders {
    protected static Border buttonBorder = null;
    protected static Border focusFrameBorder = null;
    protected static Border textFieldBorder = null;
    protected static Border spinnerBorder = null;
    protected static Border comboBoxBorder = null;
    protected static Border progressBarBorder = null;
    protected static Border tableHeaderBorder = null;
    protected static Border popupMenuBorder = null;
    protected static Border menuItemBorder = null;
    protected static Border toolBarBorder = null;
    protected static Border toolButtonBorder = null;
    protected static Border rolloverToolButtonBorder = null;
    protected static Border internalFrameBorder = null;
    protected static Border paletteBorder = null;
    protected static Border scrollPaneBorder = null;
    protected static Border tableScrollPaneBorder = null;
    protected static Border tabbedPaneBorder = null;
    protected static Border desktopIconBorder = null;

    public static void initDefaults() {
        buttonBorder = null;
        textFieldBorder = null;
        spinnerBorder = null;
        comboBoxBorder = null;
        progressBarBorder = null;
        tableHeaderBorder = null;
        popupMenuBorder = null;
        menuItemBorder = null;
        toolBarBorder = null;
        toolButtonBorder = null;
        rolloverToolButtonBorder = null;
        paletteBorder = null;
        internalFrameBorder = null;
        scrollPaneBorder = null;
        tableScrollPaneBorder = null;
        tabbedPaneBorder = null;
        desktopIconBorder = null;
    }

    public static Border getFocusFrameBorder() {
        if (focusFrameBorder == null) {
            focusFrameBorder = new FocusFrameBorder();
        }
        return focusFrameBorder;
    }

    public static Border getTextBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new TextFieldBorder();
        }
        return textFieldBorder;
    }

    public static Border getSpinnerBorder() {
        if (spinnerBorder == null) {
            spinnerBorder = new SpinnerBorder();
        }
        return spinnerBorder;
    }

    public static Border getTextFieldBorder() {
        return BaseBorders.getTextBorder();
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new ComboBoxBorder();
        }
        return comboBoxBorder;
    }

    public static Border getProgressBarBorder() {
        if (progressBarBorder == null) {
            progressBarBorder = BorderFactory.createLineBorder(ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 30.0));
        }
        return progressBarBorder;
    }

    public static Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new TableHeaderBorder();
        }
        return tableHeaderBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = AbstractLookAndFeel.getTheme().isMenuOpaque() ? new BasePopupMenuBorder() : new BasePopupMenuShadowBorder();
        }
        return popupMenuBorder;
    }

    public static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new MenuItemBorder();
        }
        return menuItemBorder;
    }

    public static Border getToolBarBorder() {
        if (toolBarBorder == null) {
            toolBarBorder = new ToolBarBorder();
        }
        return toolBarBorder;
    }

    public static Border getToolButtonBorder() {
        if (toolButtonBorder == null) {
            toolButtonBorder = new ToolButtonBorder();
        }
        return toolButtonBorder;
    }

    public static Border getMenuBarBorder() {
        return BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public static Border getPaletteBorder() {
        if (paletteBorder == null) {
            paletteBorder = new PaletteBorder();
        }
        return paletteBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder(false);
        }
        return scrollPaneBorder;
    }

    public static Border getTableScrollPaneBorder() {
        if (tableScrollPaneBorder == null) {
            tableScrollPaneBorder = new ScrollPaneBorder(true);
        }
        return tableScrollPaneBorder;
    }

    public static Border getTabbedPaneBorder() {
        if (tabbedPaneBorder == null) {
            tabbedPaneBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }
        return tabbedPaneBorder;
    }

    public static Border getDesktopIconBorder() {
        if (desktopIconBorder == null) {
            desktopIconBorder = new BorderUIResource.CompoundBorderUIResource(new LineBorder(AbstractLookAndFeel.getWindowBorderColor(), 1), new MatteBorder(2, 2, 1, 2, AbstractLookAndFeel.getWindowBorderColor()));
        }
        return desktopIconBorder;
    }

    public static class Down3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource frameColor = AbstractLookAndFeel.getTheme().getBackgroundColor();
            JTattooUtilities.draw3DBorder(g, ColorHelper.darker(frameColor, 20.0), ColorHelper.brighter(frameColor, 80.0), x, y, w, h);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(Down3DBorder.insets.top, Down3DBorder.insets.left, Down3DBorder.insets.bottom, Down3DBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = Down3DBorder.insets.left;
            borderInsets.top = Down3DBorder.insets.top;
            borderInsets.right = Down3DBorder.insets.right;
            borderInsets.bottom = Down3DBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class BaseInternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        protected final int dw = 5;
        protected final int trackWidth = 22;
        protected final Insets insets = new Insets(5, 5, 5, 5);
        protected final Insets paletteInsets = new Insets(3, 3, 3, 3);

        public boolean isResizable(Component c) {
            boolean resizable = true;
            if (c instanceof JDialog) {
                JDialog dialog = (JDialog)c;
                resizable = dialog.isResizable();
            } else if (c instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)c;
                resizable = frame.isResizable();
            } else if (c instanceof JRootPane) {
                JRootPane jp = (JRootPane)c;
                if (jp.getParent() instanceof JFrame) {
                    JFrame frame = (JFrame)c.getParent();
                    resizable = frame.isResizable();
                } else if (jp.getParent() instanceof JDialog) {
                    JDialog dialog = (JDialog)c.getParent();
                    resizable = dialog.isResizable();
                }
            }
            return resizable;
        }

        public boolean isActive(Component c) {
            JRootPane jp;
            boolean active = true;
            if (c instanceof JDialog) {
                JDialog dlg = (JDialog)c;
                if (dlg.getParent() instanceof JComponent) {
                    return JTattooUtilities.isActive((JComponent)dlg.getParent());
                }
            } else if (c instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)c;
                active = frame.isSelected();
                if (active) {
                    return JTattooUtilities.isActive(frame);
                }
            } else if (c instanceof JRootPane && (jp = (JRootPane)c).getTopLevelAncestor() instanceof Window) {
                Window window = (Window)jp.getTopLevelAncestor();
                return JTattooUtilities.isWindowActive(window);
            }
            return active;
        }

        public int getTitleHeight(Component c) {
            int th = 21;
            int fh = this.getBorderInsets((Component)c).top + this.getBorderInsets((Component)c).bottom;
            if (c instanceof JDialog) {
                JDialog dialog = (JDialog)c;
                th = dialog.getSize().height - dialog.getContentPane().getSize().height - fh - 1;
                if (dialog.getJMenuBar() != null) {
                    th -= dialog.getJMenuBar().getSize().height;
                }
            } else if (c instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)c;
                th = frame.getSize().height - frame.getRootPane().getSize().height - fh - 1;
                if (frame.getJMenuBar() != null) {
                    th -= frame.getJMenuBar().getSize().height;
                }
            } else if (c instanceof JRootPane) {
                JRootPane jp = (JRootPane)c;
                if (jp.getParent() instanceof JFrame) {
                    JFrame frame = (JFrame)c.getParent();
                    th = frame.getSize().height - frame.getContentPane().getSize().height - fh - 1;
                    if (frame.getJMenuBar() != null) {
                        th -= frame.getJMenuBar().getSize().height;
                    }
                } else if (jp.getParent() instanceof JDialog) {
                    JDialog dialog = (JDialog)c.getParent();
                    th = dialog.getSize().height - dialog.getContentPane().getSize().height - fh - 1;
                    if (dialog.getJMenuBar() != null) {
                        th -= dialog.getJMenuBar().getSize().height;
                    }
                }
            }
            return th;
        }

        public Insets getBorderInsets(Component c) {
            if (this.isResizable(c)) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            return new Insets(this.paletteInsets.top, this.paletteInsets.left, this.paletteInsets.bottom, this.paletteInsets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets ins = this.getBorderInsets(c);
            borderInsets.left = ins.left;
            borderInsets.top = ins.top;
            borderInsets.right = ins.right;
            borderInsets.bottom = ins.bottom;
            return borderInsets;
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (JTattooUtilities.isFrameActive((JComponent)c)) {
                g.setColor(AbstractLookAndFeel.getWindowBorderColor());
            } else {
                g.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
            }
            g.drawRect(x, y, w - 1, h - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(PaletteBorder.insets.top, PaletteBorder.insets.left, PaletteBorder.insets.bottom, PaletteBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = PaletteBorder.insets.left;
            borderInsets.top = PaletteBorder.insets.top;
            borderInsets.right = PaletteBorder.insets.right;
            borderInsets.bottom = PaletteBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class ToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            ColorUIResource frameColor = AbstractLookAndFeel.getToolbarBackgroundColor();
            Color frameHiColor = ColorHelper.brighter(frameColor, 10.0);
            Color frameLoColor = ColorHelper.darker(frameColor, 30.0);
            JTattooUtilities.draw3DBorder(g, frameHiColor, frameLoColor, x, y, w, h);
            if (model.isPressed() && model.isArmed() || model.isSelected()) {
                JTattooUtilities.draw3DBorder(g, frameLoColor, frameHiColor, x, y, w, h);
            } else {
                JTattooUtilities.draw3DBorder(g, frameLoColor, frameHiColor, x, y, w, h);
                JTattooUtilities.draw3DBorder(g, frameHiColor, frameLoColor, x + 1, y + 1, w - 2, h - 2);
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(ToolButtonBorder.insets.top, ToolButtonBorder.insets.left, ToolButtonBorder.insets.bottom, ToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ToolButtonBorder.insets.left;
            borderInsets.top = ToolButtonBorder.insets.top;
            borderInsets.right = ToolButtonBorder.insets.right;
            borderInsets.bottom = ToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        private static final Color shadow = new Color(160, 160, 160);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (((JToolBar)c).isFloatable()) {
                Graphics2D g2D = (Graphics2D)g;
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                if (((JToolBar)c).getOrientation() == 0) {
                    if (!JTattooUtilities.isLeftToRight(c)) {
                        x += w - 15;
                    }
                    g.setColor(Color.white);
                    g.drawLine(x + 3, y + 4, x + 3, h - 5);
                    g.drawLine(x + 6, y + 3, x + 6, h - 4);
                    g.drawLine(x + 9, y + 4, x + 9, h - 5);
                    g.setColor(shadow);
                    g.drawLine(x + 4, y + 4, x + 4, h - 5);
                    g.drawLine(x + 7, y + 3, x + 7, h - 4);
                    g.drawLine(x + 10, y + 4, x + 10, h - 5);
                } else {
                    g.setColor(Color.white);
                    g.drawLine(x + 3, y + 3, w - 4, y + 3);
                    g.drawLine(x + 3, y + 6, w - 4, y + 6);
                    g.drawLine(x + 3, y + 9, w - 4, y + 9);
                    g.setColor(shadow);
                    g.drawLine(x + 3, y + 4, w - 4, y + 4);
                    g.drawLine(x + 3, y + 7, w - 4, y + 7);
                    g.drawLine(x + 3, y + 10, w - 4, y + 10);
                }
                g2D.setComposite(savedComposite);
            }
        }

        public Insets getBorderInsets(Component c) {
            Insets margin;
            Insets insets = new Insets(2, 2, 2, 2);
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    if (JTattooUtilities.isLeftToRight(c)) {
                        insets.left = 15;
                    } else {
                        insets.right = 15;
                    }
                } else {
                    insets.top = 15;
                }
            }
            if ((margin = ((JToolBar)c).getMargin()) != null) {
                insets.left += margin.left;
                insets.top += margin.top;
                insets.right += margin.right;
                insets.bottom += margin.bottom;
            }
            return insets;
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets insets = this.getBorderInsets(c);
            borderInsets.left = insets.left;
            borderInsets.top = insets.top;
            borderInsets.right = insets.right;
            borderInsets.bottom = insets.bottom;
            return borderInsets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            ColorUIResource borderColorLo = AbstractLookAndFeel.getFrameColor();
            Color borderColorHi = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 40.0);
            if (c.getParent() instanceof JMenuBar) {
                if (model.isArmed() || model.isSelected()) {
                    g.setColor(borderColorLo);
                    g.drawLine(x, y, x + w - 1, y);
                    g.drawLine(x, y, x, y + h - 1);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                    g.setColor(borderColorHi);
                    g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
                }
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(borderColorLo);
                g.drawLine(x, y, x + w - 1, y);
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                g.setColor(borderColorHi);
                g.drawLine(x, y + 1, x + w - 2, y + 1);
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(MenuItemBorder.insets.top, MenuItemBorder.insets.left, MenuItemBorder.insets.bottom, MenuItemBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = MenuItemBorder.insets.left;
            borderInsets.top = MenuItemBorder.insets.top;
            borderInsets.right = MenuItemBorder.insets.right;
            borderInsets.bottom = MenuItemBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class BasePopupMenuShadowBorder
    extends BasePopupMenuBorder {
        public BasePopupMenuShadowBorder() {
            shadowSize = 4;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            int dx;
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, AbstractLookAndFeel.getTheme().getMenuAlpha());
            g2D.setComposite(alpha);
            ColorUIResource logoColor = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
            ColorUIResource borderColorLo = AbstractLookAndFeel.getFrameColor();
            Color borderColorHi = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 40.0);
            g.setColor(logoColor);
            if (JTattooUtilities.isLeftToRight(c)) {
                dx = this.getBorderInsets((Component)c).left;
                g.fillRect(x, y, dx - 1, h - 1 - shadowSize);
                this.paintLogo(c, g, x, y, w, h);
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g.drawLine(x + dx, y + 1, x + w - shadowSize - 2, y + 1);
                g.setColor(borderColorHi);
                g.drawLine(x + 1, y, x + 1, y + h - shadowSize - 2);
                g.setColor(borderColorLo);
                if (this.isMenuBarPopup(c)) {
                    g.drawLine(x + dx - 1, y, x + w - shadowSize - 1, y);
                    g.drawLine(x, y, x, y + h - shadowSize - 1);
                    g.drawLine(x, y + h - shadowSize - 1, x + w - shadowSize - 1, y + h - shadowSize - 1);
                    g.drawLine(x + w - shadowSize - 1, y + 1, x + w - shadowSize - 1, y + h - shadowSize - 1);
                } else {
                    g.drawRect(x, y, w - shadowSize - 1, h - shadowSize - 1);
                }
                g.drawLine(x + dx - 1, y + 1, x + dx - 1, y + h - shadowSize - 1);
            } else {
                dx = this.getBorderInsets((Component)c).right - shadowSize;
                g.fillRect(x + w - dx - shadowSize, y, dx - 1, h - 1 - shadowSize);
                this.paintLogo(c, g, x, y, w, h);
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g.drawLine(x + 1, y + 1, x + w - dx - shadowSize - 1, y + 1);
                g.drawLine(x + 1, y + 1, x + 1, y + h - shadowSize - 2);
                g.setColor(borderColorLo);
                if (this.isMenuBarPopup(c)) {
                    g.drawLine(x, y, x + w - dx - shadowSize, y);
                    g.drawLine(x, y, x, y + h - shadowSize - 1);
                    g.drawLine(x, y + h - shadowSize - 1, x + w - shadowSize - 1, y + h - shadowSize - 1);
                    g.drawLine(x + w - shadowSize - 1, y, x + w - shadowSize - 1, y + h - shadowSize - 1);
                } else {
                    g.drawRect(x, y, w - shadowSize - 1, h - shadowSize - 1);
                }
                g.drawLine(x + w - dx - shadowSize, y + 1, x + w - dx - shadowSize, y + h - shadowSize - 1);
            }
            g2D.setColor(AbstractLookAndFeel.getTheme().getShadowColor());
            float alphaValue = 0.4f;
            for (int i = 0; i < shadowSize; ++i) {
                alpha = AlphaComposite.getInstance(3, alphaValue);
                g2D.setComposite(alpha);
                g.drawLine(x + w - shadowSize + i, y + shadowSize, x + w - shadowSize + i, y + h - shadowSize - 1 + i);
                g.drawLine(x + shadowSize, y + h - shadowSize + i, x + w - shadowSize + i, y + h - shadowSize + i);
                alphaValue -= alphaValue / 2.0f;
            }
            g2D.setComposite(savedComposite);
        }
    }

    public static class BasePopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Font logoFont;
        protected static Insets leftLogoInsets;
        protected static Insets rightLogoInsets;
        protected static Insets insets;
        protected static int shadowSize;

        public BasePopupMenuBorder() {
            logoFont = new Font("Dialog", 1, 12);
            leftLogoInsets = new Insets(2, 18, 1, 1);
            rightLogoInsets = new Insets(2, 2, 1, 18);
            insets = new Insets(2, 1, 1, 1);
            shadowSize = 0;
        }

        public boolean isMenuBarPopup(Component c) {
            JPopupMenu pm;
            boolean menuBarPopup = false;
            if (c instanceof JPopupMenu && (pm = (JPopupMenu)c).getInvoker() != null) {
                menuBarPopup = pm.getInvoker().getParent() instanceof JMenuBar;
            }
            return menuBarPopup;
        }

        public boolean hasLogo(Component c) {
            return AbstractLookAndFeel.getTheme().getLogoString() != null && AbstractLookAndFeel.getTheme().getLogoString().length() > 0;
        }

        public Color getLogoColorHi() {
            return Color.white;
        }

        public Color getLogoColorLo() {
            return ColorHelper.darker(AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor(), 20.0);
        }

        public void paintLogo(Component c, Graphics g, int x, int y, int w, int h) {
            if (this.hasLogo(c)) {
                Graphics2D g2D = (Graphics2D)g;
                Font savedFont = g2D.getFont();
                g.setFont(logoFont);
                FontMetrics fm = g2D.getFontMetrics();
                String logo = JTattooUtilities.getClippedText(AbstractLookAndFeel.getTheme().getLogoString(), fm, h - 16);
                AffineTransform savedTransform = g2D.getTransform();
                Color fc = this.getLogoColorHi();
                Color bc = this.getLogoColorLo();
                if (JTattooUtilities.isLeftToRight(c)) {
                    g2D.translate(fm.getAscent() + 1, h - shadowSize - 4);
                    g2D.rotate(Math.toRadians(-90.0));
                    g2D.setColor(bc);
                    JTattooUtilities.drawString((JComponent)c, g, logo, 0, 1);
                    g2D.setColor(fc);
                    JTattooUtilities.drawString((JComponent)c, g, logo, 1, 0);
                } else {
                    g2D.translate(w - shadowSize - 4, h - shadowSize - 4);
                    g2D.rotate(Math.toRadians(-90.0));
                    g2D.setColor(bc);
                    JTattooUtilities.drawString((JComponent)c, g, logo, 0, 1);
                    g2D.setColor(fc);
                    JTattooUtilities.drawString((JComponent)c, g, logo, 1, 0);
                }
                g2D.setTransform(savedTransform);
                g2D.setFont(savedFont);
            }
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource logoColor = AbstractLookAndFeel.getMenuSelectionBackgroundColor();
            ColorUIResource borderColorLo = AbstractLookAndFeel.getFrameColor();
            Color borderColorHi = ColorHelper.brighter(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 40.0);
            g.setColor(logoColor);
            if (JTattooUtilities.isLeftToRight(c)) {
                int dx = this.getBorderInsets((Component)c).left;
                g.fillRect(x, y, dx - 1, h - 1);
                this.paintLogo(c, g, x, y, w, h);
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g.drawLine(x + dx, y + 1, x + w - 2, y + 1);
                g.setColor(borderColorHi);
                g.drawLine(x + 1, y, x + 1, y + h - 2);
                g.setColor(borderColorLo);
                if (this.isMenuBarPopup(c)) {
                    g.drawLine(x + dx - 1, y, x + w, y);
                    g.drawLine(x, y, x, y + h - 1);
                    g.drawLine(x, y + h - 1, x + w, y + h - 1);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                } else {
                    g.drawRect(x, y, w - 1, h - 1);
                }
                g.drawLine(x + dx - 1, y + 1, x + dx - 1, y + h - 1);
            } else {
                int dx = this.getBorderInsets((Component)c).right;
                g.fillRect(x + w - dx, y, dx, h - 1);
                this.paintLogo(c, g, x, y, w, h);
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g.drawLine(x + 1, y + 1, x + w - dx - 1, y + 1);
                g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                g.setColor(borderColorLo);
                if (this.isMenuBarPopup(c)) {
                    g.drawLine(x, y, x + w - dx, y);
                    g.drawLine(x, y, x, y + h - 1);
                    g.drawLine(x, y + h - 1, x + w, y + h - 1);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                } else {
                    g.drawRect(x, y, w - 1, h - 1);
                }
                g.drawLine(x + w - dx, y + 1, x + w - dx, y + h - 1);
            }
        }

        public Insets getBorderInsets(Component c) {
            if (this.hasLogo(c)) {
                if (JTattooUtilities.isLeftToRight(c)) {
                    return new Insets(BasePopupMenuBorder.leftLogoInsets.top, BasePopupMenuBorder.leftLogoInsets.left, BasePopupMenuBorder.leftLogoInsets.bottom + shadowSize, BasePopupMenuBorder.leftLogoInsets.right + shadowSize);
                }
                return new Insets(BasePopupMenuBorder.rightLogoInsets.top, BasePopupMenuBorder.rightLogoInsets.left, BasePopupMenuBorder.rightLogoInsets.bottom + shadowSize, BasePopupMenuBorder.rightLogoInsets.right + shadowSize);
            }
            return new Insets(BasePopupMenuBorder.insets.top, BasePopupMenuBorder.insets.left, BasePopupMenuBorder.insets.bottom + shadowSize, BasePopupMenuBorder.insets.right + shadowSize);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets ins = this.getBorderInsets(c);
            borderInsets.left = ins.left;
            borderInsets.top = ins.top;
            borderInsets.right = ins.right;
            borderInsets.bottom = ins.bottom;
            return borderInsets;
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);
        private static final Insets tableInsets = new Insets(1, 1, 1, 1);
        private boolean tableBorder = false;

        public ScrollPaneBorder(boolean tableBorder) {
            this.tableBorder = tableBorder;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            g.drawRect(x, y, w - 1, h - 1);
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getBackgroundColor(), 50.0));
            g.drawRect(x + 1, y + 1, w - 3, h - 3);
        }

        public Insets getBorderInsets(Component c) {
            if (this.tableBorder) {
                return new Insets(ScrollPaneBorder.tableInsets.top, ScrollPaneBorder.tableInsets.left, ScrollPaneBorder.tableInsets.bottom, ScrollPaneBorder.tableInsets.right);
            }
            return new Insets(ScrollPaneBorder.insets.top, ScrollPaneBorder.insets.left, ScrollPaneBorder.insets.bottom, ScrollPaneBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets ins = this.getBorderInsets(c);
            borderInsets.left = ins.left;
            borderInsets.top = ins.top;
            borderInsets.right = ins.right;
            borderInsets.bottom = ins.bottom;
            return borderInsets;
        }
    }

    public static class TableHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 0);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.8f);
            g2D.setComposite(alpha);
            ColorUIResource cHi = AbstractLookAndFeel.getTheme().getControlHighlightColor();
            ColorUIResource cLo = AbstractLookAndFeel.getTheme().getControlShadowColor();
            JTattooUtilities.draw3DBorder(g, cHi, cLo, x, y, w, h);
            g2D.setComposite(savedComposite);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(TableHeaderBorder.insets.top, TableHeaderBorder.insets.left, TableHeaderBorder.insets.bottom, TableHeaderBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = TableHeaderBorder.insets.left;
            borderInsets.top = TableHeaderBorder.insets.top;
            borderInsets.right = TableHeaderBorder.insets.right;
            borderInsets.bottom = TableHeaderBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            g.drawRect(x, y, width - 1, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(ComboBoxBorder.insets.top, ComboBoxBorder.insets.left, ComboBoxBorder.insets.bottom, ComboBoxBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ComboBoxBorder.insets.left;
            borderInsets.top = ComboBoxBorder.insets.top;
            borderInsets.right = ComboBoxBorder.insets.right;
            borderInsets.bottom = ComboBoxBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class SpinnerBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            g.drawRect(x, y, width - 1, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(SpinnerBorder.insets.top, SpinnerBorder.insets.left, SpinnerBorder.insets.bottom, SpinnerBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = SpinnerBorder.insets.left;
            borderInsets.top = SpinnerBorder.insets.top;
            borderInsets.right = SpinnerBorder.insets.right;
            borderInsets.bottom = SpinnerBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class TextFieldBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            g.drawRect(x, y, width - 1, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(TextFieldBorder.insets.top, TextFieldBorder.insets.left, TextFieldBorder.insets.bottom, TextFieldBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = TextFieldBorder.insets.left;
            borderInsets.top = TextFieldBorder.insets.top;
            borderInsets.right = TextFieldBorder.insets.right;
            borderInsets.bottom = TextFieldBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class FocusFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color hiColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 60.0);
            ColorUIResource loColor = AbstractLookAndFeel.getTheme().getFocusFrameColor();
            g.setColor(loColor);
            g.drawRect(x, y, width - 1, height - 1);
            g.setColor(hiColor);
            g.drawRect(x + 1, y + 1, width - 3, height - 3);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(FocusFrameBorder.insets.top, FocusFrameBorder.insets.left, FocusFrameBorder.insets.bottom, FocusFrameBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = FocusFrameBorder.insets.left;
            borderInsets.top = FocusFrameBorder.insets.top;
            borderInsets.right = FocusFrameBorder.insets.right;
            borderInsets.bottom = FocusFrameBorder.insets.bottom;
            return borderInsets;
        }
    }
}

