/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class BaseInternalFrameUI
extends BasicInternalFrameUI {
    private static final PropertyChangeListener myPropertyChangeListener = new MyPropertyChangeHandler();

    public BaseInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BaseInternalFrameUI((JInternalFrame)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Object paletteProp = c.getClientProperty("JInternalFrame.isPalette");
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
        this.stripContentBorder();
        c.setOpaque(false);
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(myPropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(myPropertyChangeListener);
        super.uninstallListeners();
    }

    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    public void stripContentBorder() {
        Container content = this.frame.getContentPane();
        if (content instanceof JComponent) {
            JComponent contentPane = (JComponent)content;
            contentPane.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new BaseInternalFrameTitlePane(w);
        return this.titlePane;
    }

    public BaseInternalFrameTitlePane getTitlePane() {
        return (BaseInternalFrameTitlePane)this.titlePane;
    }

    public void setPalette(boolean isPalette) {
        if (isPalette) {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.paletteBorder"));
        } else {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.border"));
        }
        if (this.titlePane instanceof BaseInternalFrameTitlePane) {
            ((BaseInternalFrameTitlePane)this.titlePane).setPalette(isPalette);
        }
    }

    protected void activateFrame(JInternalFrame f) {
        this.getDesktopManager().activateFrame(f);
    }

    protected void deactivateFrame(JInternalFrame f) {
        this.getDesktopManager().deactivateFrame(f);
    }

    private static class MyPropertyChangeHandler
    implements PropertyChangeListener {
        private MyPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JInternalFrame jif = (JInternalFrame)e.getSource();
            if (!(jif.getUI() instanceof BaseInternalFrameUI)) {
                return;
            }
            BaseInternalFrameUI ui = (BaseInternalFrameUI)jif.getUI();
            String name = e.getPropertyName();
            if (name.equals("JInternalFrame.frameType")) {
                if (e.getNewValue() instanceof String) {
                    if ("palette".equals(e.getNewValue())) {
                        LookAndFeel.installBorder(ui.frame, "InternalFrame.paletteBorder");
                        ui.setPalette(true);
                    } else {
                        LookAndFeel.installBorder(ui.frame, "InternalFrame.border");
                        ui.setPalette(false);
                    }
                }
            } else if (name.equals("JInternalFrame.isPalette")) {
                if (e.getNewValue() != null) {
                    ui.setPalette((Boolean)e.getNewValue());
                } else {
                    ui.setPalette(false);
                }
            } else if (name.equals("contentPane")) {
                ui.stripContentBorder();
            }
        }
    }
}

