/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class BasePopupMenuUI
extends BasicPopupMenuUI {
    protected static Robot robot = null;
    protected BufferedImage screenImage = null;
    protected MyPopupMenuListener myPopupListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new BasePopupMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setOpaque(true);
    }

    public void installListeners() {
        super.installListeners();
        if (!this.isMenuOpaque()) {
            this.myPopupListener = new MyPopupMenuListener(this);
            this.popupMenu.addPopupMenuListener(this.myPopupListener);
        }
    }

    public void uninstallListeners() {
        if (!this.isMenuOpaque()) {
            this.popupMenu.removePopupMenuListener(this.myPopupListener);
        }
        super.uninstallListeners();
    }

    private boolean isMenuOpaque() {
        return AbstractLookAndFeel.getTheme().isMenuOpaque() || this.getRobot() == null;
    }

    private Robot getRobot() {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return robot;
    }

    public Popup getPopup(JPopupMenu popupMenu, int x, int y) {
        if (!this.isMenuOpaque()) {
            try {
                Dimension size = popupMenu.getPreferredSize();
                Rectangle screenRect = new Rectangle(x, y, size.width, size.height);
                this.screenImage = this.getRobot().createScreenCapture(screenRect);
            }
            catch (Exception ex) {
                this.screenImage = null;
            }
        }
        return super.getPopup(popupMenu, x, y);
    }

    private void resetScreenImage() {
        this.screenImage = null;
    }

    public void update(Graphics g, JComponent c) {
        if (this.screenImage != null) {
            g.drawImage(this.screenImage, 0, 0, null);
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public static class MyPopupMenuListener
    implements PopupMenuListener {
        private BasePopupMenuUI popupMenuUI = null;

        public MyPopupMenuListener(BasePopupMenuUI aPopupMenuUI) {
            this.popupMenuUI = aPopupMenuUI;
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (this.popupMenuUI.screenImage != null) {
                JPopupMenu popup = (JPopupMenu)e.getSource();
                JRootPane root = popup.getRootPane();
                if (popup.isShowing() && root.isShowing()) {
                    Point ptPopup = popup.getLocationOnScreen();
                    Point ptRoot = root.getLocationOnScreen();
                    Graphics g = popup.getRootPane().getGraphics();
                    g.drawImage(this.popupMenuUI.screenImage, ptPopup.x - ptRoot.x, ptPopup.y - ptRoot.y, null);
                    this.popupMenuUI.resetScreenImage();
                }
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }
}

