/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BaseSliderUI
extends BasicSliderUI {
    protected boolean isRollover = false;

    public BaseSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BaseSliderUI((JSlider)c);
    }

    public BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new MyTrackListener();
    }

    public Icon getThumbHorIcon() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            return ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory().getThumbHorIcon();
        }
        return null;
    }

    public Icon getThumbHorIconRollover() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            return ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory().getThumbHorIconRollover();
        }
        return null;
    }

    public Icon getThumbVerIcon() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            return ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory().getThumbVerIcon();
        }
        return null;
    }

    public Icon getThumbVerIconRollover() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            return ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory().getThumbVerIconRollover();
        }
        return null;
    }

    protected int getTrackWidth() {
        if (this.slider.getOrientation() == 0) {
            return this.thumbRect.height - 9;
        }
        return this.thumbRect.width - 9;
    }

    protected Dimension getThumbSize() {
        Dimension size = super.getThumbSize();
        if (this.getThumbHorIcon() != null && this.getThumbVerIcon() != null) {
            if (this.slider.getOrientation() == 0) {
                size.width = this.getThumbHorIcon().getIconWidth();
                size.height = this.getThumbHorIcon().getIconHeight();
            } else {
                size.width = this.getThumbVerIcon().getIconWidth();
                size.height = this.getThumbVerIcon().getIconHeight();
            }
        }
        return size;
    }

    public void paint(Graphics g, JComponent c) {
        this.paintBackground(g, c);
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = g.getClipBounds();
        if (this.slider.getPaintTrack() && clip.intersects(this.trackRect)) {
            this.paintTrack(g);
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
        if (this.slider.hasFocus() && clip.intersects(this.focusRect)) {
            this.paintFocus(g);
        }
        if (clip.intersects(this.thumbRect)) {
            this.paintThumb(g);
        }
    }

    public void paintBackground(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            if (c.getBackground() instanceof ColorUIResource) {
                g.setColor(AbstractLookAndFeel.getBackgroundColor());
            } else {
                g.setColor(c.getBackground());
            }
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public void paintTrack(Graphics g) {
        boolean leftToRight = JTattooUtilities.isLeftToRight(this.slider);
        g.translate(this.trackRect.x, this.trackRect.y);
        int overhang = 4;
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - overhang;
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - overhang - this.getTrackWidth();
                trackRight = this.trackRect.width - overhang - 1;
            } else {
                trackLeft = overhang;
                trackRight = overhang + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        g.setColor(AbstractLookAndFeel.getFrameColor());
        g.drawRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1);
        int middleOfThumb = 0;
        int fillTop = 0;
        int fillLeft = 0;
        int fillBottom = 0;
        int fillRight = 0;
        if (this.slider.getOrientation() == 0) {
            middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
            middleOfThumb -= this.trackRect.x;
            fillTop = trackTop + 1;
            fillBottom = trackBottom - 2;
            if (!this.drawInverted()) {
                fillLeft = trackLeft + 1;
                fillRight = middleOfThumb;
            } else {
                fillLeft = middleOfThumb;
                fillRight = trackRight - 2;
            }
            Color[] colors = null;
            colors = !JTattooUtilities.isActive(this.slider) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (this.slider.isEnabled() ? AbstractLookAndFeel.getTheme().getSliderColors() : AbstractLookAndFeel.getTheme().getDisabledColors());
            JTattooUtilities.fillHorGradient(g, colors, fillLeft + 2, fillTop + 2, fillRight - fillLeft - 2, fillBottom - fillTop - 2);
            Color cHi = ColorHelper.darker(colors[colors.length - 1], 5.0);
            Color cLo = ColorHelper.darker(colors[colors.length - 1], 10.0);
            JTattooUtilities.draw3DBorder(g, cHi, cLo, fillLeft + 1, fillTop + 1, fillRight - fillLeft - 1, fillBottom - fillTop - 1);
        } else {
            middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
            middleOfThumb -= this.trackRect.y;
            fillLeft = trackLeft + 1;
            fillRight = trackRight - 2;
            if (!this.drawInverted()) {
                fillTop = middleOfThumb;
                fillBottom = trackBottom - 2;
            } else {
                fillTop = trackTop + 1;
                fillBottom = middleOfThumb;
            }
            Color[] colors = null;
            colors = !JTattooUtilities.isActive(this.slider) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (this.slider.isEnabled() ? AbstractLookAndFeel.getTheme().getSliderColors() : AbstractLookAndFeel.getTheme().getDisabledColors());
            JTattooUtilities.fillVerGradient(g, colors, fillLeft + 2, fillTop + 2, fillRight - fillLeft - 2, fillBottom - fillTop - 2);
            Color cHi = ColorHelper.darker(colors[colors.length - 1], 5.0);
            Color cLo = ColorHelper.darker(colors[colors.length - 1], 10.0);
            JTattooUtilities.draw3DBorder(g, cHi, cLo, fillLeft + 1, fillTop + 1, fillRight - fillLeft - 1, fillBottom - fillTop - 1);
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    public void paintTicks(Graphics g) {
        boolean leftToRight = JTattooUtilities.isLeftToRight(this.slider);
        Rectangle tickBounds = this.tickRect;
        g.setColor(AbstractLookAndFeel.getForegroundColor());
        if (this.slider.getOrientation() == 0) {
            int value;
            g.translate(0, tickBounds.y);
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum();
            int yPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!leftToRight) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!leftToRight) {
                    g.translate(-offset, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum();
                if (!leftToRight) {
                    g.translate(2, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!leftToRight) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    public void paintThumb(Graphics g) {
        Icon icon = null;
        icon = this.slider.getOrientation() == 0 ? (this.isRollover && this.slider.isEnabled() ? this.getThumbHorIconRollover() : this.getThumbHorIcon()) : (this.isRollover && this.slider.isEnabled() ? this.getThumbVerIconRollover() : this.getThumbVerIcon());
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        if (!this.slider.isEnabled()) {
            g.setColor(AbstractLookAndFeel.getBackgroundColor());
            g.fillRect(this.thumbRect.x + 1, this.thumbRect.y + 1, this.thumbRect.width - 2, this.thumbRect.height - 2);
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
        }
        icon.paintIcon(null, g, this.thumbRect.x, this.thumbRect.y);
        g2D.setComposite(savedComposite);
    }

    protected class MyTrackListener
    extends BasicSliderUI.TrackListener {
        protected MyTrackListener() {
            super(BaseSliderUI.this);
        }

        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            if (BaseSliderUI.this.slider.isEnabled()) {
                BaseSliderUI.this.isRollover = BaseSliderUI.this.thumbRect.contains(e.getPoint());
                BaseSliderUI.this.paintThumb(BaseSliderUI.this.slider.getGraphics());
            }
        }

        public void mouseMoved(MouseEvent e) {
            boolean rollover;
            super.mouseEntered(e);
            if (BaseSliderUI.this.slider.isEnabled() && (rollover = BaseSliderUI.this.thumbRect.contains(e.getPoint())) != BaseSliderUI.this.isRollover) {
                BaseSliderUI.this.isRollover = rollover;
                BaseSliderUI.this.paintThumb(BaseSliderUI.this.slider.getGraphics());
            }
        }

        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            if (BaseSliderUI.this.slider.isEnabled()) {
                BaseSliderUI.this.isRollover = false;
                BaseSliderUI.this.paintThumb(BaseSliderUI.this.slider.getGraphics());
            }
        }
    }
}

