/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.texture.TextureScrollButton;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class XPScrollBarUI
extends BaseScrollBarUI {
    protected static Color[] rolloverColors = null;
    protected static Color[] dragColors = null;

    public static ComponentUI createUI(JComponent c) {
        return new XPScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        Color[] colors = AbstractLookAndFeel.getTheme().getThumbColors();
        rolloverColors = new Color[colors.length];
        dragColors = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            XPScrollBarUI.rolloverColors[i] = ColorHelper.brighter(colors[i], 16.0);
            XPScrollBarUI.dragColors[i] = ColorHelper.darker(colors[i], 8.0);
        }
    }

    protected JButton createDecreaseButton(int orientation) {
        return new TextureScrollButton(orientation, this.scrollBarWidth);
    }

    protected JButton createIncreaseButton(int orientation) {
        return new TextureScrollButton(orientation, this.scrollBarWidth);
    }

    protected Color getFrameColor() {
        return Color.white;
    }

    protected Color[] getThumbColors() {
        if (this.isDragging) {
            return dragColors;
        }
        if (this.isRollover) {
            return rolloverColors;
        }
        return AbstractLookAndFeel.getTheme().getThumbColors();
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        AlphaComposite alpha;
        if (!c.isEnabled()) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        int x = thumbBounds.x;
        int y = thumbBounds.y;
        int width = thumbBounds.width;
        int height = thumbBounds.height;
        g.translate(x, y);
        Color[] colors = this.getThumbColors();
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(g, colors, 0, 0, width, height);
            alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            int dx = 6;
            int dy = height / 2 - 3;
            int dw = width - 13;
            Color c1 = ColorHelper.brighter(colors[0], 60.0);
            Color c2 = ColorHelper.darker(colors[0], 30.0);
            for (int i = 0; i < 4; ++i) {
                g.setColor(c1);
                g.drawLine(dx, dy, dx + dw, dy);
                g.setColor(c2);
                g.drawLine(dx, ++dy, dx + dw, dy);
                ++dy;
            }
        } else {
            JTattooUtilities.fillHorGradient(g, colors, 0, 0, width, height);
            int dx = width / 2 - 3;
            int dy = 6;
            int dh = height - 13;
            AlphaComposite alpha2 = AlphaComposite.getInstance(3, 0.8f);
            g2D.setComposite(alpha2);
            Color c1 = ColorHelper.brighter(colors[0], 60.0);
            Color c2 = ColorHelper.darker(colors[0], 30.0);
            for (int i = 0; i < 4; ++i) {
                g.setColor(c1);
                g.drawLine(dx, dy, dx, dy + dh);
                g.setColor(c2);
                g.drawLine(++dx, dy, dx, dy + dh);
                ++dx;
            }
        }
        g2D.setComposite(savedComposite);
        g.setColor(this.getFrameColor());
        g.drawLine(1, 1, width - 2, 1);
        g.drawLine(1, 2, 1, height - 3);
        g.drawLine(width - 2, 2, width - 2, height - 3);
        g.drawLine(2, height - 2, width - 3, height - 2);
        alpha = AlphaComposite.getInstance(3, 0.5f);
        g2D.setComposite(alpha);
        Color fc = colors[colors.length - 1];
        g2D.setColor(fc);
        g.drawLine(2, 2, width - 3, 2);
        g.drawLine(2, 3, 2, height - 3);
        g.setColor(ColorHelper.darker(fc, 40.0));
        g.drawLine(width - 1, 2, width - 1, height - 3);
        g.drawLine(3, height - 1, width - 3, height - 1);
        alpha = AlphaComposite.getInstance(3, 0.2f);
        g2D.setComposite(alpha);
        g.drawLine(1, height - 2, 2, height - 1);
        g.drawLine(width - 1, height - 2, width - 2, height - 1);
        g.translate(-x, -y);
        g2D.setComposite(savedComposite);
    }
}

