/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class AcrylTitlePane
extends BaseTitlePane {
    public AcrylTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 1;
    }

    protected int getVerSpacing() {
        return 3;
    }

    public void paintBorder(Graphics g) {
        if (this.isActive()) {
            g.setColor(AbstractLookAndFeel.getWindowBorderColor());
        } else {
            g.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
        }
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g, int x, int y, String title) {
        x += this.paintIcon(g, x, y);
        Color shadowColor = AbstractLookAndFeel.getWindowTitleColorDark();
        if (this.isActive()) {
            shadowColor = ColorHelper.darker(shadowColor, 30.0);
        }
        g.setColor(shadowColor);
        JTattooUtilities.drawString(this.rootPane, g, title, x - 1, y - 1);
        JTattooUtilities.drawString(this.rootPane, g, title, x - 1, y + 1);
        JTattooUtilities.drawString(this.rootPane, g, title, x + 1, y - 1);
        JTattooUtilities.drawString(this.rootPane, g, title, x + 1, y + 1);
        if (this.isActive()) {
            g.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.rootPane, g, title, x, y);
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        protected int computeHeight() {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(AcrylTitlePane.this.getFont());
            return fm.getHeight() + 5;
        }

        public void layoutContainer(Container c) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c);
            } else {
                this.layoutDefault(c);
            }
        }

        public void layoutDefault(Container c) {
            boolean leftToRight = AcrylTitlePane.this.isLeftToRight();
            int spacing = AcrylTitlePane.this.getHorSpacing();
            int w = AcrylTitlePane.this.getWidth();
            int h = AcrylTitlePane.this.getHeight();
            int buttonHeight = h - AcrylTitlePane.this.getVerSpacing();
            int buttonWidth = buttonHeight + 10;
            int x = leftToRight ? spacing : w - buttonWidth - spacing;
            int y = Math.max(0, (h - buttonHeight) / 2 - 1);
            int cpx = 0;
            int cpy = 0;
            int cpw = AcrylTitlePane.this.getWidth();
            int cph = AcrylTitlePane.this.getHeight();
            if (AcrylTitlePane.this.menuBar != null) {
                int mw = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().width;
                int mh = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().height;
                if (leftToRight) {
                    cpx = 4 + mw;
                    AcrylTitlePane.this.menuBar.setBounds(2, (h - mh) / 2, mw, mh);
                } else {
                    AcrylTitlePane.this.menuBar.setBounds(AcrylTitlePane.this.getWidth() - mw, (h - mh) / 2, mw, mh);
                }
                cpw -= 4 + mw;
            }
            int n = x = leftToRight ? w - spacing : 0;
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(x += leftToRight ? -buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                AcrylTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            AcrylTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                if (!leftToRight) {
                    cpx += AcrylTitlePane.this.buttonsWidth;
                }
                cpw -= AcrylTitlePane.this.buttonsWidth;
                Graphics g = AcrylTitlePane.this.getGraphics();
                if (g != null) {
                    FontMetrics fm = g.getFontMetrics();
                    int tw = SwingUtilities.computeStringWidth(fm, JTattooUtilities.getClippedText(AcrylTitlePane.this.getTitle(), fm, cpw));
                    if (leftToRight) {
                        cpx += tw;
                    }
                    cpw -= tw;
                }
                AcrylTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
            }
        }

        private void layoutMacStyle(Container c) {
            int buttonHeight;
            int spacing = AcrylTitlePane.this.getHorSpacing();
            int h = AcrylTitlePane.this.getHeight();
            int buttonWidth = buttonHeight = h - AcrylTitlePane.this.getVerSpacing();
            int x = 0;
            int y = 0;
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
                x += buttonWidth + spacing;
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(x, y, buttonWidth, buttonHeight);
                x += buttonWidth + spacing;
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                AcrylTitlePane.this.maxButton.setBounds(x, y, buttonWidth, buttonHeight);
                x += buttonWidth + spacing;
            }
            AcrylTitlePane.this.buttonsWidth = x;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                int cpx = AcrylTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((AcrylTitlePane)AcrylTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h;
                AcrylTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                AcrylTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }
}

