/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.aluminium.AluminiumGradientPaint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class AluminiumUtils {
    private AluminiumUtils() {
    }

    public static void fillComponent(Graphics g, Component c) {
        if (!JTattooUtilities.isMac() && AbstractLookAndFeel.getTheme().isBackgroundPatternOn()) {
            Point offset = JTattooUtilities.getRelLocation(c);
            Dimension size = JTattooUtilities.getFrameSize(c);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setPaint(new AluminiumGradientPaint(offset, size));
            g2D.fillRect(0, 0, c.getWidth(), c.getHeight());
            g2D.setPaint(null);
        } else {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public static void fillComponent(Graphics g, Component c, int x, int y, int w, int h) {
        Graphics2D g2D = (Graphics2D)g;
        Shape savedClip = g2D.getClip();
        Area clipArea = new Area(new Rectangle2D.Double(x, y, w, h));
        clipArea.intersect(new Area(savedClip));
        g2D.setClip(clipArea);
        AluminiumUtils.fillComponent(g, c);
        g2D.setClip(savedClip);
    }
}

