/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class FastBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return FastBorders.getButtonBorder();
    }

    public static Border getToolButtonBorder() {
        if (toolButtonBorder == null) {
            toolButtonBorder = new ToolButtonBorder();
        }
        return toolButtonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean active = this.isActive(c);
            boolean resizable = this.isResizable(c);
            ColorUIResource frameColor = AbstractLookAndFeel.getFrameColor();
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            if (active) {
                borderColor = AbstractLookAndFeel.getWindowBorderColor();
            }
            Color cHi = ColorHelper.brighter(frameColor, 40.0);
            Color cLo = frameColor;
            if (!resizable) {
                JTattooUtilities.draw3DBorder(g, cHi, cLo, x, y, w, h);
                g.setColor(borderColor);
                for (int i = 1; i < 5; ++i) {
                    g.drawRect(i, i, w - 2 * i - 1, h - 2 * i - 1);
                }
                return;
            }
            JTattooUtilities.draw3DBorder(g, cHi, cLo, x, y, w, h);
            cHi = ColorHelper.brighter(borderColor, 40.0);
            cLo = ColorHelper.darker(borderColor, 20.0);
            JTattooUtilities.draw3DBorder(g, cHi, cLo, x + 1, y + 1, w - 2, h - 2);
            g.setColor(borderColor);
            g.drawRect(x + 2, y + 2, w - 5, h - 5);
            g.drawRect(x + 3, y + 3, w - 7, h - 7);
            JTattooUtilities.draw3DBorder(g, ColorHelper.darker(borderColor, 5.0), ColorHelper.brighter(borderColor, 30.0), x + 4, y + 4, w - 8, h - 8);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            ColorUIResource loColor = AbstractLookAndFeel.getFrameColor();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(loColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.black);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(loColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.white);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color hiColor = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 90.0);
            ColorUIResource loColor = AbstractLookAndFeel.getFrameColor();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(loColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.black);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                } else {
                    JTattooUtilities.draw3DBorder(g, hiColor, loColor, 0, 0, w, h);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(ToolButtonBorder.insets.top, ToolButtonBorder.insets.left, ToolButtonBorder.insets.bottom, ToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ToolButtonBorder.insets.left;
            borderInsets.top = ToolButtonBorder.insets.top;
            borderInsets.right = ToolButtonBorder.insets.right;
            borderInsets.bottom = ToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultFrameColor = new Color(0, 64, 255);
        private static final Insets insets = new Insets(4, 8, 4, 8);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color frameColor = ColorHelper.darker(button.getBackground(), 30.0);
            if (model.isEnabled()) {
                JButton b;
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    g.setColor(frameColor);
                    g.drawRect(x, y, w - 1, h - 1);
                } else {
                    g.setColor(frameColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    g.setColor(ColorHelper.brighter(button.getBackground(), 40.0));
                    g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                }
                if (c instanceof JButton && (b = (JButton)c).equals(b.getRootPane().getDefaultButton())) {
                    g.setColor(defaultFrameColor);
                    g.drawRect(x, y, w - 1, h - 1);
                }
            } else {
                g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                g.drawRect(x, y, w - 1, h - 1);
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

