/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class FastTabbedPaneUI
extends BaseTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new FastTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.roundedTabs = false;
        this.tabAreaInsets = new Insets(2, 6, 2, 6);
        this.contentBorderInsets = new Insets(0, 0, 0, 0);
    }

    protected boolean hasInnerBorder() {
        return true;
    }

    protected Color[] getTabColors(int tabIndex, boolean isSelected, boolean isRollover) {
        Color[] colorArr = AbstractLookAndFeel.getTheme().getTabColors();
        if (tabIndex >= 0 && tabIndex < this.tabPane.getTabCount()) {
            Color backColor = this.tabPane.getBackgroundAt(tabIndex);
            colorArr = backColor instanceof UIResource ? (isSelected ? AbstractLookAndFeel.getTheme().getSelectedColors() : (JTattooUtilities.isFrameActive(this.tabPane) ? AbstractLookAndFeel.getTheme().getTabColors() : AbstractLookAndFeel.getTheme().getInActiveColors())) : ColorHelper.createColorArr(backColor, backColor, 2);
        }
        return colorArr;
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.isTabOpaque() || isSelected) {
            Color[] colorArr = this.getTabColors(tabIndex, isSelected, false);
            g.setColor(colorArr[0]);
            switch (tabPlacement) {
                case 1: {
                    if (isSelected) {
                        g.fillRect(x + 1, y + 1, w - 1, h + 2);
                        break;
                    }
                    g.fillRect(x + 1, y + 1, w - 1, h - 1);
                    break;
                }
                case 2: {
                    if (isSelected) {
                        g.fillRect(x + 1, y + 1, w + 2, h - 1);
                        break;
                    }
                    g.fillRect(x + 1, y + 1, w - 1, h - 1);
                    break;
                }
                case 3: {
                    if (isSelected) {
                        g.fillRect(x + 1, y - 2, w - 1, h + 1);
                        break;
                    }
                    g.fillRect(x + 1, y, w - 1, h - 1);
                    break;
                }
                case 4: {
                    if (isSelected) {
                        g.fillRect(x - 2, y + 1, w + 2, h - 1);
                        break;
                    }
                    g.fillRect(x, y + 1, w, h - 1);
                }
            }
        }
    }
}

