/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class LunaBorders
extends BaseBorders {
    public static Border getTextBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new TextFieldBorder();
        }
        return textFieldBorder;
    }

    public static Border getTextFieldBorder() {
        return LunaBorders.getTextBorder();
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new ComboBoxBorder();
        }
        return comboBoxBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder(false);
        }
        return scrollPaneBorder;
    }

    public static Border getTableScrollPaneBorder() {
        if (tableScrollPaneBorder == null) {
            tableScrollPaneBorder = new ScrollPaneBorder(true);
        }
        return tableScrollPaneBorder;
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return LunaBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new TableHeaderBorder();
        }
        return tableHeaderBorder;
    }

    public static class TableHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(0, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getControlBackgroundColor(), 40.0));
            g.drawLine(0, 0, 0, h - 1);
            g.setColor(ColorHelper.darker(AbstractLookAndFeel.getControlBackgroundColor(), 20.0));
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.setColor(ColorHelper.darker(AbstractLookAndFeel.getControlBackgroundColor(), 10.0));
            g.drawLine(0, h - 1, w - 1, h - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(TableHeaderBorder.insets.top, TableHeaderBorder.insets.left, TableHeaderBorder.insets.bottom, TableHeaderBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = TableHeaderBorder.insets.left;
            borderInsets.top = TableHeaderBorder.insets.top;
            borderInsets.right = TableHeaderBorder.insets.right;
            borderInsets.bottom = TableHeaderBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public InternalFrameBorder() {
            this.insets.top = 3;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean active = this.isActive(c);
            int th = this.getTitleHeight(c);
            Color titleColor = AbstractLookAndFeel.getWindowTitleColorLight();
            Color borderColor = AbstractLookAndFeel.getWindowBorderColor();
            if (!active) {
                titleColor = ColorHelper.brighter(titleColor, 20.0);
                borderColor = ColorHelper.brighter(borderColor, 20.0);
            }
            g.setColor(titleColor);
            g.fillRect(x, y + 1, w, this.insets.top - 1);
            g.setColor(borderColor);
            g.fillRect(x + 1, y + h - 5, w - 2, 4);
            g.fillRect(1, this.insets.top + th + 1, 4, h - th - 5);
            g.fillRect(w - 5, this.insets.top + th + 1, 4, h - th - 5);
            if (active) {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w - 5, this.insets.top, 5, th + 1);
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w - 5, this.insets.top, 5, th + 1);
            }
            g.setColor(ColorHelper.darker(borderColor, 15.0));
            g.drawRect(x, y, w - 1, h - 1);
            g.drawLine(x + 5 - 1, y + this.insets.top + th, x + 5 - 1, y + h - 5);
            g.drawLine(x + w - 5, y + this.insets.top + th, x + w - 5, y + h - 5);
            g.drawLine(x + 5 - 1, y + h - 5, x + w - 5, y + h - 5);
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Color fieldBorderColor = new Color(127, 157, 185);
        private static final Insets insets = new Insets(2, 2, 2, 2);
        private static final Insets tableInsets = new Insets(1, 1, 1, 1);
        private boolean tableBorder = false;

        public ScrollPaneBorder(boolean tableBorder) {
            this.tableBorder = tableBorder;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(fieldBorderColor);
            g.drawRect(x, y, w - 1, h - 1);
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getBackgroundColor(), 50.0));
            g.drawRect(x + 1, y + 1, w - 3, h - 3);
        }

        public Insets getBorderInsets(Component c) {
            if (this.tableBorder) {
                return new Insets(ScrollPaneBorder.tableInsets.top, ScrollPaneBorder.tableInsets.left, ScrollPaneBorder.tableInsets.bottom, ScrollPaneBorder.tableInsets.right);
            }
            return new Insets(ScrollPaneBorder.insets.top, ScrollPaneBorder.insets.left, ScrollPaneBorder.insets.bottom, ScrollPaneBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets ins = this.getBorderInsets(c);
            borderInsets.left = ins.left;
            borderInsets.top = ins.top;
            borderInsets.right = ins.right;
            borderInsets.bottom = ins.bottom;
            return borderInsets;
        }
    }

    public static class TextFieldBorder
    extends AbstractBorder
    implements UIResource {
        private static final Color fieldBorderColor = new Color(127, 157, 185);
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(fieldBorderColor);
            g.drawRect(x, y, --width, --height);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(TextFieldBorder.insets.top, TextFieldBorder.insets.left, TextFieldBorder.insets.bottom, TextFieldBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = TextFieldBorder.insets.left;
            borderInsets.top = TextFieldBorder.insets.top;
            borderInsets.right = TextFieldBorder.insets.right;
            borderInsets.bottom = TextFieldBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final Color fieldBorderColor = new Color(127, 157, 185);
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(fieldBorderColor);
            g.drawRect(x, y, --width, --height);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(ComboBoxBorder.insets.top, ComboBoxBorder.insets.left, ComboBoxBorder.insets.bottom, ComboBoxBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ComboBoxBorder.insets.left;
            borderInsets.top = ComboBoxBorder.insets.top;
            borderInsets.right = ComboBoxBorder.insets.right;
            borderInsets.bottom = ComboBoxBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Color frameColor = ColorHelper.darker(AbstractLookAndFeel.getToolbarBackgroundColor(), 20.0);
                    g.setColor(frameColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.1f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.black);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    ColorUIResource frameColor = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color frameHiColor = ColorHelper.darker(frameColor, 5.0);
                    Color frameLoColor = ColorHelper.darker(frameColor, 30.0);
                    JTattooUtilities.draw3DBorder(g, frameHiColor, frameLoColor, x, y, w, h);
                    frameHiColor = Color.white;
                    frameLoColor = ColorHelper.brighter(frameLoColor, 60.0);
                    JTattooUtilities.draw3DBorder(g, frameHiColor, frameLoColor, x + 1, y + 1, w - 2, h - 2);
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.2f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.white);
                    g.fillRect(x + 2, y + 2, w - 4, h - 4);
                    g2D.setComposite(composite);
                } else if (model.isSelected()) {
                    ColorUIResource frameColor = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color frameHiColor = Color.white;
                    Color frameLoColor = ColorHelper.darker(frameColor, 30.0);
                    JTattooUtilities.draw3DBorder(g, frameLoColor, frameHiColor, x, y, w, h);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultColorHi = new Color(220, 230, 245);
        private static final Color defaultColorMed = new Color(212, 224, 243);
        private static final Color defaultColorLo = new Color(200, 215, 240);
        private static final Insets insets = new Insets(3, 6, 3, 6);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            Graphics2D g2D = (Graphics2D)g;
            Color frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            if (!JTattooUtilities.isFrameActive(button)) {
                frameColor = ColorHelper.brighter(frameColor, 40.0);
            }
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (button.getRootPane() != null && button.equals(button.getRootPane().getDefaultButton()) && !button.getModel().isRollover()) {
                g2D.setColor(defaultColorHi);
                g2D.drawRoundRect(x + 1, y + 1, w - 4, h - 5, 6, 6);
                g2D.setColor(defaultColorMed);
                g2D.drawRoundRect(x + 2, y + 2, w - 6, h - 6, 6, 6);
                g2D.setColor(defaultColorLo);
                g2D.drawLine(x + 3, h - 3, w - 3, h - 3);
                g2D.drawLine(w - 3, y + 4, w - 3, h - 4);
            }
            g2D.setColor(Color.white);
            g2D.drawRoundRect(x, y, w - 1, h - 1, 6, 6);
            g2D.setColor(frameColor);
            g2D.drawRoundRect(x, y, w - 2, h - 2, 6, 6);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

