/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class McWinButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new McWinButtonUI();
    }

    protected void paintBackground(Graphics g, AbstractButton b) {
        if (b.getParent() instanceof JToolBar) {
            b.setContentAreaFilled(true);
        }
        if (!b.isContentAreaFilled() || b.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b.getWidth();
        int height = b.getHeight();
        if (!b.isBorderPainted() || !(b.getBorder() instanceof UIResource) || b.getParent() instanceof JToolBar) {
            super.paintBackground(g, b);
            if (b.getParent() instanceof JToolBar) {
                g.setColor(Color.lightGray);
                g.drawRect(0, 0, width - 2, height - 1);
                g.setColor(AbstractLookAndFeel.getTheme().getToolbarBackgroundColor());
                g.drawLine(width - 1, 0, width - 1, height - 1);
            }
            return;
        }
        ButtonModel model = b.getModel();
        Graphics2D g2D = (Graphics2D)g;
        Composite composite = g2D.getComposite();
        Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (AbstractLookAndFeel.getTheme().doDrawSquareButtons() || (width < 64 || height < 16) && (b.getText() == null || b.getText().length() == 0)) {
            Color[] backColors = null;
            if (b.getBackground() instanceof ColorUIResource) {
                if (!model.isEnabled()) {
                    backColors = AbstractLookAndFeel.getTheme().getDisabledColors();
                } else if (model.isPressed() && model.isArmed()) {
                    backColors = new Color[]{AbstractLookAndFeel.getTheme().getBackgroundColor()};
                } else if (b.isRolloverEnabled() && model.isRollover()) {
                    backColors = AbstractLookAndFeel.getTheme().getRolloverColors();
                } else if (b.equals(b.getRootPane().getDefaultButton())) {
                    if (JTattooUtilities.isFrameActive(b)) {
                        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus()) {
                            backColors = AbstractLookAndFeel.getTheme().getFocusColors();
                        } else if (AbstractLookAndFeel.getTheme().isBrightMode()) {
                            backColors = new Color[AbstractLookAndFeel.getTheme().getSelectedColors().length];
                            for (int i = 0; i < backColors.length; ++i) {
                                backColors[i] = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getSelectedColors()[i], 30.0);
                            }
                        } else {
                            backColors = AbstractLookAndFeel.getTheme().getSelectedColors();
                        }
                    } else {
                        backColors = AbstractLookAndFeel.getTheme().getButtonColors();
                    }
                } else {
                    backColors = AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus() ? AbstractLookAndFeel.getTheme().getFocusColors() : AbstractLookAndFeel.getTheme().getButtonColors();
                }
            } else {
                backColors = ColorHelper.createColorArr(ColorHelper.brighter(b.getBackground(), 20.0), ColorHelper.darker(b.getBackground(), 20.0), 20);
            }
            JTattooUtilities.fillHorGradient(g, backColors, 0, 0, width - 1, height - 1);
            Color frameColor = backColors[backColors.length / 2];
            g2D.setColor(ColorHelper.darker(frameColor, 25.0));
            g2D.drawRect(0, 0, width - 1, height - 1);
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRect(1, 1, width - 3, height - 3);
        } else if (model.isPressed() && model.isArmed()) {
            int d = height - 2;
            ColorUIResource color = AbstractLookAndFeel.getTheme().getBackgroundColor();
            g2D.setColor(color);
            g2D.fillRoundRect(1, 1, width - 1, height - 1, d, d);
            g2D.setColor(ColorHelper.darker(color, 40.0));
            g2D.drawRoundRect(0, 0, width - 1, height - 1, d, d);
        } else {
            int d = height - 2;
            Color[] backColors = null;
            backColors = b.getBackground() instanceof ColorUIResource ? (!model.isEnabled() ? AbstractLookAndFeel.getTheme().getDisabledColors() : (b.isRolloverEnabled() && model.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (b.equals(b.getRootPane().getDefaultButton()) ? (JTattooUtilities.isFrameActive(b) ? AbstractLookAndFeel.getTheme().getSelectedColors() : AbstractLookAndFeel.getTheme().getButtonColors()) : AbstractLookAndFeel.getTheme().getButtonColors()))) : ColorHelper.createColorArr(ColorHelper.brighter(b.getBackground(), 20.0), ColorHelper.darker(b.getBackground(), 20.0), 20);
            Color frameColor = backColors[backColors.length / 2];
            Shape savedClip = g.getClip();
            Area clipArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, d, d));
            clipArea.intersect(new Area(savedClip));
            g2D.setClip(clipArea);
            JTattooUtilities.fillHorGradient(g, backColors, 0, 0, width - 1, height - 1);
            g2D.setClip(savedClip);
            g2D.setColor(ColorHelper.darker(frameColor, 25.0));
            g2D.drawRoundRect(0, 0, width - 1, height - 1, d, d);
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRoundRect(1, 1, width - 3, height - 3, d - 2, d - 2);
        }
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        g2D.setComposite(composite);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Graphics2D g2D = (Graphics2D)g;
        int width = b.getWidth();
        int height = b.getHeight();
        if (AbstractLookAndFeel.getTheme().doDrawSquareButtons() || !b.isContentAreaFilled() || (width < 64 || height < 16) && (b.getText() == null || b.getText().length() == 0)) {
            g.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g, 4, 3, width - 8, height - 6);
        } else {
            Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(AbstractLookAndFeel.getFocusColor());
            int d = b.getHeight() - 4;
            g2D.drawRoundRect(2, 2, b.getWidth() - 5, b.getHeight() - 5, d, d);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        }
    }
}

