/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class MintBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean active = this.isActive(c);
            boolean resizable = this.isResizable(c);
            if (!resizable) {
                ColorUIResource frameColor = AbstractLookAndFeel.getFrameColor();
                ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
                if (active) {
                    borderColor = AbstractLookAndFeel.getWindowBorderColor();
                }
                Color cHi = ColorHelper.brighter(frameColor, 40.0);
                ColorUIResource cLo = frameColor;
                JTattooUtilities.draw3DBorder(g, cHi, cLo, x, y, w, h);
                g.setColor(borderColor);
                for (int i = 1; i < 5; ++i) {
                    g.drawRect(i, i, w - 2 * i - 1, h - 2 * i - 1);
                }
                return;
            }
            --h;
            --w;
            ColorUIResource color = AbstractLookAndFeel.getWindowInactiveBorderColor();
            if (active) {
                color = AbstractLookAndFeel.getWindowBorderColor();
            }
            g.setColor(color);
            g.drawLine(x, y, x, y + h);
            g.setColor(ColorHelper.brighter(color, 60.0));
            g.drawLine(x + 1, y + 1, x + 1, y + h - 1);
            g.setColor(ColorHelper.brighter(color, 40.0));
            g.drawLine(x + 2, y + 2, x + 2, y + h - 2);
            g.setColor(ColorHelper.brighter(color, 20.0));
            g.drawLine(x + 3, y + 3, x + 3, y + h - 3);
            g.setColor(color);
            g.drawLine(x + 4, y + 4, x + 4, y + h - 4);
            g.setColor(color);
            g.drawLine(x + w, y, x + w, y + h);
            g.setColor(ColorHelper.brighter(color, 20.0));
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            g.setColor(ColorHelper.brighter(color, 40.0));
            g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 2);
            g.setColor(ColorHelper.brighter(color, 60.0));
            g.drawLine(x + w - 3, y + 3, x + w - 3, y + h - 3);
            g.setColor(color);
            g.drawLine(x + w - 4, y + 4, x + w - 4, y + h - 4);
            g.setColor(color);
            g.drawLine(x, y, x + w, y);
            g.setColor(ColorHelper.brighter(color, 60.0));
            g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
            g.setColor(ColorHelper.brighter(color, 40.0));
            g.drawLine(x + 2, y + 2, x + w - 2, y + 2);
            g.setColor(ColorHelper.brighter(color, 20.0));
            g.drawLine(x + 3, y + 3, x + w - 3, y + 3);
            g.setColor(color);
            g.drawLine(x + 4, y + 4, x + w - 4, y + 4);
            g.setColor(color);
            g.drawLine(x, y + h, x + w, y + h);
            g.setColor(ColorHelper.brighter(color, 20.0));
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(ColorHelper.brighter(color, 40.0));
            g.drawLine(x + 2, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(ColorHelper.brighter(color, 60.0));
            g.drawLine(x + 3, y + h - 3, x + w - 3, y + h - 3);
            g.setColor(color);
            g.drawLine(x + 4, y + h - 4, x + w - 4, y + h - 4);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color frameColor = ColorHelper.darker(AbstractLookAndFeel.getToolbarBackgroundColor(), 20.0);
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(frameColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.black);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(frameColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.white);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(3, 8, 5, 10);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

