/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class SmartTitlePane
extends BaseTitlePane {
    public SmartTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    public void createButtons() {
        this.iconifyButton = new BaseTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.restoreAction, "Maximize", this.maximizeIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f);
    }

    public void paintBorder(Graphics g) {
        if (this.isActive()) {
            g.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
        } else {
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0));
        }
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintBackground(Graphics g) {
        int dx;
        int dw;
        boolean leftToRight;
        int xOffset;
        Graphics2D g2D = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        Color backColor = null;
        Color frameColor = null;
        if (JTattooUtilities.isActive(this)) {
            backColor = AbstractLookAndFeel.getTheme().getWindowTitleColors()[10];
            frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, width, height);
        } else {
            backColor = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors()[10];
            frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0);
            JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, width, height);
        }
        int iconWidth = 0;
        if (this.menuBar != null) {
            iconWidth = this.menuBar.getWidth() + 5;
        }
        int titleWidth = 0;
        String frameTitle = this.getTitle();
        if (frameTitle != null) {
            Image image;
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            titleWidth = fm.stringWidth(JTattooUtilities.getClippedText(this.getTitle(), fm, this.getWidth() - iconWidth - this.buttonsWidth - 15)) + 10;
            if (this.getWindow() instanceof JDialog && (image = this.getFrameIconImage()) != null) {
                titleWidth += this.getHeight();
            }
        }
        int n = xOffset = (leftToRight = this.isLeftToRight()) ? iconWidth + 10 + titleWidth : width - 10 - iconWidth - titleWidth;
        if (leftToRight) {
            dw = width - this.buttonsWidth - xOffset - 10;
            dx = xOffset;
        } else {
            dw = xOffset - this.buttonsWidth - 10;
            dx = this.buttonsWidth + 10;
        }
        int dy = 3;
        if (!AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() && dw > 0) {
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            float dc1 = 50.0f;
            float dc2 = 5.0f;
            Color c1 = ColorHelper.brighter(backColor, dc1);
            Color c2 = null;
            while (dy + 5 < height) {
                c2 = ColorHelper.darker(backColor, dc2);
                dc2 += 5.0f;
                g.setColor(c1);
                g.drawLine(dx, dy, dx + dw, dy);
                g.setColor(c2);
                g.drawLine(dx, ++dy, dx + dw, dy);
                dy += 3;
            }
            g2D.setComposite(composite);
        }
        g.setColor(frameColor);
        g.drawLine(0, height - 1, width, height - 1);
    }

    public void paintText(Graphics g, int x, int y, String title) {
        x += this.paintIcon(g, x, y);
        if (this.isActive()) {
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowTitleForegroundColor();
            if (ColorHelper.getGrayValue(titleColor) > 164) {
                g.setColor(Color.black);
                JTattooUtilities.drawString(this.rootPane, g, title, x + 1, y + 1);
            }
            g.setColor(titleColor);
            JTattooUtilities.drawString(this.rootPane, g, title, x, y);
        } else {
            g.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, g, title, x, y);
        }
    }
}

