/*
 * Decompiled with CFR 0.152.
 */
package com.jtelegram.api.menu;

import com.jtelegram.api.TelegramBot;
import com.jtelegram.api.ex.TelegramException;
import com.jtelegram.api.inline.keyboard.InlineKeyboardButton;
import com.jtelegram.api.inline.keyboard.InlineKeyboardMarkup;
import com.jtelegram.api.inline.keyboard.InlineKeyboardRow;
import com.jtelegram.api.menu.MenuButton;
import com.jtelegram.api.menu.MenuRow;
import com.jtelegram.api.menu.MenuViewer;
import com.jtelegram.api.util.TextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public abstract class Menu {
    public static final InlineKeyboardMarkup KEYBOARD_MARKUP = InlineKeyboardMarkup.builder().keyboard(InlineKeyboardRow.builder().button(InlineKeyboardButton.builder().label("Placeholder").callbackData("Placeholder").build()).build()).build();
    public static final String DATA_SEPARATOR = "&";
    private UUID id;
    private List<MenuViewer> viewers = new LinkedList<MenuViewer>();
    private TelegramBot bot;

    protected Menu(TelegramBot bot) {
        this.id = UUID.randomUUID();
        this.bot = bot;
    }

    public abstract List<MenuRow> getRows();

    public abstract void handleException(TelegramException var1);

    public void update() {
        this.viewers.forEach(viewer -> viewer.sendMenu(this));
    }

    public void update(MenuViewer viewer) {
        viewer.sendMenu(this);
    }

    public void addViewer(MenuViewer viewer) {
        this.viewers.add(viewer);
        this.update(viewer);
    }

    public void addViewers(Collection<MenuViewer> viewers) {
        this.viewers.addAll(viewers);
        this.update();
    }

    public void migrateTo(Menu other) {
        other.addViewers(this.viewers);
        this.viewers.clear();
    }

    public TextBuilder getMenuMessage() {
        return null;
    }

    public InlineKeyboardMarkup toKeyboard() {
        List<MenuRow> rows = this.getRows();
        ArrayList<InlineKeyboardRow> inlineRows = new ArrayList<InlineKeyboardRow>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            MenuRow row = rows.get(i);
            InlineKeyboardRow.InlineKeyboardRowBuilder rowBuilder = InlineKeyboardRow.builder();
            for (int j = 0; j < row.getButtons().size(); ++j) {
                MenuButton button = row.getButtons().get(j);
                button.setMenu(this);
                rowBuilder.button(InlineKeyboardButton.builder().label(button.getLabel()).callbackData(this.id.toString() + DATA_SEPARATOR + i + DATA_SEPARATOR + j).build());
            }
            inlineRows.add(rowBuilder.build());
        }
        return InlineKeyboardMarkup.builder().inlineKeyboard(inlineRows).build();
    }

    public UUID getId() {
        return this.id;
    }

    public List<MenuViewer> getViewers() {
        return this.viewers;
    }

    public TelegramBot getBot() {
        return this.bot;
    }
}

