/*
 * Decompiled with CFR 0.152.
 */
package com.jtelegram.api.menu.viewer;

import com.jtelegram.api.menu.Menu;
import com.jtelegram.api.menu.MenuViewer;
import com.jtelegram.api.requests.framework.TelegramRequest;
import com.jtelegram.api.requests.message.edit.EditMessageReplyMarkup;
import com.jtelegram.api.requests.message.edit.EditTextMessage;
import com.jtelegram.api.requests.message.framework.ReplyMarkup;
import com.jtelegram.api.util.TextBuilder;

public class InlineMenuViewer
implements MenuViewer {
    private String inlineMessageId;

    public InlineMenuViewer(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @Override
    public void sendMenu(Menu menu) {
        TextBuilder tb = menu.getMenuMessage();
        if (tb == null) {
            menu.getBot().perform((TelegramRequest)EditMessageReplyMarkup.builder().inlineMessageId(this.inlineMessageId).replyMarkup((ReplyMarkup)menu.toKeyboard()).errorHandler(menu::handleException).build());
        } else {
            menu.getBot().perform((TelegramRequest)EditTextMessage.builder().inlineMessageId(this.inlineMessageId).replyMarkup((ReplyMarkup)menu.toKeyboard()).text(tb).errorHandler(menu::handleException).build());
        }
    }

    public static InlineMenuViewerBuilder builder() {
        return new InlineMenuViewerBuilder();
    }

    public String toString() {
        return "InlineMenuViewer(inlineMessageId=" + this.getInlineMessageId() + ")";
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public static class InlineMenuViewerBuilder {
        private String inlineMessageId;

        InlineMenuViewerBuilder() {
        }

        public InlineMenuViewerBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        public InlineMenuViewer build() {
            return new InlineMenuViewer(this.inlineMessageId);
        }

        public String toString() {
            return "InlineMenuViewer.InlineMenuViewerBuilder(inlineMessageId=" + this.inlineMessageId + ")";
        }
    }
}

