/*
 * Decompiled with CFR 0.152.
 */
package com.jtelegram.api.menu.viewer;

import com.jtelegram.api.chat.id.ChatId;
import com.jtelegram.api.menu.Menu;
import com.jtelegram.api.menu.MenuViewer;
import com.jtelegram.api.requests.framework.TelegramRequest;
import com.jtelegram.api.requests.message.edit.EditMessageReplyMarkup;
import com.jtelegram.api.requests.message.edit.EditTextMessage;
import com.jtelegram.api.requests.message.framework.ReplyMarkup;
import com.jtelegram.api.util.TextBuilder;

public class RegularMenuViewer
implements MenuViewer {
    private ChatId chatId;
    private int messageId;

    public RegularMenuViewer(ChatId chatId, int messageId) {
        this.chatId = chatId;
        this.messageId = messageId;
    }

    @Override
    public void sendMenu(Menu menu) {
        TextBuilder tb = menu.getMenuMessage();
        if (tb == null) {
            menu.getBot().perform((TelegramRequest)EditMessageReplyMarkup.builder().chatId(this.chatId).messageId(this.messageId).replyMarkup((ReplyMarkup)menu.toKeyboard()).errorHandler(menu::handleException).build());
        } else {
            menu.getBot().perform((TelegramRequest)EditTextMessage.builder().chatId(this.chatId).messageId(this.messageId).replyMarkup((ReplyMarkup)menu.toKeyboard()).text(tb).errorHandler(menu::handleException).build());
        }
    }

    public static RegularMenuViewerBuilder builder() {
        return new RegularMenuViewerBuilder();
    }

    public String toString() {
        return "RegularMenuViewer(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ")";
    }

    public ChatId getChatId() {
        return this.chatId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public static class RegularMenuViewerBuilder {
        private ChatId chatId;
        private int messageId;

        RegularMenuViewerBuilder() {
        }

        public RegularMenuViewerBuilder chatId(ChatId chatId) {
            this.chatId = chatId;
            return this;
        }

        public RegularMenuViewerBuilder messageId(int messageId) {
            this.messageId = messageId;
            return this;
        }

        public RegularMenuViewer build() {
            return new RegularMenuViewer(this.chatId, this.messageId);
        }

        public String toString() {
            return "RegularMenuViewer.RegularMenuViewerBuilder(chatId=" + this.chatId + ", messageId=" + this.messageId + ")";
        }
    }
}

