/*
 * Decompiled with CFR 0.152.
 */
package com.jthinking.common.util.ip;

import com.jthinking.common.util.ip.IPInfo;
import com.jthinking.common.util.ip.IpUtils;
import com.jthinking.common.util.ip.parser.IpParser;
import java.math.BigInteger;
import java.util.Objects;

public class CustomIPInfo
extends IPInfo {
    private final BigInteger ipInteger;
    private final String ip;

    public CustomIPInfo(String ip, String country, String province, String address, String isp, boolean overseas, double lat, double lng) {
        super(country, province, address, isp, overseas, lat, lng);
        this.ipInteger = ip.contains(":") ? IpParser.getIPv6BigInteger(ip) : BigInteger.valueOf(IpUtils.ip2long(ip));
        this.ip = ip;
    }

    public BigInteger getIpInteger() {
        return this.ipInteger;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomIPInfo that = (CustomIPInfo)o;
        return this.ipInteger.equals(that.ipInteger);
    }

    public int hashCode() {
        return Objects.hash(this.ipInteger);
    }

    @Override
    public String toString() {
        return "CustomIPInfo{ipInteger=" + this.ipInteger + ", ip='" + this.ip + '\'' + '}' + super.toString();
    }
}

