/*
 * Decompiled with CFR 0.152.
 */
package com.jthinking.common.util.ip;

import com.jthinking.common.util.ip.IPInfoUtils;
import com.jthinking.common.util.ip.IPv6Info;
import com.jthinking.common.util.ip.ZipUtils;
import com.jthinking.common.util.ip.parser.IpParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class IPv6InfoUtils {
    private static List<IPv6Info> ipInfoList;
    private static final IPv6Info UNKNOWN;
    private static final Map<String, String> COUNTRY_GEO;
    private static final Map<String, String> PROVINCE_GEO;
    private static final String provinces = "\u6cb3\u5317,\u5c71\u897f,\u8fbd\u5b81,\u5409\u6797,\u9ed1\u9f99,\u6c5f\u82cf,\u6d59\u6c5f,\u5b89\u5fbd,\u798f\u5efa,\u6c5f\u897f,\u5c71\u4e1c,\u6cb3\u5357,\u6e56\u5317,\u6e56\u5357,\u5e7f\u4e1c,\u6d77\u5357,\u56db\u5ddd,\u8d35\u5dde,\u4e91\u5357,\u9655\u897f,\u7518\u8083,\u9752\u6d77,\u53f0\u6e7e\u897f\u85cf,\u5e7f\u897f,\u5185\u8499,\u5b81\u590f,\u65b0\u7586,\u9999\u6e2f,\u6fb3\u95e8\u5317\u4eac,\u4e0a\u6d77,\u5929\u6d25,\u91cd\u5e86,\u4e2d\u56fd";

    public static synchronized void init() {
        String ipInfoName;
        File zipFile;
        if (ipInfoList != null && !ipInfoList.isEmpty()) {
            return;
        }
        String zipName = "ipv6.zip";
        String userDir = System.getProperty("user.dir");
        File tmp = new File(userDir + "/tmp");
        if (!tmp.exists()) {
            tmp.mkdir();
        }
        if ((zipFile = new File(tmp.getAbsolutePath() + "/" + zipName)).exists()) {
            zipFile.delete();
        }
        zipFile.setWritable(true);
        zipFile.setReadable(true);
        URL resource = IPv6InfoUtils.class.getClassLoader().getResource(zipName);
        if (resource == null) {
            throw new RuntimeException(zipName + " zip file not found");
        }
        try (InputStream in = resource.openStream();
             FileOutputStream out = new FileOutputStream(zipFile);){
            int len;
            byte[] temp = new byte[1024];
            while ((len = in.read(temp, 0, temp.length)) != -1) {
                out.write(temp, 0, len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            ipInfoName = ZipUtils.unZipReturnDir(zipFile, tmp.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File ipInfoFile = new File(tmp.getAbsolutePath() + "/" + ipInfoName);
        try {
            FileInputStream inputStream = new FileInputStream(ipInfoFile);
            ipInfoList = IPv6InfoUtils.importTxt(inputStream);
            if (ipInfoList == null) {
                ipInfoList = Collections.emptyList();
            }
            ipInfoList.sort(Comparator.comparing(IPv6Info::getStart));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        ipInfoFile.deleteOnExit();
        zipFile.deleteOnExit();
    }

    public static IPv6Info getIPv6Info(BigInteger ipv6) {
        int index;
        if (ipv6 == null) {
            return UNKNOWN;
        }
        if (ipInfoList == null) {
            IPv6InfoUtils.init();
        }
        if ((index = Collections.binarySearch(ipInfoList, new IPv6Info(ipv6, ipv6))) < 0 || index >= ipInfoList.size()) {
            return UNKNOWN;
        }
        return ipInfoList.get(index);
    }

    public static IPv6Info getIPv6Info(byte[] ipv6Bytes) {
        return IPv6InfoUtils.getIPv6Info(new BigInteger(ipv6Bytes));
    }

    public static IPv6Info getIpInfoByIPv6BytesHex(String ipv6BytesHex) {
        StringBuilder builder = new StringBuilder(ipv6BytesHex);
        int count = 32 - ipv6BytesHex.length();
        for (int i = 0; i < count; ++i) {
            builder.append('0');
        }
        byte[] bytes = IpParser.hexStringToByte(builder.toString());
        return IPv6InfoUtils.getIPv6Info(bytes);
    }

    public static BigInteger getBigIntegerIPv6BytesHex(String ipv6BytesHex) {
        StringBuilder builder = new StringBuilder(ipv6BytesHex);
        int count = 32 - ipv6BytesHex.length();
        for (int i = 0; i < count; ++i) {
            builder.append('0');
        }
        return new BigInteger(builder.toString(), 16);
    }

    public static IPv6Info getIPv6Info(String ipv6) {
        return IPv6InfoUtils.getIPv6Info(IpParser.ipv6ToBytes(IpParser.getFullIPv6(ipv6)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<IPv6Info> importTxt(InputStream file) {
        ArrayList<IPv6Info> ipInfoList = new ArrayList<IPv6Info>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                IPv6Info ipInfo = IPv6InfoUtils.convertToIPv6Info(line);
                if (ipInfo == null) continue;
                ipInfoList.add(ipInfo);
            }
            ArrayList<IPv6Info> arrayList = ipInfoList;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IPv6Info convertToIPv6Info(String row) {
        String address;
        boolean overseas;
        String province;
        String country;
        BigInteger endLong;
        BigInteger startLong;
        if ("".equals(row.trim())) {
            return null;
        }
        String[] split = row.split("\\s+", 4);
        if (split.length != 4) {
            return null;
        }
        String startIp = split[0].trim();
        try {
            startLong = IPv6InfoUtils.getBigIntegerIPv6BytesHex(startIp);
        }
        catch (Exception e) {
            return null;
        }
        String endIp = split[1].trim();
        try {
            endLong = IPv6InfoUtils.getBigIntegerIPv6BytesHex(endIp);
        }
        catch (Exception e) {
            return null;
        }
        String region = split[2].replace("ZX", "").trim();
        String isp = split[3].replace("ZX", "").trim();
        String geo = "0,0";
        if (region.startsWith("\u4e2d\u56fd")) {
            String g;
            String tmp;
            country = "\u4e2d\u56fd";
            province = "\u4e2d\u56fd";
            overseas = false;
            address = region;
            if (region.length() > 2 && provinces.contains(tmp = region.substring(2, 4)) && (g = PROVINCE_GEO.get(province = IPv6InfoUtils.formatProvince(tmp))) != null) {
                geo = g;
            }
        } else if (region.contains("\u5c40\u57df\u7f51") || isp.contains("\u5c40\u57df\u7f51")) {
            country = "\u5c40\u57df\u7f51";
            overseas = false;
            province = "";
            address = region;
        } else if (region.contains("\u4fdd\u7559\u5730\u5740") || isp.contains("\u4fdd\u7559\u5730\u5740")) {
            country = "\u4fdd\u7559\u5730\u5740";
            overseas = false;
            province = "";
            address = region;
        } else if (region.contains("\u7279\u6b8a\u5730\u5740") || isp.contains("\u7279\u6b8a\u5730\u5740")) {
            country = "\u4fdd\u7559\u5730\u5740";
            overseas = false;
            province = "";
            address = region;
        } else if (region.contains("\u672c\u673a\u5730\u5740") || isp.contains("\u672c\u673a\u5730\u5740")) {
            country = "\u672c\u673a\u5730\u5740";
            overseas = false;
            province = "";
            address = region;
        } else {
            country = region;
            overseas = true;
            province = "";
            address = region;
            String g = COUNTRY_GEO.get(country);
            if (g != null) {
                geo = g;
            }
        }
        String[] latAndLng = geo.split(",");
        double lat = Double.parseDouble(latAndLng[0]);
        double lng = Double.parseDouble(latAndLng[1]);
        return new IPv6Info(startLong, endLong, country, province, address, isp, overseas, lat, lng);
    }

    private static String formatProvince(String originalData) {
        String result;
        switch (originalData) {
            case "\u5185\u8499": {
                result = "\u5185\u8499\u53e4";
                break;
            }
            case "\u9ed1\u9f99": {
                result = "\u9ed1\u9f99\u6c5f";
                break;
            }
            default: {
                result = originalData;
            }
        }
        return result;
    }

    static {
        UNKNOWN = new IPv6Info(BigInteger.ZERO, BigInteger.ZERO, "\u672a\u77e5", "\u672a\u77e5", "\u672a\u77e5", "\u672a\u77e5", false, 0.0, 0.0);
        COUNTRY_GEO = IPInfoUtils.COUNTRY_GEO;
        PROVINCE_GEO = IPInfoUtils.PROVINCE_GEO;
    }
}

