/*
 * Decompiled with CFR 0.152.
 */
package com.jthinking.common.util.ip;

import com.jthinking.common.util.ip.parser.IpParser;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class IpUtils {
    private static List<PrintIP.StartAndEnd> lanIpList = new ArrayList<PrintIP.StartAndEnd>();
    private static final Pattern IP_V4_PATTERN = Pattern.compile("([0-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");

    IpUtils() {
    }

    public static boolean isLan(String ip) {
        if (ip == null) {
            return false;
        }
        if (ip.contains(":")) {
            return false;
        }
        for (PrintIP.StartAndEnd se : lanIpList) {
            long ipLong = IpUtils.ip2long(ip);
            if (!IpUtils.isInRange(se.getStart(), se.getEnd(), ipLong)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPort(String port) {
        try {
            int p = Integer.parseInt(port);
            return IpUtils.isValidPort(p);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static boolean isPortRange(String portRange) {
        if (!portRange.contains("-")) {
            return false;
        }
        String[] startAndEnd = portRange.split("-");
        if (startAndEnd.length != 2) {
            return false;
        }
        int startPort = Integer.parseInt(startAndEnd[0]);
        int endPort = Integer.parseInt(startAndEnd[1]);
        return IpUtils.isValidPort(startPort) && IpUtils.isValidPort(endPort) && startPort <= endPort;
    }

    public static boolean portInRange(String portsStr, String portStr) {
        int port = Integer.parseInt(portStr);
        if (portsStr.contains("-")) {
            String[] startAndEnd = portsStr.split("-");
            int startPort = Integer.parseInt(startAndEnd[0]);
            int endPort = Integer.parseInt(startAndEnd[1]);
            if (port == startPort || port == endPort) {
                return true;
            }
            return port > startPort && port < endPort;
        }
        if (portsStr.contains(",")) {
            String[] ports;
            for (String p : ports = portsStr.split(",")) {
                if (port != Integer.parseInt(p)) continue;
                return true;
            }
            return false;
        }
        int ports = Integer.parseInt(portsStr);
        return port == ports;
    }

    public static boolean isInRange(long startIp, long endIp, long ip) {
        if (ip == startIp || ip == endIp) {
            return true;
        }
        return ip > startIp && ip < endIp;
    }

    public static boolean isIp(String str) {
        if (str == null) {
            return false;
        }
        return IP_V4_PATTERN.matcher(str).matches();
    }

    public static boolean isSubnetMaskFormat(String ipRange) {
        return ipRange.matches("([0-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}/([0-9]|([1-2][0-9])|(3[0-2]))");
    }

    public static boolean isStartEndFormat(String ipRange) {
        return ipRange.matches("([0-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}\\-([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");
    }

    public static boolean isSimpleStartEndFormat(String ipRange) {
        return ipRange.matches("([0-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}\\-\\d+");
    }

    public static boolean isIpRange(String str) {
        if (str == null) {
            return false;
        }
        if (IpUtils.isSubnetMaskFormat(str)) {
            return true;
        }
        if (IpUtils.isStartEndFormat(str)) {
            return true;
        }
        return IpUtils.isSimpleStartEndFormat(str);
    }

    public static boolean isIpOrIpRange(String str) {
        if (IpUtils.isIpRange(str)) {
            return true;
        }
        return IpUtils.isIp(str);
    }

    public static String getNetMask(String mask) {
        int i;
        int inetMask = Integer.parseInt(mask);
        if (inetMask > 32) {
            return null;
        }
        int num1 = inetMask / 8;
        int num2 = inetMask % 8;
        int[] array = new int[4];
        for (i = 0; i < num1; ++i) {
            array[i] = 255;
        }
        for (i = num1; i < 4; ++i) {
            array[i] = 0;
        }
        i = 0;
        while (i < num2) {
            int n = num1;
            array[n] = (int)((double)array[n] + Math.pow(2.0, 8 - num2));
            --num2;
        }
        String netMask = array[0] + "." + array[1] + "." + array[2] + "." + array[3];
        return netMask;
    }

    public static String getLowAddr(String ipinfo, String netMask) {
        int i;
        String lowAddr = "";
        int[] ipArray = new int[4];
        int[] netMaskArray = new int[4];
        if (4 != ipinfo.split("\\.").length || "" == netMask) {
            return null;
        }
        for (i = 0; i < 4; ++i) {
            try {
                ipArray[i] = Integer.parseInt(ipinfo.split("\\.")[i]);
            }
            catch (NumberFormatException e) {
                String ip = ipinfo.replaceAll("\n", "");
                ipArray[i] = Integer.parseInt(ip.split("\\.")[i]);
            }
            netMaskArray[i] = Integer.parseInt(netMask.split("\\.")[i]);
            if (ipArray[i] > 255 || ipArray[i] < 0 || netMaskArray[i] > 255 || netMaskArray[i] < 0) {
                return null;
            }
            ipArray[i] = ipArray[i] & netMaskArray[i];
        }
        for (i = 0; i < 4; ++i) {
            if (i == 3) {
                ipArray[i] = ipArray[i] + 1;
            }
            lowAddr = "" == lowAddr ? lowAddr + ipArray[i] : lowAddr + "." + ipArray[i];
        }
        return lowAddr;
    }

    public static String getHighAddr(String ipinfo, String netMask) {
        String lowAddr = IpUtils.getLowAddr(ipinfo, netMask);
        int hostNumber = IpUtils.getHostNumber(netMask);
        if ("" == lowAddr || hostNumber == 0) {
            return null;
        }
        int[] lowAddrArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            lowAddrArray[i] = Integer.parseInt(lowAddr.split("\\.")[i]);
            if (i != 3) continue;
            lowAddrArray[i] = lowAddrArray[i] - 1;
        }
        lowAddrArray[3] = lowAddrArray[3] + (hostNumber - 1);
        if (lowAddrArray[3] > 255) {
            int k = lowAddrArray[3] / 256;
            lowAddrArray[3] = lowAddrArray[3] % 256;
            lowAddrArray[2] = lowAddrArray[2] + k;
        }
        if (lowAddrArray[2] > 255) {
            int j = lowAddrArray[2] / 256;
            lowAddrArray[2] = lowAddrArray[2] % 256;
            lowAddrArray[1] = lowAddrArray[1] + j;
            if (lowAddrArray[1] > 255) {
                int k = lowAddrArray[1] / 256;
                lowAddrArray[1] = lowAddrArray[1] % 256;
                lowAddrArray[0] = lowAddrArray[0] + k;
            }
        }
        String highAddr = "";
        for (int i = 0; i < 4; ++i) {
            if (i == 3) {
                lowAddrArray[i] = lowAddrArray[i] - 1;
            }
            highAddr = "" == highAddr ? lowAddrArray[i] + "" : highAddr + "." + lowAddrArray[i];
        }
        return highAddr;
    }

    public static long ip2long(String ip) {
        String[] ips = ip.split("[.]");
        long num = 0x1000000L * Long.parseLong(ips[0]) + 65536L * Long.parseLong(ips[1]) + 256L * Long.parseLong(ips[2]) + Long.parseLong(ips[3]);
        return num;
    }

    public static BigInteger ip2BigInteger(String ip) {
        if (ip.contains(":")) {
            return IpParser.getIPv6BigInteger(ip);
        }
        return BigInteger.valueOf(IpUtils.ip2long(ip));
    }

    public static int getHostNumber(String netMask) {
        int hostNumber = 0;
        int[] netMaskArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            netMaskArray[i] = Integer.parseInt(netMask.split("\\.")[i]);
            if (netMaskArray[i] >= 255) continue;
            hostNumber = (int)(Math.pow(256.0, 3 - i) * (double)(256 - netMaskArray[i]));
            break;
        }
        return hostNumber;
    }

    public static long getIpNum(String startIp, String endIp) {
        long start = IpUtils.ip2long(startIp);
        long end = IpUtils.ip2long(endIp);
        return Math.abs(end - start) + 1L;
    }

    public static String ipRangeToSubnet(String startIp, String endIp) {
        int maskBitNum = IpUtils.subIpNumToMaskBitNum(IpUtils.getIpNum(startIp, endIp));
        return startIp + "/" + maskBitNum;
    }

    public static String ipRangeToSubnet(String startIpAndEndIp) {
        startIpAndEndIp = IpUtils.formatStartIpAndEndIp(startIpAndEndIp);
        String[] startAndEnd = startIpAndEndIp.split("\\-");
        return IpUtils.ipRangeToSubnet(startAndEnd[0], startAndEnd[1]);
    }

    public static String formatStartIpAndEndIp(String startIpAndEndIp) {
        String[] endIp = new String[4];
        String[] split = startIpAndEndIp.split("-");
        String start = split[0];
        String end = split[1];
        String[] startSplit = start.split("\\.");
        String[] endSplit = end.split("\\.");
        int i = endSplit.length;
        for (int j = endIp.length; i > 0 && j > 0; --i, --j) {
            endIp[j - 1] = endSplit[i - 1];
        }
        for (i = 0; i < startSplit.length - endSplit.length; ++i) {
            endIp[i] = startSplit[i];
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Arrays.stream(startSplit).collect(Collectors.joining(".")));
        builder.append("-");
        builder.append(Arrays.stream(endIp).collect(Collectors.joining(".")));
        return builder.toString();
    }

    public static String ipToBinaryString(String ip) {
        return Arrays.stream(ip.split("\\.")).map(i -> String.format("%08d", Integer.valueOf(Integer.toBinaryString(Integer.valueOf(i))))).collect(Collectors.joining("."));
    }

    public static int subIpNumToHostBitNum(long num) {
        return (int)(Math.log(num) / Math.log(2.0));
    }

    public static int subIpNumToMaskBitNum(long num) {
        return 32 - IpUtils.subIpNumToHostBitNum(num);
    }

    static {
        List<String> ipRangeList = Arrays.asList("10.0.0.0-10.255.255.255", "172.16.0.0-172.31.255.255", "192.168.0.0-192.168.255.255");
        for (String ipRange : ipRangeList) {
            String[] split = ipRange.split("-");
            lanIpList.add(new PrintIP.StartAndEnd(IpUtils.ip2long(split[0]), IpUtils.ip2long(split[1])));
        }
    }

    public static class PrintIP {
        public static long getIP(InetAddress ip) {
            byte[] b = ip.getAddress();
            long l = (long)(b[0] << 24) & 0xFF000000L | (long)(b[1] << 16) & 0xFF0000L | (long)(b[2] << 8) & 0xFF00L | (long)(b[3] << 0) & 0xFFL;
            return l;
        }

        public static InetAddress toIP(long ip) throws UnknownHostException {
            byte[] b = new byte[4];
            int i = (int)ip;
            b[0] = (byte)(i >> 24 & 0xFF);
            b[1] = (byte)(i >> 16 & 0xFF);
            b[2] = (byte)(i >> 8 & 0xFF);
            b[3] = (byte)(i >> 0 & 0xFF);
            return InetAddress.getByAddress(b);
        }

        public static Optional<List<String>> listIpFromStartToEnd(String startIp, String endIp) {
            try {
                ArrayList<String> list = new ArrayList<String>();
                long ip1 = PrintIP.getIP(InetAddress.getByName(startIp));
                long ip2 = PrintIP.getIP(InetAddress.getByName(endIp));
                for (long ip = ip1; ip <= ip2; ++ip) {
                    list.add(PrintIP.toIP(ip).getHostAddress());
                }
                return Optional.ofNullable(list);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }

        public static class StartAndEnd {
            private long start;
            private long end;

            public StartAndEnd(long start, long end) {
                this.start = start;
                this.end = end;
            }

            public long getStart() {
                return this.start;
            }

            public void setStart(long start) {
                this.start = start;
            }

            public long getEnd() {
                return this.end;
            }

            public void setEnd(long end) {
                this.end = end;
            }
        }
    }
}

