/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.org.objectweb.asm.optimizer;

import com.jtransc.org.objectweb.asm.AnnotationVisitor;
import com.jtransc.org.objectweb.asm.Handle;
import com.jtransc.org.objectweb.asm.Label;
import com.jtransc.org.objectweb.asm.MethodVisitor;
import com.jtransc.org.objectweb.asm.TypePath;
import com.jtransc.org.objectweb.asm.optimizer.AnnotationConstantsCollector;
import com.jtransc.org.objectweb.asm.optimizer.ConstantPool;

public class MethodConstantsCollector
extends MethodVisitor {
    private final ConstantPool cp;

    public MethodConstantsCollector(MethodVisitor mv, ConstantPool cp) {
        super(327680, mv);
        this.cp = cp;
    }

    @Override
    public void visitParameter(String name, int access) {
        this.cp.newUTF8("MethodParameters");
        if (name != null) {
            this.cp.newUTF8(name);
        }
        this.mv.visitParameter(name, access);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.cp.newUTF8("AnnotationDefault");
        return new AnnotationConstantsCollector(this.mv.visitAnnotationDefault(), this.cp);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitAnnotation(desc, visible), this.cp);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleTypeAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleTypeAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitAnnotation(desc, visible), this.cp);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleParameterAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleParameterAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitParameterAnnotation(parameter, desc, visible), this.cp);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.cp.newClass(type);
        this.mv.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.cp.newField(owner, name, desc);
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.cp.newMethod(owner, name, desc, itf);
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.cp.newInvokeDynamic(name, desc, bsm, bsmArgs);
        this.mv.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.cp.newConst(cst);
        this.mv.visitLdcInsn(cst);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.cp.newClass(desc);
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleTypeAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleTypeAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitInsnAnnotation(typeRef, typePath, desc, visible), this.cp);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            this.cp.newClass(type);
        }
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleTypeAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleTypeAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitTryCatchAnnotation(typeRef, typePath, desc, visible), this.cp);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (signature != null) {
            this.cp.newUTF8("LocalVariableTypeTable");
            this.cp.newUTF8(name);
            this.cp.newUTF8(signature);
        }
        this.cp.newUTF8("LocalVariableTable");
        this.cp.newUTF8(name);
        this.cp.newUTF8(desc);
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleTypeAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleTypeAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible), this.cp);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.cp.newUTF8("LineNumberTable");
        this.mv.visitLineNumber(line, start);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.cp.newUTF8("Code");
        this.mv.visitMaxs(maxStack, maxLocals);
    }
}

