/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.ast;

import com.jtransc.ast.AstArgument;
import com.jtransc.ast.AstBinop;
import com.jtransc.ast.AstElement;
import com.jtransc.ast.AstFieldRef;
import com.jtransc.ast.AstLocal;
import com.jtransc.ast.AstMethodRef;
import com.jtransc.ast.AstStm;
import com.jtransc.ast.AstType;
import com.jtransc.ast.AstTypes;
import com.jtransc.ast.AstUnop;
import com.jtransc.ast.Ast_typeKt;
import com.jtransc.ast.Cloneable;
import com.jtransc.ast.FqName;
import com.jtransc.ast.LocalRef;
import com.jtransc.error.ErrorsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b#\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:!#$%&'()*+,-./0123456789:;<=>?@ABCB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\u0011\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u001dH\u0086\u0004J\u0011\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006D"}, d2={"Lcom/jtransc/ast/AstExpr;", "Lcom/jtransc/ast/AstElement;", "Lcom/jtransc/ast/Cloneable;", "()V", "box", "Lcom/jtransc/ast/AstExpr$Box;", "getBox", "()Lcom/jtransc/ast/AstExpr$Box;", "setBox", "(Lcom/jtransc/ast/AstExpr$Box;)V", "stm", "Lcom/jtransc/ast/AstStm;", "getStm", "()Lcom/jtransc/ast/AstStm;", "setStm", "(Lcom/jtransc/ast/AstStm;)V", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "and", "Lcom/jtransc/ast/AstExpr$BINOP;", "that", "band", "clone", "ge", "gt", "instanceof", "Lcom/jtransc/ast/AstExpr$INSTANCE_OF;", "Lcom/jtransc/ast/AstType$REF;", "le", "lt", "replaceWith", "", "expr", "ARRAY_ACCESS", "ARRAY_LENGTH", "BINOP", "Box", "CALL_BASE", "CALL_BASE_OBJECT", "CALL_INSTANCE", "CALL_STATIC", "CALL_SUPER", "CAST", "CAUGHT_EXCEPTION", "FIELD_INSTANCE_ACCESS", "FIELD_STATIC_ACCESS", "INSTANCE_OF", "INTARRAY_LITERAL", "INVOKE_DYNAMIC_METHOD", "ImmutableRef", "LITERAL", "LITERAL_REFNAME", "LOCAL", "LOCAL_BASE", "LValueExpr", "LiteralExpr", "LocalExpr", "NEW", "NEW_ARRAY", "NEW_WITH_CONSTRUCTOR", "PARAM", "STRINGARRAY_LITERAL", "TERNARY", "THIS", "TYPED_LOCAL", "UNOP", "jtransc-core_main"})
public abstract class AstExpr
implements AstElement,
Cloneable<AstExpr> {
    @NotNull
    private Box box = new Box(this);
    @Nullable
    private AstStm stm;

    @NotNull
    public final Box getBox() {
        return this.box;
    }

    public final void setBox(@NotNull Box box) {
        Intrinsics.checkParameterIsNotNull((Object)box, (String)"<set-?>");
        this.box = box;
    }

    @Nullable
    public final AstStm getStm() {
        return this.stm;
    }

    public final void setStm(@Nullable AstStm astStm) {
        this.stm = astStm;
    }

    public final void replaceWith(@NotNull AstExpr expr) {
        Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
        this.box.replaceWith(expr);
    }

    public final void replaceWith(@NotNull Box expr) {
        Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
        this.box.replaceWith(expr);
    }

    @NotNull
    public abstract AstType getType();

    @Override
    @NotNull
    public AstExpr clone() {
        Void void_ = ErrorsKt.noImpl((String)("AstExpr.clone: " + this));
        throw null;
    }

    @NotNull
    public final BINOP ge(@NotNull AstExpr that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return new BINOP(AstType.BOOL.INSTANCE, this, AstBinop.GE, that);
    }

    @NotNull
    public final BINOP gt(@NotNull AstExpr that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return new BINOP(AstType.BOOL.INSTANCE, this, AstBinop.GT, that);
    }

    @NotNull
    public final BINOP lt(@NotNull AstExpr that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return new BINOP(AstType.BOOL.INSTANCE, this, AstBinop.LT, that);
    }

    @NotNull
    public final BINOP le(@NotNull AstExpr that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return new BINOP(AstType.BOOL.INSTANCE, this, AstBinop.LE, that);
    }

    @NotNull
    public final BINOP band(@NotNull AstExpr that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return new BINOP(AstType.BOOL.INSTANCE, this, AstBinop.BAND, that);
    }

    @NotNull
    public final BINOP and(@NotNull AstExpr that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return new BINOP(this.getType(), this, AstBinop.AND, that);
    }

    @NotNull
    public final INSTANCE_OF instanceof(@NotNull AstType.REF that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return new INSTANCE_OF(this, that);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0012"}, d2={"Lcom/jtransc/ast/AstExpr$Box;", "", "_value", "Lcom/jtransc/ast/AstExpr;", "(Lcom/jtransc/ast/AstExpr;)V", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "value", "getValue", "()Lcom/jtransc/ast/AstExpr;", "setValue", "replaceWith", "", "expr", "toString", "", "jtransc-core_main"})
    public static final class Box {
        @NotNull
        private AstExpr value;

        @NotNull
        public final AstExpr getValue() {
            return this.value;
        }

        public final void setValue(@NotNull AstExpr value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (this.value != value) {
                this.value.setBox(new Box(this.value));
                this.value = value;
                this.value.setBox(this);
            }
        }

        public final void replaceWith(@NotNull AstExpr expr) {
            Box box;
            Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
            Box $receiver = box = this;
            $receiver.setValue(expr);
        }

        public final void replaceWith(@NotNull Box expr) {
            Box box;
            Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
            Box $receiver = box = this;
            $receiver.setValue(expr.value);
        }

        @NotNull
        public final AstType getType() {
            return this.value.getType();
        }

        @NotNull
        public String toString() {
            return "BOX(" + this.value + ")";
        }

        public Box(@NotNull AstExpr _value) {
            Intrinsics.checkParameterIsNotNull((Object)_value, (String)"_value");
            this.value = _value;
            _value.setBox(this);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstExpr$ImmutableRef;", "Lcom/jtransc/ast/AstExpr;", "()V", "jtransc-core_main"})
    public static abstract class ImmutableRef
    extends AstExpr {
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstExpr$LValueExpr;", "Lcom/jtransc/ast/AstExpr;", "()V", "jtransc-core_main"})
    public static abstract class LValueExpr
    extends AstExpr {
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jtransc/ast/AstExpr$LocalExpr;", "Lcom/jtransc/ast/AstExpr$LValueExpr;", "Lcom/jtransc/ast/LocalRef;", "()V", "name", "", "getName", "()Ljava/lang/String;", "jtransc-core_main"})
    public static abstract class LocalExpr
    extends LValueExpr
    implements LocalRef {
        @Override
        @NotNull
        public abstract String getName();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0000H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/jtransc/ast/AstExpr$THIS;", "Lcom/jtransc/ast/AstExpr$LocalExpr;", "ref", "Lcom/jtransc/ast/FqName;", "(Lcom/jtransc/ast/FqName;)V", "name", "", "getName", "()Ljava/lang/String;", "getRef", "()Lcom/jtransc/ast/FqName;", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "clone", "jtransc-core_main"})
    public static final class THIS
    extends LocalExpr {
        @NotNull
        private final AstType type;
        @NotNull
        private final FqName ref;

        @Override
        @NotNull
        public String getName() {
            return "this";
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public THIS clone() {
            return new THIS(this.ref);
        }

        @NotNull
        public final FqName getRef() {
            return this.ref;
        }

        public THIS(@NotNull FqName ref) {
            Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
            this.ref = ref;
            this.type = new AstType.REF(this.ref);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/jtransc/ast/AstExpr$LOCAL_BASE;", "Lcom/jtransc/ast/AstExpr$LocalExpr;", "local", "Lcom/jtransc/ast/AstLocal;", "type", "Lcom/jtransc/ast/AstType;", "(Lcom/jtransc/ast/AstLocal;Lcom/jtransc/ast/AstType;)V", "getLocal", "()Lcom/jtransc/ast/AstLocal;", "name", "", "getName", "()Ljava/lang/String;", "getType", "()Lcom/jtransc/ast/AstType;", "clone", "Lcom/jtransc/ast/AstExpr$LOCAL;", "toString", "jtransc-core_main"})
    public static abstract class LOCAL_BASE
    extends LocalExpr {
        @NotNull
        private final AstLocal local;
        @NotNull
        private final AstType type;

        @Override
        @NotNull
        public String getName() {
            return this.local.getName();
        }

        @Override
        @NotNull
        public LOCAL clone() {
            return new LOCAL(this.local);
        }

        @NotNull
        public String toString() {
            return Intrinsics.areEqual((Object)this.local.getType(), (Object)this.getType()) ? "LOCAL(" + this.local + ")" : "LOCAL(" + this.local + " as " + this.getType() + ")";
        }

        @NotNull
        public final AstLocal getLocal() {
            return this.local;
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        public LOCAL_BASE(@NotNull AstLocal local, @NotNull AstType type2) {
            Intrinsics.checkParameterIsNotNull((Object)local, (String)"local");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            this.local = local;
            this.type = type2;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jtransc/ast/AstExpr$TYPED_LOCAL;", "Lcom/jtransc/ast/AstExpr$LOCAL_BASE;", "local", "Lcom/jtransc/ast/AstLocal;", "type", "Lcom/jtransc/ast/AstType;", "(Lcom/jtransc/ast/AstLocal;Lcom/jtransc/ast/AstType;)V", "jtransc-core_main"})
    public static final class TYPED_LOCAL
    extends LOCAL_BASE {
        public TYPED_LOCAL(@NotNull AstLocal local, @NotNull AstType type2) {
            Intrinsics.checkParameterIsNotNull((Object)local, (String)"local");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            super(local, type2);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jtransc/ast/AstExpr$LOCAL;", "Lcom/jtransc/ast/AstExpr$LOCAL_BASE;", "local", "Lcom/jtransc/ast/AstLocal;", "(Lcom/jtransc/ast/AstLocal;)V", "jtransc-core_main"})
    public static final class LOCAL
    extends LOCAL_BASE {
        public LOCAL(@NotNull AstLocal local) {
            Intrinsics.checkParameterIsNotNull((Object)local, (String)"local");
            super(local, local.getType());
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0000H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/jtransc/ast/AstExpr$PARAM;", "Lcom/jtransc/ast/AstExpr$LocalExpr;", "argument", "Lcom/jtransc/ast/AstArgument;", "(Lcom/jtransc/ast/AstArgument;)V", "getArgument", "()Lcom/jtransc/ast/AstArgument;", "name", "", "getName", "()Ljava/lang/String;", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "clone", "jtransc-core_main"})
    public static final class PARAM
    extends LocalExpr {
        @NotNull
        private final AstType type;
        @NotNull
        private final AstArgument argument;

        @Override
        @NotNull
        public String getName() {
            return this.argument.getName();
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public PARAM clone() {
            return new PARAM(this.argument);
        }

        @NotNull
        public final AstArgument getArgument() {
            return this.argument;
        }

        public PARAM(@NotNull AstArgument argument) {
            Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
            this.argument = argument;
            this.type = this.argument.getType();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jtransc/ast/AstExpr$LiteralExpr;", "Lcom/jtransc/ast/AstExpr;", "()V", "value", "", "getValue", "()Ljava/lang/Object;", "jtransc-core_main"})
    public static abstract class LiteralExpr
    extends AstExpr {
        @Nullable
        public abstract Object getValue();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jtransc/ast/AstExpr$LITERAL;", "Lcom/jtransc/ast/AstExpr$LiteralExpr;", "value", "", "dummy", "", "(Ljava/lang/Object;Z)V", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "getValue", "()Ljava/lang/Object;", "valueAsInt", "", "getValueAsInt", "()I", "valueAsLong", "", "getValueAsLong", "()J", "jtransc-core_main"})
    public static final class LITERAL
    extends LiteralExpr {
        @NotNull
        private final AstType type;
        @Nullable
        private final Object value;

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        public final int getValueAsInt() {
            Object object = this.getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            return ((Number)object).intValue();
        }

        public final long getValueAsLong() {
            Object object = this.getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            return ((Number)object).longValue();
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.value;
        }

        public LITERAL(@Nullable Object value, boolean dummy) {
            this.value = value;
            this.type = AstType.Companion.fromConstant(this.getValue());
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jtransc/ast/AstExpr$LITERAL_REFNAME;", "Lcom/jtransc/ast/AstExpr$LiteralExpr;", "value", "", "(Ljava/lang/Object;)V", "type", "Lcom/jtransc/ast/AstType$REF;", "getType", "()Lcom/jtransc/ast/AstType$REF;", "getValue", "()Ljava/lang/Object;", "jtransc-core_main"})
    public static final class LITERAL_REFNAME
    extends LiteralExpr {
        @NotNull
        private final AstType.REF type;
        @Nullable
        private final Object value;

        @Override
        @NotNull
        public AstType.REF getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.value;
        }

        public LITERAL_REFNAME(@Nullable Object value) {
            this.value = value;
            this.type = AstType.Companion.getSTRING();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jtransc/ast/AstExpr$CAUGHT_EXCEPTION;", "Lcom/jtransc/ast/AstExpr;", "type", "Lcom/jtransc/ast/AstType;", "(Lcom/jtransc/ast/AstType;)V", "getType", "()Lcom/jtransc/ast/AstType;", "jtransc-core_main"})
    public static final class CAUGHT_EXCEPTION
    extends AstExpr {
        @NotNull
        private final AstType type;

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        public CAUGHT_EXCEPTION(@NotNull AstType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            this.type = type2;
        }

        public /* synthetic */ CAUGHT_EXCEPTION(AstType astType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                astType = AstType.Companion.getOBJECT();
            }
            this(astType);
        }

        public CAUGHT_EXCEPTION() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jtransc/ast/AstExpr$BINOP;", "Lcom/jtransc/ast/AstExpr;", "type", "Lcom/jtransc/ast/AstType;", "left", "op", "Lcom/jtransc/ast/AstBinop;", "right", "(Lcom/jtransc/ast/AstType;Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/AstBinop;Lcom/jtransc/ast/AstExpr;)V", "Lcom/jtransc/ast/AstExpr$Box;", "getLeft", "()Lcom/jtransc/ast/AstExpr$Box;", "getOp", "()Lcom/jtransc/ast/AstBinop;", "getRight", "getType", "()Lcom/jtransc/ast/AstType;", "jtransc-core_main"})
    public static final class BINOP
    extends AstExpr {
        @NotNull
        private final Box left;
        @NotNull
        private final Box right;
        @NotNull
        private final AstType type;
        @NotNull
        private final AstBinop op;

        @NotNull
        public final Box getLeft() {
            return this.left;
        }

        @NotNull
        public final Box getRight() {
            return this.right;
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @NotNull
        public final AstBinop getOp() {
            return this.op;
        }

        public BINOP(@NotNull AstType type2, @NotNull AstExpr left, @NotNull AstBinop op, @NotNull AstExpr right) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
            Intrinsics.checkParameterIsNotNull((Object)((Object)op), (String)"op");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            this.type = type2;
            this.op = op;
            this.left = left.getBox();
            this.right = right.getBox();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jtransc/ast/AstExpr$UNOP;", "Lcom/jtransc/ast/AstExpr;", "op", "Lcom/jtransc/ast/AstUnop;", "right", "(Lcom/jtransc/ast/AstUnop;Lcom/jtransc/ast/AstExpr;)V", "getOp", "()Lcom/jtransc/ast/AstUnop;", "Lcom/jtransc/ast/AstExpr$Box;", "getRight", "()Lcom/jtransc/ast/AstExpr$Box;", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "jtransc-core_main"})
    public static final class UNOP
    extends AstExpr {
        @NotNull
        private final Box right;
        @NotNull
        private final AstType type;
        @NotNull
        private final AstUnop op;

        @NotNull
        public final Box getRight() {
            return this.right;
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @NotNull
        public final AstUnop getOp() {
            return this.op;
        }

        public UNOP(@NotNull AstUnop op, @NotNull AstExpr right) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)op), (String)"op");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            this.op = op;
            this.right = right.getBox();
            this.type = right.getType();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jtransc/ast/AstExpr$CALL_BASE;", "Lcom/jtransc/ast/AstExpr;", "()V", "args", "", "Lcom/jtransc/ast/AstExpr$Box;", "getArgs", "()Ljava/util/List;", "isSpecial", "", "()Z", "method", "Lcom/jtransc/ast/AstMethodRef;", "getMethod", "()Lcom/jtransc/ast/AstMethodRef;", "jtransc-core_main"})
    public static abstract class CALL_BASE
    extends AstExpr {
        @NotNull
        public abstract AstMethodRef getMethod();

        @NotNull
        public abstract List<Box> getArgs();

        public abstract boolean isSpecial();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jtransc/ast/AstExpr$CALL_BASE_OBJECT;", "Lcom/jtransc/ast/AstExpr$CALL_BASE;", "()V", "obj", "Lcom/jtransc/ast/AstExpr$Box;", "getObj", "()Lcom/jtransc/ast/AstExpr$Box;", "jtransc-core_main"})
    public static abstract class CALL_BASE_OBJECT
    extends CALL_BASE {
        @NotNull
        public abstract Box getObj();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jtransc/ast/AstExpr$CALL_INSTANCE;", "Lcom/jtransc/ast/AstExpr$CALL_BASE_OBJECT;", "obj", "Lcom/jtransc/ast/AstExpr;", "method", "Lcom/jtransc/ast/AstMethodRef;", "args", "", "isSpecial", "", "(Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/AstMethodRef;Ljava/util/List;Z)V", "Lcom/jtransc/ast/AstExpr$Box;", "getArgs", "()Ljava/util/List;", "()Z", "getMethod", "()Lcom/jtransc/ast/AstMethodRef;", "getObj", "()Lcom/jtransc/ast/AstExpr$Box;", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "jtransc-core_main"})
    public static final class CALL_INSTANCE
    extends CALL_BASE_OBJECT {
        @NotNull
        private final Box obj;
        @NotNull
        private final List<Box> args;
        @NotNull
        private final AstType type;
        @NotNull
        private final AstMethodRef method;
        private final boolean isSpecial;

        @Override
        @NotNull
        public Box getObj() {
            return this.obj;
        }

        @Override
        @NotNull
        public List<Box> getArgs() {
            return this.args;
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public AstMethodRef getMethod() {
            return this.method;
        }

        @Override
        public boolean isSpecial() {
            return this.isSpecial;
        }

        /*
         * WARNING - void declaration
         */
        public CALL_INSTANCE(@NotNull AstExpr obj2, @NotNull AstMethodRef method2, @NotNull List<? extends AstExpr> args, boolean isSpecial) {
            Collection<Box> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method");
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            this.method = method2;
            this.isSpecial = isSpecial;
            this.obj = obj2.getBox();
            Iterable iterable = args;
            CALL_INSTANCE cALL_INSTANCE = this;
            void var6_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                AstExpr astExpr = (AstExpr)item$iv$iv;
                collection = destination$iv$iv;
                Box box = it.getBox();
                collection.add(box);
            }
            collection = (List)destination$iv$iv;
            cALL_INSTANCE.args = collection;
            this.type = this.getMethod().getType().getRet();
        }

        public /* synthetic */ CALL_INSTANCE(AstExpr astExpr, AstMethodRef astMethodRef, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            this(astExpr, astMethodRef, list, bl);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/jtransc/ast/AstExpr$CALL_SUPER;", "Lcom/jtransc/ast/AstExpr$CALL_BASE_OBJECT;", "obj", "Lcom/jtransc/ast/AstExpr;", "target", "Lcom/jtransc/ast/FqName;", "method", "Lcom/jtransc/ast/AstMethodRef;", "args", "", "isSpecial", "", "(Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/FqName;Lcom/jtransc/ast/AstMethodRef;Ljava/util/List;Z)V", "Lcom/jtransc/ast/AstExpr$Box;", "getArgs", "()Ljava/util/List;", "()Z", "getMethod", "()Lcom/jtransc/ast/AstMethodRef;", "getObj", "()Lcom/jtransc/ast/AstExpr$Box;", "getTarget", "()Lcom/jtransc/ast/FqName;", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "jtransc-core_main"})
    public static final class CALL_SUPER
    extends CALL_BASE_OBJECT {
        @NotNull
        private final Box obj;
        @NotNull
        private final List<Box> args;
        @NotNull
        private final AstType type;
        @NotNull
        private final FqName target;
        @NotNull
        private final AstMethodRef method;
        private final boolean isSpecial;

        @Override
        @NotNull
        public Box getObj() {
            return this.obj;
        }

        @Override
        @NotNull
        public List<Box> getArgs() {
            return this.args;
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @NotNull
        public final FqName getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public AstMethodRef getMethod() {
            return this.method;
        }

        @Override
        public boolean isSpecial() {
            return this.isSpecial;
        }

        /*
         * WARNING - void declaration
         */
        public CALL_SUPER(@NotNull AstExpr obj2, @NotNull FqName target, @NotNull AstMethodRef method2, @NotNull List<? extends AstExpr> args, boolean isSpecial) {
            Collection<Box> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method");
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            this.target = target;
            this.method = method2;
            this.isSpecial = isSpecial;
            this.obj = obj2.getBox();
            Iterable iterable = args;
            CALL_SUPER cALL_SUPER = this;
            void var7_8 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                AstExpr astExpr = (AstExpr)item$iv$iv;
                collection = destination$iv$iv;
                Box box = it.getBox();
                collection.add(box);
            }
            collection = (List)destination$iv$iv;
            cALL_SUPER.args = collection;
            this.type = this.getMethod().getType().getRet();
        }

        public /* synthetic */ CALL_SUPER(AstExpr astExpr, FqName fqName, AstMethodRef astMethodRef, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(astExpr, fqName, astMethodRef, list, bl);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jtransc/ast/AstExpr$CALL_STATIC;", "Lcom/jtransc/ast/AstExpr$CALL_BASE;", "method", "Lcom/jtransc/ast/AstMethodRef;", "args", "", "Lcom/jtransc/ast/AstExpr;", "isSpecial", "", "(Lcom/jtransc/ast/AstMethodRef;Ljava/util/List;Z)V", "clazz", "Lcom/jtransc/ast/AstType$REF;", "(Lcom/jtransc/ast/AstType$REF;Lcom/jtransc/ast/AstMethodRef;Ljava/util/List;Z)V", "Lcom/jtransc/ast/AstExpr$Box;", "getArgs", "()Ljava/util/List;", "getClazz", "()Lcom/jtransc/ast/AstType$REF;", "()Z", "getMethod", "()Lcom/jtransc/ast/AstMethodRef;", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "jtransc-core_main"})
    public static final class CALL_STATIC
    extends CALL_BASE {
        @NotNull
        private final List<Box> args;
        @NotNull
        private final AstType type;
        @NotNull
        private final AstType.REF clazz;
        @NotNull
        private final AstMethodRef method;
        private final boolean isSpecial;

        @Override
        @NotNull
        public List<Box> getArgs() {
            return this.args;
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @NotNull
        public final AstType.REF getClazz() {
            return this.clazz;
        }

        @Override
        @NotNull
        public AstMethodRef getMethod() {
            return this.method;
        }

        @Override
        public boolean isSpecial() {
            return this.isSpecial;
        }

        /*
         * WARNING - void declaration
         */
        public CALL_STATIC(@NotNull AstType.REF clazz2, @NotNull AstMethodRef method2, @NotNull List<? extends AstExpr> args, boolean isSpecial) {
            Collection<Box> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)clazz2, (String)"clazz");
            Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method");
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            this.clazz = clazz2;
            this.method = method2;
            this.isSpecial = isSpecial;
            Iterable iterable = args;
            CALL_STATIC cALL_STATIC = this;
            void var6_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                AstExpr astExpr = (AstExpr)item$iv$iv;
                collection = destination$iv$iv;
                Box box = it.getBox();
                collection.add(box);
            }
            collection = (List)destination$iv$iv;
            cALL_STATIC.args = collection;
            this.type = this.getMethod().getType().getRet();
        }

        public /* synthetic */ CALL_STATIC(AstType.REF rEF, AstMethodRef astMethodRef, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            this(rEF, astMethodRef, list, bl);
        }

        public CALL_STATIC(@NotNull AstMethodRef method2, @NotNull List<? extends AstExpr> args, boolean isSpecial) {
            Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method");
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            this(method2.getClassRef(), method2, args, isSpecial);
        }

        public /* synthetic */ CALL_STATIC(AstMethodRef astMethodRef, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(astMethodRef, list, bl);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0002\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jtransc/ast/AstExpr$ARRAY_LENGTH;", "Lcom/jtransc/ast/AstExpr;", "array", "(Lcom/jtransc/ast/AstExpr;)V", "Lcom/jtransc/ast/AstExpr$Box;", "getArray", "()Lcom/jtransc/ast/AstExpr$Box;", "type", "Lcom/jtransc/ast/AstType$INT;", "getType", "()Lcom/jtransc/ast/AstType$INT;", "jtransc-core_main"})
    public static final class ARRAY_LENGTH
    extends AstExpr {
        @NotNull
        private final Box array;
        @NotNull
        private final AstType.INT type;

        @NotNull
        public final Box getArray() {
            return this.array;
        }

        @Override
        @NotNull
        public AstType.INT getType() {
            return this.type;
        }

        public ARRAY_LENGTH(@NotNull AstExpr array) {
            Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
            this.array = array.getBox();
            this.type = AstType.INT.INSTANCE;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/jtransc/ast/AstExpr$ARRAY_ACCESS;", "Lcom/jtransc/ast/AstExpr$LValueExpr;", "array", "Lcom/jtransc/ast/AstExpr;", "index", "(Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/AstExpr;)V", "Lcom/jtransc/ast/AstExpr$Box;", "getArray", "()Lcom/jtransc/ast/AstExpr$Box;", "getIndex", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "type$delegate", "Lkotlin/Lazy;", "jtransc-core_main"})
    public static final class ARRAY_ACCESS
    extends LValueExpr {
        @NotNull
        private final Box array;
        @NotNull
        private final Box index;
        @NotNull
        private final Lazy type$delegate;
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        @NotNull
        public final Box getArray() {
            return this.array;
        }

        @NotNull
        public final Box getIndex() {
            return this.index;
        }

        @Override
        @NotNull
        public AstType getType() {
            Lazy lazy = this.type$delegate;
            ARRAY_ACCESS aRRAY_ACCESS = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (AstType)lazy.getValue();
        }

        public ARRAY_ACCESS(@NotNull AstExpr array, @NotNull AstExpr index) {
            Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            this.array = array.getBox();
            this.index = index.getBox();
            this.type$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AstType>(array){
                final /* synthetic */ AstExpr $array;

                @NotNull
                public final AstType invoke() {
                    return Ast_typeKt.getElementType(this.$array.getType());
                }
                {
                    this.$array = astExpr;
                    super(0);
                }
            }));
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ARRAY_ACCESS.class), "type", "getType()Lcom/jtransc/ast/AstType;"))};
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jtransc/ast/AstExpr$FIELD_INSTANCE_ACCESS;", "Lcom/jtransc/ast/AstExpr$LValueExpr;", "field", "Lcom/jtransc/ast/AstFieldRef;", "expr", "Lcom/jtransc/ast/AstExpr;", "(Lcom/jtransc/ast/AstFieldRef;Lcom/jtransc/ast/AstExpr;)V", "Lcom/jtransc/ast/AstExpr$Box;", "getExpr", "()Lcom/jtransc/ast/AstExpr$Box;", "getField", "()Lcom/jtransc/ast/AstFieldRef;", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "jtransc-core_main"})
    public static final class FIELD_INSTANCE_ACCESS
    extends LValueExpr {
        @NotNull
        private final Box expr;
        @NotNull
        private final AstType type;
        @NotNull
        private final AstFieldRef field;

        @NotNull
        public final Box getExpr() {
            return this.expr;
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @NotNull
        public final AstFieldRef getField() {
            return this.field;
        }

        public FIELD_INSTANCE_ACCESS(@NotNull AstFieldRef field, @NotNull AstExpr expr) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
            this.field = field;
            this.expr = expr.getBox();
            this.type = this.field.getType();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jtransc/ast/AstExpr$FIELD_STATIC_ACCESS;", "Lcom/jtransc/ast/AstExpr$LValueExpr;", "field", "Lcom/jtransc/ast/AstFieldRef;", "(Lcom/jtransc/ast/AstFieldRef;)V", "clazzName", "Lcom/jtransc/ast/AstType$REF;", "getClazzName", "()Lcom/jtransc/ast/AstType$REF;", "getField", "()Lcom/jtransc/ast/AstFieldRef;", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "jtransc-core_main"})
    public static final class FIELD_STATIC_ACCESS
    extends LValueExpr {
        @NotNull
        private final AstType.REF clazzName;
        @NotNull
        private final AstType type;
        @NotNull
        private final AstFieldRef field;

        @NotNull
        public final AstType.REF getClazzName() {
            return this.clazzName;
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @NotNull
        public final AstFieldRef getField() {
            return this.field;
        }

        public FIELD_STATIC_ACCESS(@NotNull AstFieldRef field) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            this.field = field;
            this.clazzName = this.field.getContainingTypeRef();
            this.type = this.field.getType();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jtransc/ast/AstExpr$INSTANCE_OF;", "Lcom/jtransc/ast/AstExpr;", "expr", "checkType", "Lcom/jtransc/ast/AstType$Reference;", "(Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/AstType$Reference;)V", "getCheckType", "()Lcom/jtransc/ast/AstType$Reference;", "Lcom/jtransc/ast/AstExpr$Box;", "getExpr", "()Lcom/jtransc/ast/AstExpr$Box;", "type", "Lcom/jtransc/ast/AstType$BOOL;", "getType", "()Lcom/jtransc/ast/AstType$BOOL;", "jtransc-core_main"})
    public static final class INSTANCE_OF
    extends AstExpr {
        @NotNull
        private final Box expr;
        @NotNull
        private final AstType.BOOL type;
        @NotNull
        private final AstType.Reference checkType;

        @NotNull
        public final Box getExpr() {
            return this.expr;
        }

        @Override
        @NotNull
        public AstType.BOOL getType() {
            return this.type;
        }

        @NotNull
        public final AstType.Reference getCheckType() {
            return this.checkType;
        }

        public INSTANCE_OF(@NotNull AstExpr expr, @NotNull AstType.Reference checkType) {
            Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
            Intrinsics.checkParameterIsNotNull((Object)checkType, (String)"checkType");
            this.checkType = checkType;
            this.expr = expr.getBox();
            this.type = AstType.BOOL.INSTANCE;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0001H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jtransc/ast/AstExpr$CAST;", "Lcom/jtransc/ast/AstExpr;", "expr", "to", "Lcom/jtransc/ast/AstType;", "dummy", "", "(Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/AstType;Z)V", "getDummy", "()Z", "from", "getFrom", "()Lcom/jtransc/ast/AstType;", "subject", "Lcom/jtransc/ast/AstExpr$Box;", "getSubject", "()Lcom/jtransc/ast/AstExpr$Box;", "getTo", "type", "getType", "clone", "jtransc-core_main"})
    public static final class CAST
    extends AstExpr {
        @NotNull
        private final Box subject;
        @NotNull
        private final AstType type;
        @NotNull
        private final AstType to;
        private final boolean dummy;

        @NotNull
        public final Box getSubject() {
            return this.subject;
        }

        @NotNull
        public final AstType getFrom() {
            return this.subject.getType();
        }

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public AstExpr clone() {
            return new CAST(this.subject.getValue().clone(), this.to, true);
        }

        @NotNull
        public final AstType getTo() {
            return this.to;
        }

        public final boolean getDummy() {
            return this.dummy;
        }

        public CAST(@NotNull AstExpr expr, @NotNull AstType to, boolean dummy) {
            Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
            Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
            this.to = to;
            this.dummy = dummy;
            this.subject = expr.getBox();
            this.type = this.to;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jtransc/ast/AstExpr$NEW;", "Lcom/jtransc/ast/AstExpr;", "target", "Lcom/jtransc/ast/AstType$REF;", "(Lcom/jtransc/ast/AstType$REF;)V", "getTarget", "()Lcom/jtransc/ast/AstType$REF;", "type", "getType", "jtransc-core_main"})
    public static final class NEW
    extends AstExpr {
        @NotNull
        private final AstType.REF type;
        @NotNull
        private final AstType.REF target;

        @Override
        @NotNull
        public AstType.REF getType() {
            return this.type;
        }

        @NotNull
        public final AstType.REF getTarget() {
            return this.target;
        }

        public NEW(@NotNull AstType.REF target) {
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            this.type = this.target = target;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/jtransc/ast/AstExpr$NEW_WITH_CONSTRUCTOR;", "Lcom/jtransc/ast/AstExpr;", "constructor", "Lcom/jtransc/ast/AstMethodRef;", "args", "", "(Lcom/jtransc/ast/AstMethodRef;Ljava/util/List;)V", "Lcom/jtransc/ast/AstExpr$Box;", "getArgs", "()Ljava/util/List;", "getConstructor", "()Lcom/jtransc/ast/AstMethodRef;", "target", "Lcom/jtransc/ast/AstType$REF;", "getTarget", "()Lcom/jtransc/ast/AstType$REF;", "type", "getType", "jtransc-core_main"})
    public static final class NEW_WITH_CONSTRUCTOR
    extends AstExpr {
        @NotNull
        private final AstType.REF target;
        @NotNull
        private final List<Box> args;
        @NotNull
        private final AstType.REF type;
        @NotNull
        private final AstMethodRef constructor;

        @NotNull
        public final AstType.REF getTarget() {
            return this.target;
        }

        @NotNull
        public final List<Box> getArgs() {
            return this.args;
        }

        @Override
        @NotNull
        public AstType.REF getType() {
            return this.type;
        }

        @NotNull
        public final AstMethodRef getConstructor() {
            return this.constructor;
        }

        /*
         * WARNING - void declaration
         */
        public NEW_WITH_CONSTRUCTOR(@NotNull AstMethodRef constructor, @NotNull List<? extends AstExpr> args) {
            Collection<Box> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            this.constructor = constructor;
            this.target = this.constructor.getContainingClassType();
            Iterable iterable = args;
            NEW_WITH_CONSTRUCTOR nEW_WITH_CONSTRUCTOR = this;
            void var4_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                AstExpr astExpr = (AstExpr)item$iv$iv;
                collection = destination$iv$iv;
                Box box = it.getBox();
                collection.add(box);
            }
            collection = (List)destination$iv$iv;
            nEW_WITH_CONSTRUCTOR.args = collection;
            this.type = this.target;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/jtransc/ast/AstExpr$NEW_ARRAY;", "Lcom/jtransc/ast/AstExpr;", "arrayType", "Lcom/jtransc/ast/AstType$ARRAY;", "counts", "", "(Lcom/jtransc/ast/AstType$ARRAY;Ljava/util/List;)V", "getArrayType", "()Lcom/jtransc/ast/AstType$ARRAY;", "Lcom/jtransc/ast/AstExpr$Box;", "getCounts", "()Ljava/util/List;", "type", "getType", "jtransc-core_main"})
    public static final class NEW_ARRAY
    extends AstExpr {
        @NotNull
        private final List<Box> counts;
        @NotNull
        private final AstType.ARRAY type;
        @NotNull
        private final AstType.ARRAY arrayType;

        @NotNull
        public final List<Box> getCounts() {
            return this.counts;
        }

        @Override
        @NotNull
        public AstType.ARRAY getType() {
            return this.type;
        }

        @NotNull
        public final AstType.ARRAY getArrayType() {
            return this.arrayType;
        }

        /*
         * WARNING - void declaration
         */
        public NEW_ARRAY(@NotNull AstType.ARRAY arrayType, @NotNull List<? extends AstExpr> counts) {
            Collection<Box> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)arrayType, (String)"arrayType");
            Intrinsics.checkParameterIsNotNull(counts, (String)"counts");
            this.arrayType = arrayType;
            Iterable iterable = counts;
            NEW_ARRAY nEW_ARRAY = this;
            void var4_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                AstExpr astExpr = (AstExpr)item$iv$iv;
                collection = destination$iv$iv;
                Box box = it.getBox();
                collection.add(box);
            }
            collection = (List)destination$iv$iv;
            nEW_ARRAY.counts = collection;
            this.type = this.arrayType;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jtransc/ast/AstExpr$INTARRAY_LITERAL;", "Lcom/jtransc/ast/AstExpr;", "values", "", "", "(Ljava/util/List;)V", "arrayType", "Lcom/jtransc/ast/AstType$ARRAY;", "getArrayType", "()Lcom/jtransc/ast/AstType$ARRAY;", "type", "getType", "getValues", "()Ljava/util/List;", "jtransc-core_main"})
    public static final class INTARRAY_LITERAL
    extends AstExpr {
        @NotNull
        private final AstType.ARRAY arrayType;
        @NotNull
        private final AstType.ARRAY type;
        @NotNull
        private final List<Integer> values;

        @NotNull
        public final AstType.ARRAY getArrayType() {
            return this.arrayType;
        }

        @Override
        @NotNull
        public AstType.ARRAY getType() {
            return this.type;
        }

        @NotNull
        public final List<Integer> getValues() {
            return this.values;
        }

        public INTARRAY_LITERAL(@NotNull List<Integer> values) {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            this.values = values;
            this.type = this.arrayType = new AstType.ARRAY(AstType.INT.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jtransc/ast/AstExpr$STRINGARRAY_LITERAL;", "Lcom/jtransc/ast/AstExpr;", "values", "", "", "(Ljava/util/List;)V", "arrayType", "Lcom/jtransc/ast/AstType$ARRAY;", "getArrayType", "()Lcom/jtransc/ast/AstType$ARRAY;", "type", "getType", "getValues", "()Ljava/util/List;", "jtransc-core_main"})
    public static final class STRINGARRAY_LITERAL
    extends AstExpr {
        @NotNull
        private final AstType.ARRAY arrayType;
        @NotNull
        private final AstType.ARRAY type;
        @NotNull
        private final List<String> values;

        @NotNull
        public final AstType.ARRAY getArrayType() {
            return this.arrayType;
        }

        @Override
        @NotNull
        public AstType.ARRAY getType() {
            return this.type;
        }

        @NotNull
        public final List<String> getValues() {
            return this.values;
        }

        public STRINGARRAY_LITERAL(@NotNull List<String> values) {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            this.values = values;
            this.type = this.arrayType = new AstType.ARRAY(AstType.Companion.getSTRING());
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jtransc/ast/AstExpr$INVOKE_DYNAMIC_METHOD;", "Lcom/jtransc/ast/AstExpr;", "methodInInterfaceRef", "Lcom/jtransc/ast/AstMethodRef;", "methodToConvertRef", "extraArgCount", "", "startArgs", "", "(Lcom/jtransc/ast/AstMethodRef;Lcom/jtransc/ast/AstMethodRef;ILjava/util/List;)V", "getExtraArgCount", "()I", "setExtraArgCount", "(I)V", "getMethodInInterfaceRef", "()Lcom/jtransc/ast/AstMethodRef;", "getMethodToConvertRef", "getStartArgs", "()Ljava/util/List;", "setStartArgs", "(Ljava/util/List;)V", "type", "Lcom/jtransc/ast/AstType$REF;", "getType", "()Lcom/jtransc/ast/AstType$REF;", "jtransc-core_main"})
    public static final class INVOKE_DYNAMIC_METHOD
    extends AstExpr {
        @NotNull
        private final AstType.REF type;
        @NotNull
        private final AstMethodRef methodInInterfaceRef;
        @NotNull
        private final AstMethodRef methodToConvertRef;
        private int extraArgCount;
        @NotNull
        private List<? extends AstExpr> startArgs;

        @Override
        @NotNull
        public AstType.REF getType() {
            return this.type;
        }

        @NotNull
        public final AstMethodRef getMethodInInterfaceRef() {
            return this.methodInInterfaceRef;
        }

        @NotNull
        public final AstMethodRef getMethodToConvertRef() {
            return this.methodToConvertRef;
        }

        public final int getExtraArgCount() {
            return this.extraArgCount;
        }

        public final void setExtraArgCount(int n) {
            this.extraArgCount = n;
        }

        @NotNull
        public final List<AstExpr> getStartArgs() {
            return this.startArgs;
        }

        public final void setStartArgs(@NotNull List<? extends AstExpr> list) {
            Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
            this.startArgs = list;
        }

        public INVOKE_DYNAMIC_METHOD(@NotNull AstMethodRef methodInInterfaceRef, @NotNull AstMethodRef methodToConvertRef, int extraArgCount, @NotNull List<? extends AstExpr> startArgs) {
            Intrinsics.checkParameterIsNotNull((Object)methodInInterfaceRef, (String)"methodInInterfaceRef");
            Intrinsics.checkParameterIsNotNull((Object)methodToConvertRef, (String)"methodToConvertRef");
            Intrinsics.checkParameterIsNotNull(startArgs, (String)"startArgs");
            this.methodInInterfaceRef = methodInInterfaceRef;
            this.methodToConvertRef = methodToConvertRef;
            this.extraArgCount = extraArgCount;
            this.startArgs = startArgs;
            this.type = new AstType.REF(this.methodInInterfaceRef.getContainingClass());
        }

        public /* synthetic */ INVOKE_DYNAMIC_METHOD(AstMethodRef astMethodRef, AstMethodRef astMethodRef2, int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(astMethodRef, astMethodRef2, n, list);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jtransc/ast/AstExpr$TERNARY;", "Lcom/jtransc/ast/AstExpr;", "cond", "etrue", "efalse", "types", "Lcom/jtransc/ast/AstTypes;", "(Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/AstExpr;Lcom/jtransc/ast/AstTypes;)V", "getCond", "()Lcom/jtransc/ast/AstExpr;", "getEfalse", "getEtrue", "type", "Lcom/jtransc/ast/AstType;", "getType", "()Lcom/jtransc/ast/AstType;", "getTypes", "()Lcom/jtransc/ast/AstTypes;", "jtransc-core_main"})
    public static final class TERNARY
    extends AstExpr {
        @NotNull
        private final AstType type;
        @NotNull
        private final AstExpr cond;
        @NotNull
        private final AstExpr etrue;
        @NotNull
        private final AstExpr efalse;
        @NotNull
        private final AstTypes types;

        @Override
        @NotNull
        public AstType getType() {
            return this.type;
        }

        @NotNull
        public final AstExpr getCond() {
            return this.cond;
        }

        @NotNull
        public final AstExpr getEtrue() {
            return this.etrue;
        }

        @NotNull
        public final AstExpr getEfalse() {
            return this.efalse;
        }

        @NotNull
        public final AstTypes getTypes() {
            return this.types;
        }

        public TERNARY(@NotNull AstExpr cond, @NotNull AstExpr etrue, @NotNull AstExpr efalse, @NotNull AstTypes types) {
            Intrinsics.checkParameterIsNotNull((Object)cond, (String)"cond");
            Intrinsics.checkParameterIsNotNull((Object)etrue, (String)"etrue");
            Intrinsics.checkParameterIsNotNull((Object)efalse, (String)"efalse");
            Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
            this.cond = cond;
            this.etrue = etrue;
            this.efalse = efalse;
            this.types = types;
            this.type = this.types.unify(this.etrue.getType(), this.efalse.getType());
        }
    }
}

