/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.ast;

import com.jtransc.ast.AstArgument;
import com.jtransc.ast.AstMethodHandle;
import com.jtransc.ast.AstRef;
import com.jtransc.ast.Ast_typeKt;
import com.jtransc.ast.FqName;
import com.jtransc.error.ErrorsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u001d\b\u0016\u0018\u0000 \b2\u00020\u0001:\u001b\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jtransc/ast/AstType;", "", "()V", "ARRAY", "BOOL", "BYTE", "CHAR", "COMMON", "Companion", "DOUBLE", "FLOAT", "GENERIC", "GENERIC_DESCRIPTOR", "GENERIC_ITEM", "GENERIC_LOWER_BOUND", "GENERIC_STAR", "GENERIC_SUFFIX", "GENERIC_UPPER_BOUND", "INT", "LONG", "METHOD", "MUTABLE", "NULL", "Primitive", "REF", "Reference", "SHORT", "TYPE_PARAMETER", "UNKNOWN", "VOID", "jtransc-core_main"})
public class AstType {
    @NotNull
    private static final REF THROWABLE;
    @NotNull
    private static final REF STRING;
    @NotNull
    private static final REF STRINGBUILDER;
    @NotNull
    private static final REF OBJECT;
    @NotNull
    private static final REF CLASS;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        THROWABLE = new REF("java.lang.Throwable");
        STRING = new REF("java.lang.String");
        STRINGBUILDER = new REF("java.lang.StringBuilder");
        OBJECT = new REF("java.lang.Object");
        CLASS = new REF("java.lang.Class");
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000J\u0013\u0010\u001f\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\bH\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lcom/jtransc/ast/AstType$Primitive;", "Lcom/jtransc/ast/AstType;", "underlyingClassStr", "", "ch", "", "shortName", "byteSize", "", "priority", "subsets", "", "(Ljava/lang/String;CLjava/lang/String;IILjava/util/Set;)V", "CLASSTYPE", "Lcom/jtransc/ast/AstType$REF;", "getCLASSTYPE", "()Lcom/jtransc/ast/AstType$REF;", "getByteSize", "()I", "getCh", "()C", "chstring", "getChstring", "()Ljava/lang/String;", "getPriority", "getShortName", "getSubsets", "()Ljava/util/Set;", "canHold", "", "other", "equals", "", "hashCode", "toString", "jtransc-core_main"})
    public static abstract class Primitive
    extends AstType {
        @NotNull
        private final REF CLASSTYPE;
        @NotNull
        private final String chstring;
        private final char ch;
        @NotNull
        private final String shortName;
        private final int byteSize;
        private final int priority;
        @NotNull
        private final Set<Primitive> subsets;

        @NotNull
        public final REF getCLASSTYPE() {
            return this.CLASSTYPE;
        }

        @NotNull
        public final String getChstring() {
            return this.chstring;
        }

        public int hashCode() {
            return this.ch;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Primitive)) {
                return false;
            }
            return Objects.equals(Character.valueOf(this.ch), Character.valueOf(((Primitive)other).ch));
        }

        @NotNull
        public String toString() {
            return this.shortName;
        }

        public final boolean canHold(@NotNull Primitive other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return this.subsets.contains(other);
        }

        public final char getCh() {
            return this.ch;
        }

        @NotNull
        public final String getShortName() {
            return this.shortName;
        }

        public final int getByteSize() {
            return this.byteSize;
        }

        public final int getPriority() {
            return this.priority;
        }

        @NotNull
        public final Set<Primitive> getSubsets() {
            return this.subsets;
        }

        public Primitive(@NotNull String underlyingClassStr, char ch, @NotNull String shortName, int byteSize, int priority, @NotNull Set<? extends Primitive> subsets) {
            Intrinsics.checkParameterIsNotNull((Object)underlyingClassStr, (String)"underlyingClassStr");
            Intrinsics.checkParameterIsNotNull((Object)shortName, (String)"shortName");
            Intrinsics.checkParameterIsNotNull(subsets, (String)"subsets");
            this.ch = ch;
            this.shortName = shortName;
            this.byteSize = byteSize;
            this.priority = priority;
            this.subsets = subsets;
            this.CLASSTYPE = new REF(underlyingClassStr);
            this.chstring = String.valueOf(this.ch);
        }

        public /* synthetic */ Primitive(String string, char c, String string2, int n, int n2, Set set, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x20) != 0) {
                set = SetsKt.emptySet();
            }
            this(string, c, string2, n, n2, set);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$Reference;", "Lcom/jtransc/ast/AstType;", "()V", "jtransc-core_main"})
    public static class Reference
    extends AstType {
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jtransc/ast/AstType$UNKNOWN;", "Lcom/jtransc/ast/AstType$Reference;", "reason", "", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "jtransc-core_main"})
    public static final class UNKNOWN
    extends Reference {
        @NotNull
        private final String reason;

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        public UNKNOWN(@NotNull String reason) {
            Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
            this.reason = reason;
        }

        @NotNull
        public final String component1() {
            return this.reason;
        }

        @NotNull
        public final UNKNOWN copy(@NotNull String reason) {
            Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
            return new UNKNOWN(reason);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ UNKNOWN copy$default(UNKNOWN uNKNOWN, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = uNKNOWN.reason;
            }
            return uNKNOWN.copy(string);
        }

        public String toString() {
            return "UNKNOWN(reason=" + this.reason + ")";
        }

        public int hashCode() {
            String string = this.reason;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UNKNOWN)) break block3;
                    UNKNOWN uNKNOWN = (UNKNOWN)object;
                    if (!Intrinsics.areEqual((Object)this.reason, (Object)uNKNOWN.reason)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$NULL;", "Lcom/jtransc/ast/AstType$Reference;", "()V", "jtransc-core_main"})
    public static final class NULL
    extends Reference {
        public static final NULL INSTANCE;

        private NULL() {
            INSTANCE = this;
        }

        static {
            new NULL();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$VOID;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class VOID
    extends Primitive {
        public static final VOID INSTANCE;

        private VOID() {
            int n = 8;
            int n2 = 0;
            String string = "void";
            char c = 'V';
            String string2 = "java.lang.Void";
            VOID vOID = this;
            Set set = SetsKt.emptySet();
            super(string2, c, string, n2, n, set);
            INSTANCE = this;
        }

        static {
            new VOID();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$BOOL;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class BOOL
    extends Primitive {
        public static final BOOL INSTANCE;

        private BOOL() {
            int n = 7;
            int n2 = 1;
            String string = "bool";
            char c = 'Z';
            String string2 = "java.lang.Boolean";
            BOOL bOOL = this;
            Set set = SetsKt.emptySet();
            super(string2, c, string, n2, n, set);
            INSTANCE = this;
        }

        static {
            new BOOL();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$BYTE;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class BYTE
    extends Primitive {
        public static final BYTE INSTANCE;

        private BYTE() {
            super("java.lang.Byte", 'B', "byte", 1, 6, SetsKt.setOf((Object)BOOL.INSTANCE));
            INSTANCE = this;
        }

        static {
            new BYTE();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$CHAR;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class CHAR
    extends Primitive {
        public static final CHAR INSTANCE;

        private CHAR() {
            super("java.lang.Character", 'C', "char", 2, 5, SetsKt.setOf((Object)BOOL.INSTANCE));
            INSTANCE = this;
        }

        static {
            new CHAR();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$SHORT;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class SHORT
    extends Primitive {
        public static final SHORT INSTANCE;

        private SHORT() {
            super("java.lang.Short", 'S', "short", 2, 4, SetsKt.setOf((Object[])new Primitive[]{BOOL.INSTANCE, BYTE.INSTANCE}));
            INSTANCE = this;
        }

        static {
            new SHORT();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$INT;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class INT
    extends Primitive {
        public static final INT INSTANCE;

        private INT() {
            super("java.lang.Integer", 'I', "int", 4, 3, SetsKt.setOf((Object[])new Primitive[]{BOOL.INSTANCE, BYTE.INSTANCE, CHAR.INSTANCE, SHORT.INSTANCE}));
            INSTANCE = this;
        }

        static {
            new INT();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$LONG;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class LONG
    extends Primitive {
        public static final LONG INSTANCE;

        private LONG() {
            super("java.lang.Long", 'J', "long", 8, 2, SetsKt.setOf((Object[])new Primitive[]{BOOL.INSTANCE, BYTE.INSTANCE, CHAR.INSTANCE, SHORT.INSTANCE, INT.INSTANCE}));
            INSTANCE = this;
        }

        static {
            new LONG();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$FLOAT;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class FLOAT
    extends Primitive {
        public static final FLOAT INSTANCE;

        private FLOAT() {
            super("java.lang.Float", 'F', "float", 4, 1, SetsKt.setOf((Object[])new Primitive[]{BOOL.INSTANCE, BYTE.INSTANCE, CHAR.INSTANCE, SHORT.INSTANCE}));
            INSTANCE = this;
        }

        static {
            new FLOAT();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$DOUBLE;", "Lcom/jtransc/ast/AstType$Primitive;", "()V", "jtransc-core_main"})
    public static final class DOUBLE
    extends Primitive {
        public static final DOUBLE INSTANCE;

        private DOUBLE() {
            super("java.lang.Double", 'D', "double", 8, 0, SetsKt.setOf((Object[])new Primitive[]{BOOL.INSTANCE, BYTE.INSTANCE, CHAR.INSTANCE, SHORT.INSTANCE, INT.INSTANCE}));
            INSTANCE = this;
        }

        static {
            new DOUBLE();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016R\u0011\u0010\b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/jtransc/ast/AstType$REF;", "Lcom/jtransc/ast/AstType$Reference;", "Lcom/jtransc/ast/AstRef;", "name", "", "(Ljava/lang/String;)V", "Lcom/jtransc/ast/FqName;", "(Lcom/jtransc/ast/FqName;)V", "fqname", "getFqname", "()Ljava/lang/String;", "getName", "()Lcom/jtransc/ast/FqName;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "jtransc-core_main"})
    public static final class REF
    extends Reference
    implements AstRef {
        @NotNull
        private final FqName name;

        @NotNull
        public final String getFqname() {
            return this.name.getFqname();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof REF)) {
                return false;
            }
            return Objects.equals(this.name, ((REF)other).name);
        }

        @NotNull
        public String toString() {
            return this.name.getFqname();
        }

        @NotNull
        public final FqName getName() {
            return this.name;
        }

        public REF(@NotNull FqName name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.name = name;
            if (StringsKt.contains$default((CharSequence)this.getFqname(), (char)';', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)this.getFqname(), (char)']', (boolean)false, (int)2, null)) {
                Void void_ = ErrorsKt.invalidOp$default((String)("AstType.REF containing ; or ] :: " + this.getFqname()), null, (int)2, null);
                throw null;
            }
        }

        public REF(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this(new FqName(name));
        }

        @NotNull
        public final FqName component1() {
            return this.name;
        }

        @NotNull
        public final REF copy(@NotNull FqName name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new REF(name);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ REF copy$default(REF rEF, FqName fqName, int n, Object object) {
            if ((n & 1) != 0) {
                fqName = rEF.name;
            }
            return rEF.copy(fqName);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jtransc/ast/AstType$ARRAY;", "Lcom/jtransc/ast/AstType$Reference;", "element", "Lcom/jtransc/ast/AstType;", "(Lcom/jtransc/ast/AstType;)V", "getElement", "()Lcom/jtransc/ast/AstType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jtransc-core_main"})
    public static final class ARRAY
    extends Reference {
        @NotNull
        private final AstType element;

        @NotNull
        public String toString() {
            return this.element + "[]";
        }

        @NotNull
        public final AstType getElement() {
            return this.element;
        }

        public ARRAY(@NotNull AstType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.element = element;
        }

        @NotNull
        public final AstType component1() {
            return this.element;
        }

        @NotNull
        public final ARRAY copy(@NotNull AstType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return new ARRAY(element);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ARRAY copy$default(ARRAY aRRAY, AstType astType, int n, Object object) {
            if ((n & 1) != 0) {
                astType = aRRAY.element;
            }
            return aRRAY.copy(astType);
        }

        public int hashCode() {
            AstType astType = this.element;
            return astType != null ? astType.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ARRAY)) break block3;
                    ARRAY aRRAY = (ARRAY)object;
                    if (!Intrinsics.areEqual((Object)this.element, (Object)aRRAY.element)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J\u0019\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/jtransc/ast/AstType$COMMON;", "Lcom/jtransc/ast/AstType;", "first", "(Lcom/jtransc/ast/AstType;)V", "elements", "Ljava/util/HashSet;", "(Ljava/util/HashSet;)V", "getElements", "()Ljava/util/HashSet;", "single", "getSingle", "()Lcom/jtransc/ast/AstType;", "singleOrInvalid", "getSingleOrInvalid", "add", "", "type", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jtransc-core_main"})
    public static final class COMMON
    extends AstType {
        @NotNull
        private final HashSet<AstType> elements;

        @Nullable
        public final AstType getSingle() {
            return this.elements.size() == 1 ? (AstType)CollectionsKt.first((Iterable)this.elements) : null;
        }

        @NotNull
        public final AstType getSingleOrInvalid() {
            AstType astType = this.getSingle();
            if (astType == null) {
                Void void_ = ErrorsKt.invalidArgument((String)("Common type not resolved " + this.elements));
                throw null;
            }
            return astType;
        }

        public final void add(@NotNull AstType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            if (Intrinsics.areEqual((Object)type2, (Object)this) ^ true) {
                if (type2 instanceof COMMON) {
                    Iterator<AstType> iterator2 = ((COMMON)type2).elements.iterator();
                    while (iterator2.hasNext()) {
                        AstType e;
                        AstType astType = e = iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)astType, (String)"e");
                        this.add(astType);
                    }
                } else {
                    Collection collection = this.elements;
                    collection.add(type2);
                }
            }
        }

        @NotNull
        public String toString() {
            return "COMMON(" + this.elements + ")";
        }

        @NotNull
        public final HashSet<AstType> getElements() {
            return this.elements;
        }

        public COMMON(@NotNull HashSet<AstType> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            this.elements = elements;
        }

        public COMMON(@NotNull AstType first) {
            Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
            this(new HashSet<AstType>());
            this.add(first);
        }

        @NotNull
        public final HashSet<AstType> component1() {
            return this.elements;
        }

        @NotNull
        public final COMMON copy(@NotNull HashSet<AstType> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return new COMMON(elements);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ COMMON copy$default(COMMON cOMMON, HashSet hashSet, int n, Object object) {
            if ((n & 1) != 0) {
                hashSet = cOMMON.elements;
            }
            return cOMMON.copy(hashSet);
        }

        public int hashCode() {
            HashSet<AstType> hashSet = this.elements;
            return hashSet != null ? ((Object)hashSet).hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof COMMON)) break block3;
                    COMMON cOMMON = (COMMON)object;
                    if (!Intrinsics.areEqual(this.elements, cOMMON.elements)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0007\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0011"}, d2={"Lcom/jtransc/ast/AstType$MUTABLE;", "Lcom/jtransc/ast/AstType;", "ref", "(Lcom/jtransc/ast/AstType;)V", "getRef", "()Lcom/jtransc/ast/AstType;", "setRef", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jtransc-core_main"})
    public static final class MUTABLE
    extends AstType {
        @NotNull
        private AstType ref;

        @NotNull
        public String toString() {
            return "MUTABLE(" + this.ref + ")";
        }

        @NotNull
        public final AstType getRef() {
            return this.ref;
        }

        public final void setRef(@NotNull AstType astType) {
            Intrinsics.checkParameterIsNotNull((Object)astType, (String)"<set-?>");
            this.ref = astType;
        }

        public MUTABLE(@NotNull AstType ref) {
            Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
            this.ref = ref;
        }

        @NotNull
        public final AstType component1() {
            return this.ref;
        }

        @NotNull
        public final MUTABLE copy(@NotNull AstType ref) {
            Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
            return new MUTABLE(ref);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ MUTABLE copy$default(MUTABLE mUTABLE, AstType astType, int n, Object object) {
            if ((n & 1) != 0) {
                astType = mUTABLE.ref;
            }
            return mUTABLE.copy(astType);
        }

        public int hashCode() {
            AstType astType = this.ref;
            return astType != null ? astType.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MUTABLE)) break block3;
                    MUTABLE mUTABLE = (MUTABLE)object;
                    if (!Intrinsics.areEqual((Object)this.ref, (Object)mUTABLE.ref)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u000bH\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/jtransc/ast/AstType$GENERIC;", "Lcom/jtransc/ast/AstType$Reference;", "type", "Lcom/jtransc/ast/AstType$REF;", "params", "", "Lcom/jtransc/ast/AstType;", "(Lcom/jtransc/ast/AstType$REF;Ljava/util/List;)V", "suffixes", "Lcom/jtransc/ast/AstType$GENERIC_SUFFIX;", "dummy", "", "(Lcom/jtransc/ast/AstType$REF;Ljava/util/List;Z)V", "getDummy", "()Z", "params0", "getParams0", "()Ljava/util/List;", "getSuffixes", "getType", "()Lcom/jtransc/ast/AstType$REF;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "jtransc-core_main"})
    public static final class GENERIC
    extends Reference {
        @NotNull
        private final REF type;
        @NotNull
        private final List<GENERIC_SUFFIX> suffixes;
        private final boolean dummy;

        @NotNull
        public final List<AstType> getParams0() {
            List<AstType> list = this.suffixes.get(0).getParams();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            return list;
        }

        @NotNull
        public final REF getType() {
            return this.type;
        }

        @NotNull
        public final List<GENERIC_SUFFIX> getSuffixes() {
            return this.suffixes;
        }

        public final boolean getDummy() {
            return this.dummy;
        }

        public GENERIC(@NotNull REF type2, @NotNull List<GENERIC_SUFFIX> suffixes, boolean dummy) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull(suffixes, (String)"suffixes");
            this.type = type2;
            this.suffixes = suffixes;
            this.dummy = dummy;
        }

        public GENERIC(@NotNull REF type2, @NotNull List<? extends AstType> params2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull(params2, (String)"params");
            this(type2, CollectionsKt.listOf((Object)new GENERIC_SUFFIX(null, params2)), true);
        }

        @NotNull
        public final REF component1() {
            return this.type;
        }

        @NotNull
        public final List<GENERIC_SUFFIX> component2() {
            return this.suffixes;
        }

        public final boolean component3() {
            return this.dummy;
        }

        @NotNull
        public final GENERIC copy(@NotNull REF type2, @NotNull List<GENERIC_SUFFIX> suffixes, boolean dummy) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            Intrinsics.checkParameterIsNotNull(suffixes, (String)"suffixes");
            return new GENERIC(type2, suffixes, dummy);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ GENERIC copy$default(GENERIC gENERIC, REF rEF, List list, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                rEF = gENERIC.type;
            }
            if ((n & 2) != 0) {
                list = gENERIC.suffixes;
            }
            if ((n & 4) != 0) {
                bl = gENERIC.dummy;
            }
            return gENERIC.copy(rEF, list, bl);
        }

        public String toString() {
            return "GENERIC(type=" + this.type + ", suffixes=" + this.suffixes + ", dummy=" + this.dummy + ")";
        }

        public int hashCode() {
            REF rEF = this.type;
            List<GENERIC_SUFFIX> list = this.suffixes;
            int n = ((rEF != null ? ((Object)rEF).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31;
            int n2 = this.dummy ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GENERIC)) break block3;
                    GENERIC gENERIC = (GENERIC)object;
                    if (!Intrinsics.areEqual((Object)this.type, (Object)gENERIC.type) || !Intrinsics.areEqual(this.suffixes, gENERIC.suffixes) || !(this.dummy == gENERIC.dummy)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jtransc/ast/AstType$GENERIC_SUFFIX;", "", "id", "", "params", "", "Lcom/jtransc/ast/AstType;", "(Ljava/lang/String;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "getParams", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jtransc-core_main"})
    public static final class GENERIC_SUFFIX {
        @Nullable
        private final String id;
        @Nullable
        private final List<AstType> params;

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final List<AstType> getParams() {
            return this.params;
        }

        public GENERIC_SUFFIX(@Nullable String id, @Nullable List<? extends AstType> params2) {
            this.id = id;
            this.params = params2;
        }

        @Nullable
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final List<AstType> component2() {
            return this.params;
        }

        @NotNull
        public final GENERIC_SUFFIX copy(@Nullable String id, @Nullable List<? extends AstType> params2) {
            return new GENERIC_SUFFIX(id, params2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ GENERIC_SUFFIX copy$default(GENERIC_SUFFIX gENERIC_SUFFIX, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = gENERIC_SUFFIX.id;
            }
            if ((n & 2) != 0) {
                list = gENERIC_SUFFIX.params;
            }
            return gENERIC_SUFFIX.copy(string, list);
        }

        public String toString() {
            return "GENERIC_SUFFIX(id=" + this.id + ", params=" + this.params + ")";
        }

        public int hashCode() {
            String string = this.id;
            List<AstType> list = this.params;
            return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GENERIC_SUFFIX)) break block3;
                    GENERIC_SUFFIX gENERIC_SUFFIX = (GENERIC_SUFFIX)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)gENERIC_SUFFIX.id) || !Intrinsics.areEqual(this.params, gENERIC_SUFFIX.params)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jtransc/ast/AstType$TYPE_PARAMETER;", "Lcom/jtransc/ast/AstType;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "jtransc-core_main"})
    public static final class TYPE_PARAMETER
    extends AstType {
        @NotNull
        private final String id;

        @NotNull
        public final String getId() {
            return this.id;
        }

        public TYPE_PARAMETER(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final TYPE_PARAMETER copy(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new TYPE_PARAMETER(id);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TYPE_PARAMETER copy$default(TYPE_PARAMETER tYPE_PARAMETER, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = tYPE_PARAMETER.id;
            }
            return tYPE_PARAMETER.copy(string);
        }

        public String toString() {
            return "TYPE_PARAMETER(id=" + this.id + ")";
        }

        public int hashCode() {
            String string = this.id;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TYPE_PARAMETER)) break block3;
                    TYPE_PARAMETER tYPE_PARAMETER = (TYPE_PARAMETER)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)tYPE_PARAMETER.id)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$GENERIC_STAR;", "Lcom/jtransc/ast/AstType;", "()V", "jtransc-core_main"})
    public static final class GENERIC_STAR
    extends AstType {
        public static final GENERIC_STAR INSTANCE;

        private GENERIC_STAR() {
            INSTANCE = this;
        }

        static {
            new GENERIC_STAR();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jtransc/ast/AstType$GENERIC_ITEM;", "Lcom/jtransc/ast/AstType;", "()V", "jtransc-core_main"})
    public static final class GENERIC_ITEM
    extends AstType {
        public static final GENERIC_ITEM INSTANCE;

        private GENERIC_ITEM() {
            INSTANCE = this;
        }

        static {
            new GENERIC_ITEM();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\u001b\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00050\u0004H\u00c6\u0003J/\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00050\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jtransc/ast/AstType$GENERIC_DESCRIPTOR;", "Lcom/jtransc/ast/AstType;", "element", "types", "", "Lkotlin/Pair;", "", "(Lcom/jtransc/ast/AstType;Ljava/util/List;)V", "getElement", "()Lcom/jtransc/ast/AstType;", "getTypes", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "jtransc-core_main"})
    public static final class GENERIC_DESCRIPTOR
    extends AstType {
        @NotNull
        private final AstType element;
        @NotNull
        private final List<Pair<String, AstType>> types;

        @NotNull
        public final AstType getElement() {
            return this.element;
        }

        @NotNull
        public final List<Pair<String, AstType>> getTypes() {
            return this.types;
        }

        public GENERIC_DESCRIPTOR(@NotNull AstType element, @NotNull List<? extends Pair<String, ? extends AstType>> types) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(types, (String)"types");
            this.element = element;
            this.types = types;
        }

        @NotNull
        public final AstType component1() {
            return this.element;
        }

        @NotNull
        public final List<Pair<String, AstType>> component2() {
            return this.types;
        }

        @NotNull
        public final GENERIC_DESCRIPTOR copy(@NotNull AstType element, @NotNull List<? extends Pair<String, ? extends AstType>> types) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(types, (String)"types");
            return new GENERIC_DESCRIPTOR(element, types);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ GENERIC_DESCRIPTOR copy$default(GENERIC_DESCRIPTOR gENERIC_DESCRIPTOR, AstType astType, List list, int n, Object object) {
            if ((n & 1) != 0) {
                astType = gENERIC_DESCRIPTOR.element;
            }
            if ((n & 2) != 0) {
                list = gENERIC_DESCRIPTOR.types;
            }
            return gENERIC_DESCRIPTOR.copy(astType, list);
        }

        public String toString() {
            return "GENERIC_DESCRIPTOR(element=" + this.element + ", types=" + this.types + ")";
        }

        public int hashCode() {
            AstType astType = this.element;
            List<Pair<String, AstType>> list = this.types;
            return (astType != null ? astType.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GENERIC_DESCRIPTOR)) break block3;
                    GENERIC_DESCRIPTOR gENERIC_DESCRIPTOR = (GENERIC_DESCRIPTOR)object;
                    if (!Intrinsics.areEqual((Object)this.element, (Object)gENERIC_DESCRIPTOR.element) || !Intrinsics.areEqual(this.types, gENERIC_DESCRIPTOR.types)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lcom/jtransc/ast/AstType$GENERIC_LOWER_BOUND;", "Lcom/jtransc/ast/AstType;", "element", "(Lcom/jtransc/ast/AstType;)V", "getElement", "()Lcom/jtransc/ast/AstType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jtransc-core_main"})
    public static final class GENERIC_LOWER_BOUND
    extends AstType {
        @NotNull
        private final AstType element;

        @NotNull
        public final AstType getElement() {
            return this.element;
        }

        public GENERIC_LOWER_BOUND(@NotNull AstType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.element = element;
        }

        @NotNull
        public final AstType component1() {
            return this.element;
        }

        @NotNull
        public final GENERIC_LOWER_BOUND copy(@NotNull AstType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return new GENERIC_LOWER_BOUND(element);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ GENERIC_LOWER_BOUND copy$default(GENERIC_LOWER_BOUND gENERIC_LOWER_BOUND, AstType astType, int n, Object object) {
            if ((n & 1) != 0) {
                astType = gENERIC_LOWER_BOUND.element;
            }
            return gENERIC_LOWER_BOUND.copy(astType);
        }

        public String toString() {
            return "GENERIC_LOWER_BOUND(element=" + this.element + ")";
        }

        public int hashCode() {
            AstType astType = this.element;
            return astType != null ? astType.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GENERIC_LOWER_BOUND)) break block3;
                    GENERIC_LOWER_BOUND gENERIC_LOWER_BOUND = (GENERIC_LOWER_BOUND)object;
                    if (!Intrinsics.areEqual((Object)this.element, (Object)gENERIC_LOWER_BOUND.element)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lcom/jtransc/ast/AstType$GENERIC_UPPER_BOUND;", "Lcom/jtransc/ast/AstType;", "element", "(Lcom/jtransc/ast/AstType;)V", "getElement", "()Lcom/jtransc/ast/AstType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jtransc-core_main"})
    public static final class GENERIC_UPPER_BOUND
    extends AstType {
        @NotNull
        private final AstType element;

        @NotNull
        public final AstType getElement() {
            return this.element;
        }

        public GENERIC_UPPER_BOUND(@NotNull AstType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.element = element;
        }

        @NotNull
        public final AstType component1() {
            return this.element;
        }

        @NotNull
        public final GENERIC_UPPER_BOUND copy(@NotNull AstType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return new GENERIC_UPPER_BOUND(element);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ GENERIC_UPPER_BOUND copy$default(GENERIC_UPPER_BOUND gENERIC_UPPER_BOUND, AstType astType, int n, Object object) {
            if ((n & 1) != 0) {
                astType = gENERIC_UPPER_BOUND.element;
            }
            return gENERIC_UPPER_BOUND.copy(astType);
        }

        public String toString() {
            return "GENERIC_UPPER_BOUND(element=" + this.element + ")";
        }

        public int hashCode() {
            AstType astType = this.element;
            return astType != null ? astType.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GENERIC_UPPER_BOUND)) break block3;
                    GENERIC_UPPER_BOUND gENERIC_UPPER_BOUND = (GENERIC_UPPER_BOUND)object;
                    if (!Intrinsics.areEqual((Object)this.element, (Object)gENERIC_UPPER_BOUND.element)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b)\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\bB9\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u000bB?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\f\"\u00020\n\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\rB?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f\"\u00020\u0001\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u000eB?\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0011J\t\u00106\u001a\u00020\u0001H\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\n0\u0004H\u00c6\u0003J\t\u00108\u001a\u00020\u0010H\u00c6\u0003J\u001b\u00109\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004H\u00c6\u0003JI\u0010:\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004H\u00c6\u0001J\u0013\u0010;\u001a\u00020\u00102\b\u0010<\u001a\u0004\u0018\u00010=H\u0096\u0002J\b\u0010>\u001a\u00020\u0013H\u0016J\b\u0010?\u001a\u00020\u0007H\u0016R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001a\u001a\u0004\b\u001b\u0010\u0018R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001a\u001a\u0004\b\u001f\u0010\u0018R!\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001a\u001a\u0004\b\"\u0010\u0018R\u001b\u0010$\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001a\u001a\u0004\b%\u0010&R\u001b\u0010(\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u001a\u001a\u0004\b)\u0010&R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001b\u00100\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u001a\u001a\u0004\b1\u0010,R\u0011\u00103\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006@"}, d2={"Lcom/jtransc/ast/AstType$METHOD;", "Lcom/jtransc/ast/AstType;", "ret", "argTypes", "", "paramTypes", "Lkotlin/Pair;", "", "(Lcom/jtransc/ast/AstType;Ljava/util/List;Ljava/util/List;)V", "args", "Lcom/jtransc/ast/AstArgument;", "(Ljava/util/List;Lcom/jtransc/ast/AstType;Ljava/util/List;)V", "", "(Lcom/jtransc/ast/AstType;[Lcom/jtransc/ast/AstArgument;Ljava/util/List;)V", "(Lcom/jtransc/ast/AstType;[Lcom/jtransc/ast/AstType;Ljava/util/List;)V", "dummy", "", "(Lcom/jtransc/ast/AstType;Ljava/util/List;ZLjava/util/List;)V", "argCount", "", "getArgCount", "()I", "argNames", "getArgNames", "()Ljava/util/List;", "argNames$delegate", "Lkotlin/Lazy;", "getArgTypes", "argTypes$delegate", "getArgs", "argsPlusReturn", "getArgsPlusReturn", "argsPlusReturn$delegate", "argsPlusReturnVoidIsEmpty", "getArgsPlusReturnVoidIsEmpty", "argsPlusReturnVoidIsEmpty$delegate", "desc", "getDesc", "()Ljava/lang/String;", "desc$delegate", "desc2", "getDesc2", "desc2$delegate", "getDummy", "()Z", "getParamTypes", "getRet", "()Lcom/jtransc/ast/AstType;", "retVoid", "getRetVoid", "retVoid$delegate", "withoutRetval", "getWithoutRetval", "()Lcom/jtransc/ast/AstType$METHOD;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "jtransc-core_main"})
    public static final class METHOD
    extends AstType {
        @NotNull
        private final Lazy argNames$delegate;
        @NotNull
        private final Lazy argTypes$delegate;
        @NotNull
        private final Lazy desc$delegate;
        @NotNull
        private final Lazy desc2$delegate;
        @NotNull
        private final Lazy retVoid$delegate;
        @NotNull
        private final Lazy argsPlusReturn$delegate;
        @NotNull
        private final Lazy argsPlusReturnVoidIsEmpty$delegate;
        @NotNull
        private final AstType ret;
        @NotNull
        private final List<AstArgument> args;
        private final boolean dummy;
        @NotNull
        private final List<Pair<String, AstType>> paramTypes;
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        public final int getArgCount() {
            return this.getArgTypes().size();
        }

        @NotNull
        public final List<String> getArgNames() {
            Lazy lazy = this.argNames$delegate;
            METHOD mETHOD = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<AstType> getArgTypes() {
            Lazy lazy = this.argTypes$delegate;
            METHOD mETHOD = this;
            KProperty kProperty = $$delegatedProperties[1];
            return (List)lazy.getValue();
        }

        @NotNull
        public final String getDesc() {
            Lazy lazy = this.desc$delegate;
            METHOD mETHOD = this;
            KProperty kProperty = $$delegatedProperties[2];
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getDesc2() {
            Lazy lazy = this.desc2$delegate;
            METHOD mETHOD = this;
            KProperty kProperty = $$delegatedProperties[3];
            return (String)lazy.getValue();
        }

        public final boolean getRetVoid() {
            Lazy lazy = this.retVoid$delegate;
            METHOD mETHOD = this;
            KProperty kProperty = $$delegatedProperties[4];
            return (Boolean)lazy.getValue();
        }

        @NotNull
        public final List<AstType> getArgsPlusReturn() {
            Lazy lazy = this.argsPlusReturn$delegate;
            METHOD mETHOD = this;
            KProperty kProperty = $$delegatedProperties[5];
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<AstType> getArgsPlusReturnVoidIsEmpty() {
            Lazy lazy = this.argsPlusReturnVoidIsEmpty$delegate;
            METHOD mETHOD = this;
            KProperty kProperty = $$delegatedProperties[6];
            return (List)lazy.getValue();
        }

        @NotNull
        public final METHOD getWithoutRetval() {
            return new METHOD((AstType)new UNKNOWN("No retval"), this.getArgTypes(), this.paramTypes);
        }

        public int hashCode() {
            return this.getDesc().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            METHOD mETHOD = (METHOD)other;
            return Objects.equals(this.getDesc(), mETHOD != null ? mETHOD.getDesc() : null);
        }

        @NotNull
        public String toString() {
            return this.ret.toString() + " (" + CollectionsKt.joinToString$default((Iterable)this.args, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
        }

        @NotNull
        public final AstType getRet() {
            return this.ret;
        }

        @NotNull
        public final List<AstArgument> getArgs() {
            return this.args;
        }

        public final boolean getDummy() {
            return this.dummy;
        }

        @NotNull
        public final List<Pair<String, AstType>> getParamTypes() {
            return this.paramTypes;
        }

        public METHOD(@NotNull AstType ret, @NotNull List<AstArgument> args, boolean dummy, @NotNull List<? extends Pair<String, ? extends AstType>> paramTypes) {
            Intrinsics.checkParameterIsNotNull((Object)ret, (String)"ret");
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            Intrinsics.checkParameterIsNotNull(paramTypes, (String)"paramTypes");
            this.ret = ret;
            this.args = args;
            this.dummy = dummy;
            this.paramTypes = paramTypes;
            this.argNames$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
                final /* synthetic */ METHOD this$0;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<String> invoke() {
                    void var3_3;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)this.this$0.getArgs();
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        AstArgument astArgument = (AstArgument)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        String string = it.getName();
                        collection.add(string);
                    }
                    return (List)var3_3;
                }
                {
                    this.this$0 = mETHOD;
                    super(0);
                }
            }));
            this.argTypes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends AstType>>(this){
                final /* synthetic */ METHOD this$0;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AstType> invoke() {
                    void var3_3;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)this.this$0.getArgs();
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        AstArgument astArgument = (AstArgument)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        AstType astType = it.getType();
                        collection.add(astType);
                    }
                    return (List)var3_3;
                }
                {
                    this.this$0 = mETHOD;
                    super(0);
                }
            }));
            this.desc$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ METHOD this$0;

                @NotNull
                public final String invoke() {
                    return Ast_typeKt.mangle(this.this$0, true);
                }
                {
                    this.this$0 = mETHOD;
                    super(0);
                }
            }));
            this.desc2$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ METHOD this$0;

                @NotNull
                public final String invoke() {
                    return Ast_typeKt.mangle(this.this$0, false);
                }
                {
                    this.this$0 = mETHOD;
                    super(0);
                }
            }));
            this.retVoid$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ METHOD this$0;

                public final boolean invoke() {
                    return Intrinsics.areEqual((Object)this.this$0.getRet(), (Object)VOID.INSTANCE);
                }
                {
                    this.this$0 = mETHOD;
                    super(0);
                }
            }));
            this.argsPlusReturn$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends AstType>>(this){
                final /* synthetic */ METHOD this$0;

                @NotNull
                public final List<AstType> invoke() {
                    return CollectionsKt.plus((Collection)this.this$0.getArgTypes(), (Iterable)CollectionsKt.listOf((Object)this.this$0.getRet()));
                }
                {
                    this.this$0 = mETHOD;
                    super(0);
                }
            }));
            this.argsPlusReturnVoidIsEmpty$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends AstType>>(this){
                final /* synthetic */ METHOD this$0;

                @NotNull
                public final List<AstType> invoke() {
                    return this.this$0.getArgTypes().isEmpty() ? CollectionsKt.listOf((Object[])new AstType[]{VOID.INSTANCE, this.this$0.getRet()}) : CollectionsKt.plus((Collection)this.this$0.getArgTypes(), (Iterable)CollectionsKt.listOf((Object)this.this$0.getRet()));
                }
                {
                    this.this$0 = mETHOD;
                    super(0);
                }
            }));
        }

        public /* synthetic */ METHOD(AstType astType, List list, boolean bl, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(astType, list, bl, list2);
        }

        public METHOD(@NotNull AstType ret, @NotNull List<? extends AstType> argTypes2, @NotNull List<? extends Pair<String, ? extends AstType>> paramTypes) {
            Intrinsics.checkParameterIsNotNull((Object)ret, (String)"ret");
            Intrinsics.checkParameterIsNotNull(argTypes2, (String)"argTypes");
            Intrinsics.checkParameterIsNotNull(paramTypes, (String)"paramTypes");
            this(ret, Ast_typeKt.toArguments((Iterable<? extends AstType>)argTypes2), true, paramTypes);
        }

        public /* synthetic */ METHOD(AstType astType, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(astType, list, (List<? extends Pair<String, ? extends AstType>>)list2);
        }

        public METHOD(@NotNull List<AstArgument> args, @NotNull AstType ret, @NotNull List<? extends Pair<String, ? extends AstType>> paramTypes) {
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            Intrinsics.checkParameterIsNotNull((Object)ret, (String)"ret");
            Intrinsics.checkParameterIsNotNull(paramTypes, (String)"paramTypes");
            this(ret, args, true, paramTypes);
        }

        public /* synthetic */ METHOD(List list, AstType astType, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list, astType, (List<? extends Pair<String, ? extends AstType>>)list2);
        }

        public METHOD(@NotNull AstType ret, @NotNull AstArgument[] args, @NotNull List<? extends Pair<String, ? extends AstType>> paramTypes) {
            Intrinsics.checkParameterIsNotNull((Object)ret, (String)"ret");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Intrinsics.checkParameterIsNotNull(paramTypes, (String)"paramTypes");
            this(ret, ArraysKt.toList((Object[])args), true, paramTypes);
        }

        public /* synthetic */ METHOD(AstType astType, AstArgument[] astArgumentArray, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(astType, astArgumentArray, (List<? extends Pair<String, ? extends AstType>>)list);
        }

        /*
         * WARNING - void declaration
         */
        public METHOD(@NotNull AstType ret, @NotNull AstType[] args, @NotNull List<? extends Pair<String, ? extends AstType>> paramTypes) {
            Collection<AstArgument> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)ret, (String)"ret");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Intrinsics.checkParameterIsNotNull(paramTypes, (String)"paramTypes");
            Iterable iterable = ArraysKt.withIndex((Object[])args);
            METHOD mETHOD = this;
            void var5_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                collection = destination$iv$iv;
                AstArgument astArgument = new AstArgument(it.getIndex(), (AstType)it.getValue(), null, false, 12, null);
                collection.add(astArgument);
            }
            collection = (List)destination$iv$iv;
            mETHOD((List<AstArgument>)collection, ret, paramTypes);
        }

        public /* synthetic */ METHOD(AstType astType, AstType[] astTypeArray, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(astType, astTypeArray, (List<? extends Pair<String, ? extends AstType>>)list);
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(METHOD.class), "argNames", "getArgNames()Ljava/util/List;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(METHOD.class), "argTypes", "getArgTypes()Ljava/util/List;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(METHOD.class), "desc", "getDesc()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(METHOD.class), "desc2", "getDesc2()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(METHOD.class), "retVoid", "getRetVoid()Z")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(METHOD.class), "argsPlusReturn", "getArgsPlusReturn()Ljava/util/List;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(METHOD.class), "argsPlusReturnVoidIsEmpty", "getArgsPlusReturnVoidIsEmpty()Ljava/util/List;"))};
        }

        @NotNull
        public final AstType component1() {
            return this.ret;
        }

        @NotNull
        public final List<AstArgument> component2() {
            return this.args;
        }

        public final boolean component3() {
            return this.dummy;
        }

        @NotNull
        public final List<Pair<String, AstType>> component4() {
            return this.paramTypes;
        }

        @NotNull
        public final METHOD copy(@NotNull AstType ret, @NotNull List<AstArgument> args, boolean dummy, @NotNull List<? extends Pair<String, ? extends AstType>> paramTypes) {
            Intrinsics.checkParameterIsNotNull((Object)ret, (String)"ret");
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            Intrinsics.checkParameterIsNotNull(paramTypes, (String)"paramTypes");
            return new METHOD(ret, args, dummy, paramTypes);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ METHOD copy$default(METHOD mETHOD, AstType astType, List list, boolean bl, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                astType = mETHOD.ret;
            }
            if ((n & 2) != 0) {
                list = mETHOD.args;
            }
            if ((n & 4) != 0) {
                bl = mETHOD.dummy;
            }
            if ((n & 8) != 0) {
                list2 = mETHOD.paramTypes;
            }
            return mETHOD.copy(astType, list, bl, list2);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jtransc/ast/AstType$Companion;", "", "()V", "CLASS", "Lcom/jtransc/ast/AstType$REF;", "getCLASS", "()Lcom/jtransc/ast/AstType$REF;", "OBJECT", "getOBJECT", "STRING", "getSTRING", "STRINGBUILDER", "getSTRINGBUILDER", "THROWABLE", "getTHROWABLE", "fromConstant", "Lcom/jtransc/ast/AstType;", "value", "jtransc-core_main"})
    public static final class Companion {
        @NotNull
        public final REF getTHROWABLE() {
            return THROWABLE;
        }

        @NotNull
        public final REF getSTRING() {
            return STRING;
        }

        @NotNull
        public final REF getSTRINGBUILDER() {
            return STRINGBUILDER;
        }

        @NotNull
        public final REF getOBJECT() {
            return OBJECT;
        }

        @NotNull
        public final REF getCLASS() {
            return CLASS;
        }

        @NotNull
        public final AstType fromConstant(@Nullable Object value) {
            AstType astType;
            Object object = value;
            if (Intrinsics.areEqual((Object)object, null)) {
                astType = NULL.INSTANCE;
            } else if (object instanceof Boolean) {
                astType = BOOL.INSTANCE;
            } else if (object instanceof Byte) {
                astType = BYTE.INSTANCE;
            } else if (object instanceof Character) {
                astType = CHAR.INSTANCE;
            } else if (object instanceof Short) {
                astType = SHORT.INSTANCE;
            } else if (object instanceof Integer) {
                astType = INT.INSTANCE;
            } else if (object instanceof Long) {
                astType = LONG.INSTANCE;
            } else if (object instanceof Float) {
                astType = FLOAT.INSTANCE;
            } else if (object instanceof Double) {
                astType = DOUBLE.INSTANCE;
            } else if (object instanceof String) {
                astType = Companion.getSTRING();
            } else if (object instanceof ARRAY) {
                astType = Companion.getCLASS();
            } else if (object instanceof REF) {
                astType = Companion.getCLASS();
            } else if (object instanceof METHOD) {
                astType = Companion.getCLASS();
            } else if (object instanceof AstMethodHandle) {
                astType = Companion.getCLASS();
            } else {
                Void void_ = ErrorsKt.invalidOp$default((String)("Literal type: " + value.getClass() + " : " + value), null, (int)2, null);
                throw null;
            }
            return astType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

