/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.ast;

import com.jtransc.ast.AstType;
import com.jtransc.ast.AstTypeBuilder;
import com.jtransc.ast.Ast_typeKt;
import com.jtransc.error.ErrorsKt;
import com.jtransc.error.InvalidOperationException;
import com.jtransc.injector.Singleton;
import com.jtransc.text.ReaderKt;
import com.jtransc.text.StrReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J.\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00062\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jtransc/ast/AstTypes;", "", "()V", "AstTypeDemangleCache", "Ljava/util/HashMap;", "", "Lcom/jtransc/ast/AstType;", "Lkotlin/collections/HashMap;", "ARRAY", "Lcom/jtransc/ast/AstType$ARRAY;", "element", "count", "", "REF_INT", "internalName", "REF_INT2", "Lcom/jtransc/ast/AstType$REF;", "REF_INT3", "build", "T", "init", "Lkotlin/Function1;", "Lcom/jtransc/ast/AstTypeBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Lcom/jtransc/ast/AstType;", "demangle", "desc", "demangleMethod", "Lcom/jtransc/ast/AstType$METHOD;", "text", "fromConstant", "value", "readOne", "reader", "Lcom/jtransc/text/StrReader;", "unify", "a", "b", "jtransc-core_main"})
public final class AstTypes {
    private final HashMap<String, AstType> AstTypeDemangleCache;

    @NotNull
    public final AstType fromConstant(@Nullable Object value) {
        return AstType.Companion.fromConstant(value);
    }

    @NotNull
    public final AstType.ARRAY ARRAY(@NotNull AstType element, int count) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return count <= 1 ? new AstType.ARRAY(element) : this.ARRAY(new AstType.ARRAY(element), count - 1);
    }

    @NotNull
    public final AstType REF_INT(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
        return StringsKt.startsWith$default((String)internalName, (String)"[", (boolean)false, (int)2, null) ? this.demangle(internalName) : (AstType)this.REF_INT2(internalName);
    }

    @NotNull
    public final AstType.REF REF_INT2(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
        return new AstType.REF(StringsKt.replace$default((String)internalName, (char)'/', (char)'.', (boolean)false, (int)4, null));
    }

    @Nullable
    public final AstType.REF REF_INT3(@Nullable String internalName) {
        return internalName != null ? this.REF_INT2(internalName) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AstType demangle(@NotNull String desc3) {
        AstType astType;
        Intrinsics.checkParameterIsNotNull((Object)desc3, (String)"desc");
        Map $receiver$iv = this.AstTypeDemangleCache;
        Object value$iv = $receiver$iv.get(desc3);
        if (value$iv == null) {
            AstType answer$iv = this.readOne(new StrReader(desc3, 0, 2, null));
            $receiver$iv.put(desc3, answer$iv);
            astType = answer$iv;
        } else {
            void var3_3;
            astType = var3_3;
        }
        return astType;
    }

    @NotNull
    public final AstType.METHOD demangleMethod(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        AstType astType = this.demangle(text);
        if (astType == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jtransc.ast.AstType.METHOD");
        }
        return (AstType.METHOD)astType;
    }

    @NotNull
    public final <T extends AstType> T build(@NotNull Function1<? super AstTypeBuilder, ? extends T> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        return (T)((AstType)init.invoke((Object)AstTypeBuilder.INSTANCE));
    }

    @NotNull
    public final AstType unify(@NotNull AstType a, @NotNull AstType b) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        return a;
    }

    @NotNull
    public final AstType readOne(@NotNull StrReader reader) {
        AstType astType;
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        if (reader.getEof()) {
            return new AstType.UNKNOWN("demangling eof");
        }
        char typech = reader.readch();
        switch (typech) {
            case 'V': {
                astType = AstType.VOID.INSTANCE;
                break;
            }
            case 'Z': {
                astType = AstType.BOOL.INSTANCE;
                break;
            }
            case 'B': {
                astType = AstType.BYTE.INSTANCE;
                break;
            }
            case 'C': {
                astType = AstType.CHAR.INSTANCE;
                break;
            }
            case 'S': {
                astType = AstType.SHORT.INSTANCE;
                break;
            }
            case 'D': {
                astType = AstType.DOUBLE.INSTANCE;
                break;
            }
            case 'F': {
                astType = AstType.FLOAT.INSTANCE;
                break;
            }
            case 'I': {
                astType = AstType.INT.INSTANCE;
                break;
            }
            case 'J': {
                astType = AstType.LONG.INSTANCE;
                break;
            }
            case '[': {
                astType = new AstType.ARRAY(this.readOne(reader));
                break;
            }
            case '*': {
                astType = AstType.GENERIC_STAR.INSTANCE;
                break;
            }
            case '-': {
                astType = new AstType.GENERIC_LOWER_BOUND(this.readOne(reader));
                break;
            }
            case '+': {
                astType = new AstType.GENERIC_UPPER_BOUND(this.readOne(reader));
                break;
            }
            case 'T': {
                String id = ReaderKt.readUntil((StrReader)reader, Ast_typeKt.getT_DELIMITER(), (boolean)false, (boolean)true);
                astType = new AstType.TYPE_PARAMETER(id);
                break;
            }
            case 'L': {
                AstType.Reference reference;
                String base = ReaderKt.readUntil((StrReader)reader, Ast_typeKt.getREF_DELIMITER(), (boolean)false, (boolean)false);
                char delim = reader.readch();
                AstType.REF ref = new AstType.REF(StringsKt.replace$default((String)base, (char)'/', (char)'.', (boolean)false, (int)4, null));
                switch (delim) {
                    case ';': {
                        reference = ref;
                        break;
                    }
                    case '<': {
                        int index = 0;
                        ArrayList suffixes = new ArrayList();
                        block31: while (reader.getHasMore()) {
                            Object object;
                            String string;
                            char ch;
                            if (reader.peekch() == '.') {
                                reader.readch();
                                String id = ReaderKt.readUntil((StrReader)reader, Ast_typeKt.getREF_DELIMITER(), (boolean)false, (boolean)false);
                                ch = reader.readch();
                                switch (ch) {
                                    case '<': {
                                        string = id;
                                        break;
                                    }
                                    case ';': {
                                        object = suffixes;
                                        AstType.GENERIC_SUFFIX gENERIC_SUFFIX = new AstType.GENERIC_SUFFIX(id, null);
                                        object.add(gENERIC_SUFFIX);
                                        break block31;
                                    }
                                    default: {
                                        Void void_ = ErrorsKt.invalidOp$default((String)("Expected > or ; but found " + ch + " on reader " + reader), null, (int)2, null);
                                        throw null;
                                    }
                                }
                            } else {
                                string = null;
                            }
                            String id = string;
                            ArrayList<AstType> generic = new ArrayList<AstType>();
                            while (reader.getHasMore()) {
                                ch = reader.peekch();
                                if (ch == '>') {
                                    reader.expect(">");
                                    switch (reader.peekch()) {
                                        case '.': {
                                            break;
                                        }
                                        case ';': {
                                            break;
                                        }
                                    }
                                    break;
                                }
                                generic.add(this.readOne(reader));
                            }
                            ++index;
                            Collection collection = suffixes;
                            object = new AstType.GENERIC_SUFFIX(id, (List<? extends AstType>)generic);
                            collection.add(object);
                            if (reader.peekch() != ';') continue;
                            reader.expect(";");
                            break;
                        }
                        reference = new AstType.GENERIC(ref, suffixes, true);
                        break;
                    }
                    default: {
                        throw (Throwable)new InvalidOperationException(null, null, 3, null);
                    }
                }
                astType = reference;
                break;
            }
            case '<': {
                ArrayList types = new ArrayList();
                while (reader.peekch() != '>') {
                    String id = ReaderKt.readUntil((StrReader)reader, Ast_typeKt.getTYPE_DELIMITER(), (boolean)false, (boolean)false);
                    reader.expect(":");
                    if (reader.peekch() == ':') {
                        reader.readch();
                    }
                    Collection collection = types;
                    Pair pair = new Pair((Object)id, (Object)this.readOne(reader));
                    collection.add(pair);
                }
                reader.expect(">");
                AstType item = this.readOne(reader);
                if (item instanceof AstType.METHOD) {
                    astType = new AstType.METHOD(((AstType.METHOD)item).getRet(), ((AstType.METHOD)item).getArgTypes(), (List<? extends Pair<String, ? extends AstType>>)types);
                    break;
                }
                astType = new AstType.GENERIC_DESCRIPTOR(item, types);
                break;
            }
            case '(': {
                boolean item;
                ArrayList<AstType> args = new ArrayList<AstType>();
                while (reader.peekch() != ')') {
                    args.add(this.readOne(reader));
                }
                boolean bl = item = reader.readch() == ')';
                if (_Assertions.ENABLED && !item) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                AstType ret = this.readOne(reader);
                astType = new AstType.METHOD(ret, args, null, 4, null);
                break;
            }
            default: {
                throw (Throwable)new NotImplementedError("Not implemented type '" + typech + "' @ " + reader);
            }
        }
        return astType;
    }

    public AstTypes() {
        AstTypes astTypes = this;
        HashMap hashMap = new HashMap();
        astTypes.AstTypeDemangleCache = hashMap;
    }
}

