/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.ast.dependency;

import com.jtransc.ast.AstBody;
import com.jtransc.ast.AstExpr;
import com.jtransc.ast.AstFieldRef;
import com.jtransc.ast.AstKt;
import com.jtransc.ast.AstLocal;
import com.jtransc.ast.AstMethodHandle;
import com.jtransc.ast.AstMethodRef;
import com.jtransc.ast.AstProgram;
import com.jtransc.ast.AstRef;
import com.jtransc.ast.AstReferences;
import com.jtransc.ast.AstStm;
import com.jtransc.ast.AstTrap;
import com.jtransc.ast.AstType;
import com.jtransc.ast.Ast_typeKt;
import com.jtransc.ast.FqName;
import com.jtransc.error.ErrorsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\f"}, d2={"Lcom/jtransc/ast/dependency/AstDependencyAnalyzer;", "", "()V", "analyze", "Lcom/jtransc/ast/AstReferences;", "program", "Lcom/jtransc/ast/AstProgram;", "body", "Lcom/jtransc/ast/AstBody;", "name", "", "AstDependencyAnalyzerGen", "jtransc-core_main"})
public final class AstDependencyAnalyzer {
    public static final AstDependencyAnalyzer INSTANCE;

    @JvmStatic
    @NotNull
    public static final AstReferences analyze(@NotNull AstProgram program, @Nullable AstBody body, @Nullable String name) {
        Intrinsics.checkParameterIsNotNull((Object)program, (String)"program");
        return new AstDependencyAnalyzerGen(program, body, name).getReferences();
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ AstReferences analyze$default(AstProgram astProgram, AstBody astBody, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return AstDependencyAnalyzer.analyze(astProgram, astBody, string);
    }

    private AstDependencyAnalyzer() {
        INSTANCE = this;
    }

    static {
        new AstDependencyAnalyzer();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010%J\u000e\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0018J\u0010\u0010!\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010)J\u0010\u0010!\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010*J\u000e\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020,J\u0014\u0010!\u001a\u00020\"2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020,0-R!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0012j\b\u0012\u0004\u0012\u00020\u0018`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u0012j\b\u0012\u0004\u0012\u00020\u001f`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016\u00a8\u0006."}, d2={"Lcom/jtransc/ast/dependency/AstDependencyAnalyzer$AstDependencyAnalyzerGen;", "", "program", "Lcom/jtransc/ast/AstProgram;", "body", "Lcom/jtransc/ast/AstBody;", "name", "", "(Lcom/jtransc/ast/AstProgram;Lcom/jtransc/ast/AstBody;Ljava/lang/String;)V", "allSortedRefs", "Ljava/util/LinkedHashSet;", "Lcom/jtransc/ast/AstRef;", "Lkotlin/collections/LinkedHashSet;", "getAllSortedRefs", "()Ljava/util/LinkedHashSet;", "allSortedRefsStaticInit", "getAllSortedRefsStaticInit", "fields", "Ljava/util/HashSet;", "Lcom/jtransc/ast/AstFieldRef;", "Lkotlin/collections/HashSet;", "getFields", "()Ljava/util/HashSet;", "methods", "Lcom/jtransc/ast/AstMethodRef;", "getMethods", "references", "Lcom/jtransc/ast/AstReferences;", "getReferences", "()Lcom/jtransc/ast/AstReferences;", "types", "Lcom/jtransc/ast/FqName;", "getTypes", "ana", "", "expr", "Lcom/jtransc/ast/AstExpr$Box;", "Lcom/jtransc/ast/AstExpr;", "field", "method", "stm", "Lcom/jtransc/ast/AstStm$Box;", "Lcom/jtransc/ast/AstStm;", "type", "Lcom/jtransc/ast/AstType;", "", "jtransc-core_main"})
    private static final class AstDependencyAnalyzerGen {
        @NotNull
        private final LinkedHashSet<AstRef> allSortedRefs;
        @NotNull
        private final LinkedHashSet<AstRef> allSortedRefsStaticInit;
        @NotNull
        private final HashSet<FqName> types;
        @NotNull
        private final HashSet<AstFieldRef> fields;
        @NotNull
        private final HashSet<AstMethodRef> methods;
        @NotNull
        private final AstReferences references;

        @NotNull
        public final LinkedHashSet<AstRef> getAllSortedRefs() {
            return this.allSortedRefs;
        }

        @NotNull
        public final LinkedHashSet<AstRef> getAllSortedRefsStaticInit() {
            return this.allSortedRefsStaticInit;
        }

        @NotNull
        public final HashSet<FqName> getTypes() {
            return this.types;
        }

        @NotNull
        public final HashSet<AstFieldRef> getFields() {
            return this.fields;
        }

        @NotNull
        public final HashSet<AstMethodRef> getMethods() {
            return this.methods;
        }

        public final void ana(@NotNull AstMethodRef method2) {
            Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method");
            this.allSortedRefs.add(method2);
            this.methods.add(method2);
        }

        public final void ana(@NotNull AstFieldRef field) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            this.allSortedRefs.add(field);
            this.fields.add(field);
        }

        public final void ana(@NotNull AstType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            this.allSortedRefs.addAll((Collection<AstRef>)Ast_typeKt.getRefTypes(type2));
            this.types.addAll((Collection<FqName>)Ast_typeKt.getRefTypesFqName(type2));
        }

        public final void ana(@NotNull List<? extends AstType> types) {
            Intrinsics.checkParameterIsNotNull(types, (String)"types");
            Iterable $receiver$iv = types;
            for (Object element$iv : $receiver$iv) {
                AstType it = (AstType)element$iv;
                this.ana(it);
            }
        }

        public final void ana(@Nullable AstExpr.Box expr) {
            AstExpr.Box box = expr;
            this.ana(box != null ? box.getValue() : null);
        }

        public final void ana(@Nullable AstStm.Box stm) {
            AstStm.Box box = stm;
            this.ana(box != null ? box.getValue() : null);
        }

        public final void ana(@Nullable AstExpr expr) {
            if (expr == null) {
                return;
            }
            AstExpr astExpr = expr;
            if (astExpr instanceof AstExpr.CAST) {
                this.ana(((AstExpr.CAST)expr).getFrom());
                this.ana(((AstExpr.CAST)expr).getTo());
                this.ana(((AstExpr.CAST)expr).getSubject());
            } else if (astExpr instanceof AstExpr.NEW) {
                this.ana(((AstExpr.NEW)expr).getTarget());
                Collection collection = this.allSortedRefsStaticInit;
                AstType.REF rEF = ((AstExpr.NEW)expr).getTarget();
                collection.add(rEF);
            } else if (astExpr instanceof AstExpr.NEW_ARRAY) {
                for (AstExpr.Box box : ((AstExpr.NEW_ARRAY)expr).getCounts()) {
                    this.ana(box);
                }
                this.ana(((AstExpr.NEW_ARRAY)expr).getArrayType());
                Collection collection = this.allSortedRefsStaticInit;
                Iterable object = AstKt.getRefClasses(((AstExpr.NEW_ARRAY)expr).getArrayType());
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            } else if (astExpr instanceof AstExpr.INTARRAY_LITERAL) {
                this.ana(((AstExpr.INTARRAY_LITERAL)expr).getArrayType());
            } else if (astExpr instanceof AstExpr.STRINGARRAY_LITERAL) {
                this.ana(((AstExpr.STRINGARRAY_LITERAL)expr).getArrayType());
                Collection collection = this.allSortedRefsStaticInit;
                AstType.REF astMethodRef = AstType.Companion.getSTRING();
                collection.add(astMethodRef);
            } else if (astExpr instanceof AstExpr.ARRAY_ACCESS) {
                this.ana(expr.getType());
                this.ana(((AstExpr.ARRAY_ACCESS)expr).getArray());
                this.ana(((AstExpr.ARRAY_ACCESS)expr).getIndex());
            } else if (astExpr instanceof AstExpr.ARRAY_LENGTH) {
                this.ana(((AstExpr.ARRAY_LENGTH)expr).getArray());
            } else if (astExpr instanceof AstExpr.TERNARY) {
                this.ana(((AstExpr.TERNARY)expr).getCond());
                this.ana(((AstExpr.TERNARY)expr).getEtrue());
                this.ana(((AstExpr.TERNARY)expr).getEfalse());
            } else if (astExpr instanceof AstExpr.BINOP) {
                this.ana(((AstExpr.BINOP)expr).getLeft());
                this.ana(((AstExpr.BINOP)expr).getRight());
            } else if (astExpr instanceof AstExpr.CALL_BASE) {
                this.ana(((AstExpr.CALL_BASE)expr).getMethod().getType());
                for (AstExpr.Box box : ((AstExpr.CALL_BASE)expr).getArgs()) {
                    this.ana(box);
                }
                this.ana(((AstExpr.CALL_BASE)expr).getMethod());
                if (expr instanceof AstExpr.CALL_STATIC) {
                    this.ana(((AstExpr.CALL_STATIC)expr).getClazz());
                }
                if (expr instanceof AstExpr.CALL_INSTANCE) {
                    this.ana(((AstExpr.CALL_INSTANCE)expr).getObj());
                }
                if (expr instanceof AstExpr.CALL_SUPER) {
                    this.ana(((AstExpr.CALL_SUPER)expr).getObj());
                }
                Collection collection = this.allSortedRefsStaticInit;
                AstMethodRef rEF = ((AstExpr.CALL_BASE)expr).getMethod();
                collection.add(rEF);
            } else if (astExpr instanceof AstExpr.CAUGHT_EXCEPTION) {
                this.ana(expr.getType());
            } else if (astExpr instanceof AstExpr.FIELD_INSTANCE_ACCESS) {
                this.ana(((AstExpr.FIELD_INSTANCE_ACCESS)expr).getExpr());
                this.ana(((AstExpr.FIELD_INSTANCE_ACCESS)expr).getField());
            } else if (astExpr instanceof AstExpr.FIELD_STATIC_ACCESS) {
                this.ana(((AstExpr.FIELD_STATIC_ACCESS)expr).getClazzName());
                this.ana(((AstExpr.FIELD_STATIC_ACCESS)expr).getField());
                Collection collection = this.allSortedRefsStaticInit;
                AstType.REF rEF = ((AstExpr.FIELD_STATIC_ACCESS)expr).getField().getContainingTypeRef();
                collection.add(rEF);
            } else if (astExpr instanceof AstExpr.INSTANCE_OF) {
                this.ana(((AstExpr.INSTANCE_OF)expr).getExpr());
                this.ana(((AstExpr.INSTANCE_OF)expr).getCheckType());
            } else if (astExpr instanceof AstExpr.UNOP) {
                this.ana(((AstExpr.UNOP)expr).getRight());
            } else if (astExpr instanceof AstExpr.THIS) {
                this.ana(expr.getType());
            } else if (astExpr instanceof AstExpr.LITERAL) {
                Object collection = ((AstExpr.LITERAL)expr).getValue();
                Object object = collection;
                if (object instanceof AstType) {
                    this.ana((AstType)collection);
                    Collection collection2 = this.allSortedRefsStaticInit;
                    Iterable iterable = AstKt.getRefClasses((AstType)collection);
                    CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
                } else if (object instanceof AstMethodHandle) {
                    this.ana(((AstMethodHandle)collection).getType());
                    this.ana(((AstMethodHandle)collection).getMethodRef());
                    Collection collection3 = this.allSortedRefsStaticInit;
                    AstMethodRef astMethodRef = ((AstMethodHandle)collection).getMethodRef();
                    collection3.add(astMethodRef);
                }
            } else if (!(astExpr instanceof AstExpr.LOCAL) && !(astExpr instanceof AstExpr.TYPED_LOCAL)) {
                if (astExpr instanceof AstExpr.PARAM) {
                    this.ana(expr.getType());
                } else if (astExpr instanceof AstExpr.INVOKE_DYNAMIC_METHOD) {
                    this.ana(((AstExpr.INVOKE_DYNAMIC_METHOD)expr).getType());
                    this.ana(((AstExpr.INVOKE_DYNAMIC_METHOD)expr).getMethodInInterfaceRef());
                    this.ana(((AstExpr.INVOKE_DYNAMIC_METHOD)expr).getMethodToConvertRef());
                    this.ana(((AstExpr.INVOKE_DYNAMIC_METHOD)expr).getMethodInInterfaceRef().getAllClassRefs());
                    this.ana(((AstExpr.INVOKE_DYNAMIC_METHOD)expr).getMethodToConvertRef().getAllClassRefs());
                    Collection collection = this.allSortedRefsStaticInit;
                    AstMethodRef astMethodRef = ((AstExpr.INVOKE_DYNAMIC_METHOD)expr).getMethodInInterfaceRef();
                    collection.add(astMethodRef);
                    Collection collection4 = this.allSortedRefsStaticInit;
                    astMethodRef = ((AstExpr.INVOKE_DYNAMIC_METHOD)expr).getMethodToConvertRef();
                    collection4.add(astMethodRef);
                } else if (astExpr instanceof AstExpr.NEW_WITH_CONSTRUCTOR) {
                    this.ana(((AstExpr.NEW_WITH_CONSTRUCTOR)expr).getTarget());
                    this.ana(((AstExpr.NEW_WITH_CONSTRUCTOR)expr).getType());
                    this.ana(((AstExpr.NEW_WITH_CONSTRUCTOR)expr).getConstructor());
                    for (AstExpr.Box box : ((AstExpr.NEW_WITH_CONSTRUCTOR)expr).getArgs()) {
                        this.ana(box);
                    }
                    Collection collection = this.allSortedRefsStaticInit;
                    AstType.REF rEF = ((AstExpr.NEW_WITH_CONSTRUCTOR)expr).getTarget();
                    collection.add(rEF);
                } else if (astExpr instanceof AstExpr.LITERAL_REFNAME) {
                    this.ana(((AstExpr.LITERAL_REFNAME)expr).getType());
                } else {
                    Void void_ = ErrorsKt.noImpl((String)("Not implemented " + expr));
                    throw null;
                }
            }
        }

        public final void ana(@Nullable AstStm stm) {
            if (stm == null) {
                return;
            }
            AstStm astStm = stm;
            if (astStm instanceof AstStm.STMS) {
                for (AstStm.Box s : ((AstStm.STMS)stm).getStms()) {
                    this.ana(s);
                }
            } else if (astStm instanceof AstStm.STM_EXPR) {
                this.ana(((AstStm.STM_EXPR)stm).getExpr());
            } else if (!(astStm instanceof AstStm.CONTINUE || astStm instanceof AstStm.BREAK || astStm instanceof AstStm.STM_LABEL)) {
                if (astStm instanceof AstStm.IF_GOTO) {
                    this.ana(((AstStm.IF_GOTO)stm).getCond());
                } else if (!(astStm instanceof AstStm.GOTO)) {
                    if (astStm instanceof AstStm.MONITOR_ENTER) {
                        this.ana(((AstStm.MONITOR_ENTER)stm).getExpr());
                    } else if (astStm instanceof AstStm.MONITOR_EXIT) {
                        this.ana(((AstStm.MONITOR_EXIT)stm).getExpr());
                    } else if (astStm instanceof AstStm.SET_LOCAL) {
                        this.ana(((AstStm.SET_LOCAL)stm).getExpr());
                    } else if (astStm instanceof AstStm.SET_ARRAY) {
                        this.ana(((AstStm.SET_ARRAY)stm).getArray());
                        this.ana(((AstStm.SET_ARRAY)stm).getExpr());
                        this.ana(((AstStm.SET_ARRAY)stm).getIndex());
                    } else if (astStm instanceof AstStm.SET_ARRAY_LITERALS) {
                        this.ana(((AstStm.SET_ARRAY_LITERALS)stm).getArray());
                        for (AstExpr.Box v : ((AstStm.SET_ARRAY_LITERALS)stm).getValues()) {
                            this.ana(v);
                        }
                    } else if (astStm instanceof AstStm.SET_FIELD_INSTANCE) {
                        this.ana(((AstStm.SET_FIELD_INSTANCE)stm).getField());
                        this.ana(((AstStm.SET_FIELD_INSTANCE)stm).getLeft());
                        this.ana(((AstStm.SET_FIELD_INSTANCE)stm).getExpr());
                    } else if (astStm instanceof AstStm.SET_FIELD_STATIC) {
                        this.ana(((AstStm.SET_FIELD_STATIC)stm).getField());
                        this.ana(((AstStm.SET_FIELD_STATIC)stm).getExpr());
                        Collection v = this.allSortedRefsStaticInit;
                        AstType.REF rEF = ((AstStm.SET_FIELD_STATIC)stm).getField().getContainingTypeRef();
                        v.add(rEF);
                    } else if (astStm instanceof AstStm.RETURN) {
                        this.ana(((AstStm.RETURN)stm).getRetval());
                    } else if (!(astStm instanceof AstStm.RETURN_VOID)) {
                        if (astStm instanceof AstStm.IF) {
                            this.ana(((AstStm.IF)stm).getCond());
                            this.ana(((AstStm.IF)stm).getStrue());
                        } else if (astStm instanceof AstStm.IF_ELSE) {
                            this.ana(((AstStm.IF_ELSE)stm).getCond());
                            this.ana(((AstStm.IF_ELSE)stm).getStrue());
                            this.ana(((AstStm.IF_ELSE)stm).getSfalse());
                        } else if (astStm instanceof AstStm.THROW) {
                            this.ana(((AstStm.THROW)stm).getException());
                        } else if (astStm instanceof AstStm.WHILE) {
                            this.ana(((AstStm.WHILE)stm).getCond());
                            this.ana(((AstStm.WHILE)stm).getIter());
                        } else if (astStm instanceof AstStm.TRY_CATCH) {
                            this.ana(((AstStm.TRY_CATCH)stm).getTrystm());
                            this.ana(((AstStm.TRY_CATCH)stm).getCatch());
                        } else if (astStm instanceof AstStm.SWITCH_GOTO) {
                            this.ana(((AstStm.SWITCH_GOTO)stm).getSubject());
                        } else if (astStm instanceof AstStm.SWITCH) {
                            this.ana(((AstStm.SWITCH)stm).getSubject());
                            this.ana(((AstStm.SWITCH)stm).getDefault());
                            for (Pair<Integer, AstStm.Box> pair : ((AstStm.SWITCH)stm).getCases()) {
                                this.ana((AstStm.Box)pair.getSecond());
                            }
                        } else if (astStm instanceof AstStm.SET_NEW_WITH_CONSTRUCTOR) {
                            this.ana(((AstStm.SET_NEW_WITH_CONSTRUCTOR)stm).getTarget());
                            this.ana(((AstStm.SET_NEW_WITH_CONSTRUCTOR)stm).getMethod().getType());
                            for (AstExpr.Box arg : ((AstStm.SET_NEW_WITH_CONSTRUCTOR)stm).getArgs()) {
                                this.ana(arg);
                            }
                            Collection collection = this.allSortedRefsStaticInit;
                            AstMethodRef astMethodRef = ((AstStm.SET_NEW_WITH_CONSTRUCTOR)stm).getMethod();
                            collection.add(astMethodRef);
                        } else if (!(astStm instanceof AstStm.LINE) && !(astStm instanceof AstStm.NOP)) {
                            Void void_ = ErrorsKt.noImpl((String)("Not implemented STM " + stm));
                            throw null;
                        }
                    }
                }
            }
        }

        @NotNull
        public final AstReferences getReferences() {
            return this.references;
        }

        /*
         * WARNING - void declaration
         */
        public AstDependencyAnalyzerGen(@NotNull AstProgram program, @Nullable AstBody body, @Nullable String name) {
            Collection<AstType.REF> collection;
            void $receiver$iv$iv;
            AstReferences astReferences;
            Intrinsics.checkParameterIsNotNull((Object)program, (String)"program");
            AstDependencyAnalyzerGen astDependencyAnalyzerGen = this;
            Object object = new LinkedHashSet();
            astDependencyAnalyzerGen.allSortedRefs = object;
            astDependencyAnalyzerGen = this;
            object = new LinkedHashSet();
            astDependencyAnalyzerGen.allSortedRefsStaticInit = object;
            astDependencyAnalyzerGen = this;
            object = new HashSet();
            astDependencyAnalyzerGen.types = object;
            astDependencyAnalyzerGen = this;
            object = new HashSet();
            astDependencyAnalyzerGen.fields = object;
            astDependencyAnalyzerGen = this;
            object = new HashSet();
            astDependencyAnalyzerGen.methods = object;
            if (body != null) {
                for (AstLocal set3 : body.getLocals()) {
                    this.ana(set3.getType());
                }
                this.ana(body.getStm());
                for (AstTrap astTrap : body.getTraps()) {
                    this.ana(astTrap.getException());
                }
            }
            Iterable iterable = this.types;
            Set set = this.allSortedRefsStaticInit;
            Set set2 = this.allSortedRefs;
            AstProgram astProgram = program;
            AstReferences astReferences2 = astReferences;
            object = astReferences;
            astDependencyAnalyzerGen = this;
            Object object2 = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                FqName fqName = (FqName)item$iv$iv;
                collection = destination$iv$iv;
                AstType.REF rEF = new AstType.REF((FqName)it);
                collection.add(rEF);
            }
            collection = (List)destination$iv$iv;
            Set set3 = CollectionsKt.toSet((Iterable)this.methods);
            object2 = CollectionsKt.toSet((Iterable)this.fields);
            astReferences2(astProgram, set2, set, CollectionsKt.toSet((Iterable)collection), set3, (Set<AstFieldRef>)object2);
            astDependencyAnalyzerGen.references = object;
        }

        public /* synthetic */ AstDependencyAnalyzerGen(AstProgram astProgram, AstBody astBody, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = null;
            }
            this(astProgram, astBody, string);
        }
    }
}

