/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.ast.serialization;

import com.jtransc.ast.AstBinop;
import com.jtransc.ast.AstExpr;
import com.jtransc.ast.AstStm;
import com.jtransc.ast.AstTypes;
import com.jtransc.ast.FqName;
import com.jtransc.error.ErrorsKt;
import com.jtransc.io.StreamKt;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jtransc/ast/serialization/AstRead;", "", "types", "Lcom/jtransc/ast/AstTypes;", "(Lcom/jtransc/ast/AstTypes;)V", "current", "Lcom/jtransc/ast/FqName;", "getCurrent", "()Lcom/jtransc/ast/FqName;", "getTypes", "()Lcom/jtransc/ast/AstTypes;", "readBinop", "Lcom/jtransc/ast/AstExpr;", "s", "Ljava/io/InputStream;", "op", "Lcom/jtransc/ast/AstBinop;", "readExpr", "readStm", "Lcom/jtransc/ast/AstStm;", "jtransc-core_main"})
public final class AstRead {
    @NotNull
    private final FqName current;
    @NotNull
    private final AstTypes types;

    @NotNull
    public final FqName getCurrent() {
        return this.current;
    }

    @NotNull
    public final AstExpr readBinop(@NotNull InputStream s, @NotNull AstBinop op) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)((Object)op), (String)"op");
        AstExpr l = this.readExpr(s);
        AstExpr r = this.readExpr(s);
        return new AstExpr.BINOP(l.getType(), l, AstBinop.ADD, r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final AstStm readStm(@NotNull InputStream s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        switch (StreamKt.i8((InputStream)s)) {
            case 0: {
                return new AstStm.STM_EXPR(this.readExpr(s));
            }
            default: {
                AstStm astStm = (AstStm)((Object)ErrorsKt.getNoImpl());
                throw null;
            }
        }
    }

    @NotNull
    public final AstExpr readExpr(@NotNull InputStream s) {
        AstExpr astExpr;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        switch (StreamKt.i8((InputStream)s)) {
            case 0: {
                astExpr = new AstExpr.THIS(this.current);
                break;
            }
            case 3: {
                astExpr = new AstExpr.LITERAL((Object)false);
                break;
            }
            case 2: {
                astExpr = new AstExpr.LITERAL((Object)true);
                break;
            }
            case 100: {
                astExpr = this.readBinop(s, AstBinop.ADD);
                break;
            }
            case 101: {
                astExpr = this.readBinop(s, AstBinop.SUB);
                break;
            }
            default: {
                AstExpr astExpr2 = (AstExpr)((Object)ErrorsKt.getNoImpl());
                throw null;
            }
        }
        return astExpr;
    }

    @NotNull
    public final AstTypes getTypes() {
        return this.types;
    }

    public AstRead(@NotNull AstTypes types) {
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        this.types = types;
        this.current = new FqName("java.lang.Object");
    }
}

