/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.backend;

import com.jtransc.ast.AstAnnotation;
import com.jtransc.ast.AstBody;
import com.jtransc.ast.AstClass;
import com.jtransc.ast.AstClassGenerator;
import com.jtransc.ast.AstField;
import com.jtransc.ast.AstFieldRef;
import com.jtransc.ast.AstMethod;
import com.jtransc.ast.AstMethodRef;
import com.jtransc.ast.AstModifiers;
import com.jtransc.ast.AstProgram;
import com.jtransc.ast.AstType;
import com.jtransc.ast.AstTypes;
import com.jtransc.ast.Ast_typeKt;
import com.jtransc.ast.FqName;
import com.jtransc.backend.AsmToAstKt;
import com.jtransc.error.ErrorsKt;
import com.jtransc.injector.Singleton;
import com.jtransc.org.objectweb.asm.ClassReader;
import com.jtransc.org.objectweb.asm.ClassVisitor;
import com.jtransc.org.objectweb.asm.tree.ClassNode;
import com.jtransc.org.objectweb.asm.tree.FieldNode;
import com.jtransc.org.objectweb.asm.tree.MethodNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lcom/jtransc/backend/BaseAsmToAst;", "Lcom/jtransc/ast/AstClassGenerator;", "types", "Lcom/jtransc/ast/AstTypes;", "(Lcom/jtransc/ast/AstTypes;)V", "expandFrames", "", "getExpandFrames", "()Z", "getTypes", "()Lcom/jtransc/ast/AstTypes;", "genBody", "Lcom/jtransc/ast/AstBody;", "classRef", "Lcom/jtransc/ast/AstType$REF;", "methodNode", "Lcom/jtransc/org/objectweb/asm/tree/MethodNode;", "source", "", "generateClass", "Lcom/jtransc/ast/AstClass;", "program", "Lcom/jtransc/ast/AstProgram;", "fqname", "Lcom/jtransc/ast/FqName;", "generateField", "Lcom/jtransc/ast/AstField;", "containingClass", "field", "Lcom/jtransc/org/objectweb/asm/tree/FieldNode;", "generateMethod", "Lcom/jtransc/ast/AstMethod;", "method", "jtransc-core_main"})
public abstract class BaseAsmToAst
implements AstClassGenerator {
    private final boolean expandFrames = false;
    @NotNull
    private final AstTypes types;

    public boolean getExpandFrames() {
        return this.expandFrames;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AstClass generateClass(@NotNull AstProgram program, @NotNull FqName fqname) {
        IndexedValue it;
        Collection<FqName> collection;
        void $receiver$iv$iv;
        void $receiver$iv22;
        AstClass astClass;
        FqName fqName;
        ClassReader classReader;
        Intrinsics.checkParameterIsNotNull((Object)program, (String)"program");
        Intrinsics.checkParameterIsNotNull((Object)fqname, (String)"fqname");
        try {
            classReader = new ClassReader(program.getClassBytes(fqname));
        }
        catch (IOException e) {
            Void void_ = ErrorsKt.invalidOp$default((String)("generateClass: Can't find class " + fqname), null, (int)2, null);
            throw null;
        }
        ClassReader cr = classReader;
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, this.getExpandFrames() ? 8 : 4);
        String string = classNode.sourceDebug;
        if (string == null) {
            string = classNode.name + ".java";
        }
        String string2 = classNode.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"classNode.name");
        FqName fqName2 = FqName.Companion.fromInternal(string2);
        AstModifiers astModifiers = new AstModifiers(classNode.access);
        List<AstAnnotation> list = AsmToAstKt.getAnnotations(classNode, this.types);
        if (AsmToAstKt.hasSuperclass(classNode) && !AsmToAstKt.isInterface(classNode)) {
            String string3 = classNode.superName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"classNode.superName");
            fqName = FqName.Companion.fromInternal(string3);
        } else {
            fqName = null;
        }
        Iterable iterable = AsmToAstKt.getInterfaces(classNode);
        FqName fqName3 = fqName;
        List<AstAnnotation> list2 = list;
        AstModifiers astModifiers2 = astModifiers;
        FqName fqName4 = fqName2;
        AstProgram astProgram = program;
        String string4 = string;
        AstClass astClass2 = astClass;
        AstClass astClass3 = astClass;
        Iterator iterator2 = $receiver$iv22;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv22, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            String string5 = (String)item$iv$iv;
            collection = destination$iv$iv;
            FqName fqName5 = FqName.Companion.fromInternal((String)it2);
            collection.add(fqName5);
        }
        collection = (List)destination$iv$iv;
        int $receiver$iv22 = 0;
        iterator2 = collection;
        destination$iv$iv = fqName3;
        List<AstAnnotation> list3 = list2;
        astClass2(string4, astProgram, fqName4, astModifiers2, (FqName)destination$iv$iv, (List)((Object)iterator2), list3, $receiver$iv22, 128, null);
        AstClass astClass4 = astClass3;
        program.add(astClass4);
        Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)AsmToAstKt.getMethods(classNode));
        for (Object element$iv : $receiver$iv) {
            it = (IndexedValue)element$iv;
            astClass4.add(this.generateMethod(astClass4, (MethodNode)it.getValue()));
        }
        $receiver$iv = CollectionsKt.withIndex((Iterable)AsmToAstKt.getFields(classNode));
        for (Object element$iv : $receiver$iv) {
            it = (IndexedValue)element$iv;
            astClass4.add(this.generateField(astClass4, (FieldNode)it.getValue()));
        }
        return astClass4;
    }

    @NotNull
    public final AstMethod generateMethod(@NotNull AstClass containingClass, @NotNull MethodNode method2) {
        Intrinsics.checkParameterIsNotNull((Object)containingClass, (String)"containingClass");
        Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method");
        AstModifiers mods = new AstModifiers(method2.access);
        AstMethodRef methodRef = AsmToAstKt.astRef(method2, containingClass.getRef(), this.types);
        List<AstAnnotation> list = AsmToAstKt.getAnnotations(method2, this.types);
        List<List<AstAnnotation>> list2 = AsmToAstKt.getParameterAnnotations(method2, this.types);
        String string = method2.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        AstMethodRef astMethodRef = null;
        Function0 function0 = (Function0)new Function0<AstBody>(this, mods, containingClass, method2){
            final /* synthetic */ BaseAsmToAst this$0;
            final /* synthetic */ AstModifiers $mods;
            final /* synthetic */ AstClass $containingClass;
            final /* synthetic */ MethodNode $method;

            @Nullable
            public final AstBody invoke() {
                AstBody astBody;
                if (this.$mods.isConcrete()) {
                    AstBody astBody2;
                    try {
                        astBody2 = this.this$0.genBody(this.$containingClass.getRef(), this.$method, this.this$0.getTypes(), this.$containingClass.getSource());
                    }
                    catch (Throwable e) {
                        String string = "Error trying to generate " + this.$containingClass.getName() + "::" + this.$method.name + " " + this.$method.desc;
                        System.out.println((Object)string);
                        e.printStackTrace();
                        astBody2 = null;
                    }
                    astBody = astBody2;
                } else {
                    astBody = null;
                }
                return astBody;
            }
            {
                this.this$0 = baseAsmToAst;
                this.$mods = astModifiers;
                this.$containingClass = astClass;
                this.$method = methodNode;
                super(0);
            }
        };
        AstTypes astTypes = this.types;
        AstMethodRef astMethodRef2 = null;
        AstModifiers astModifiers = mods;
        Object object = AsmToAstKt.AstAnnotationValue(method2.annotationDefault, true, this.types);
        String string2 = method2.signature;
        String string3 = Ast_typeKt.mangle$default(methodRef.getType(), false, 1, null);
        AstType.METHOD mETHOD = methodRef.getType();
        String string4 = string;
        List<List<AstAnnotation>> list3 = list2;
        List<AstAnnotation> list4 = list;
        return new AstMethod(containingClass, 0, string4, mETHOD, list4, string3, string2, object, astModifiers, function0, astMethodRef2, list3, astTypes, astMethodRef, 9218, null);
    }

    @NotNull
    public abstract AstBody genBody(@NotNull AstType.REF var1, @NotNull MethodNode var2, @NotNull AstTypes var3, @NotNull String var4);

    @NotNull
    public final AstField generateField(@NotNull AstClass containingClass, @NotNull FieldNode field) {
        Intrinsics.checkParameterIsNotNull((Object)containingClass, (String)"containingClass");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        String string = field.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"field.name");
        List<AstAnnotation> list = AsmToAstKt.getAnnotations(field, this.types);
        String string2 = field.desc;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"field.desc");
        AstType astType = this.types.demangle(string2);
        String string3 = field.desc;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"field.desc");
        AstFieldRef astFieldRef = null;
        AstTypes astTypes = this.types;
        Object object = field.value;
        AstModifiers astModifiers = new AstModifiers(field.access);
        String string4 = field.signature;
        String string5 = string3;
        AstType astType2 = astType;
        List<AstAnnotation> list2 = list;
        return new AstField(containingClass, 0, string, astType2, astModifiers, string5, list2, string4, object, astTypes, astFieldRef, 1026, null);
    }

    @NotNull
    public final AstTypes getTypes() {
        return this.types;
    }

    public BaseAsmToAst(@NotNull AstTypes types) {
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        this.types = types;
    }
}

