/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.graph;

import com.jtransc.error.ErrorsKt;
import com.jtransc.graph.AcyclicDigraph;
import com.jtransc.graph.Digraph;
import com.jtransc.graph.StrongComponent;
import com.jtransc.graph.StrongComponentKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/jtransc/graph/AcyclicDigraphImpl;", "T", "Lcom/jtransc/graph/AcyclicDigraph;", "graph", "Lcom/jtransc/graph/Digraph;", "(Lcom/jtransc/graph/Digraph;)V", "getGraph", "()Lcom/jtransc/graph/Digraph;", "nodeIndices", "", "", "getNodeIndices", "()Ljava/util/Map;", "nodes", "", "getNodes", "()Ljava/util/List;", "getOut", "node", "jtransc-core_main"})
public final class AcyclicDigraphImpl<T>
implements AcyclicDigraph<T> {
    @NotNull
    private final List<T> nodes;
    @NotNull
    private final Map<T, Integer> nodeIndices;
    @NotNull
    private final Digraph<T> graph;

    @Override
    @NotNull
    public List<T> getNodes() {
        return this.nodes;
    }

    @Override
    @NotNull
    public Map<T, Integer> getNodeIndices() {
        return this.nodeIndices;
    }

    @Override
    @NotNull
    public List<Integer> getOut(int node) {
        return this.graph.getOut(node);
    }

    @NotNull
    public final Digraph<T> getGraph() {
        return this.graph;
    }

    public AcyclicDigraphImpl(@NotNull Digraph<T> graph2) {
        Intrinsics.checkParameterIsNotNull(graph2, (String)"graph");
        this.graph = graph2;
        this.nodes = this.graph.getNodes();
        this.nodeIndices = this.graph.getNodeIndices();
        for (StrongComponent<T> c : StrongComponentKt.tarjanStronglyConnectedComponentsAlgorithm(this.graph).getComponents()) {
            if (c.getIndices().size() == 1) continue;
            Void void_ = ErrorsKt.invalidOp$default((String)"Cyclic graph", null, (int)2, null);
            throw null;
        }
    }

    @Override
    public int getSize() {
        return AcyclicDigraph.DefaultImpls.getSize(this);
    }
}

